/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.cli;

import conexp.fx.core.algorithm.nextclosures.NextClosures2Bit;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.exporter.CXTExporter;
import conexp.fx.core.importer.CXTImporter;
import conexp.fx.gui.ConExpFX;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class CLI {
    private final CommandLine commandLine;
    private MatrixContext<String, String> cxt;
    private Set<Concept<String, String>> concepts;
    private Set<Implication<String, String>> implications;
    private ConceptLattice<String, String> lattice;
    private final Options OPTIONS = new Options();
    private final Option HELP;
    private final Option IMPORT_CXT;
    private final Option CALC_CONCEPTS;
    private final Option CALC_NEIGHBORHOOD;
    private final Option CALC_IMPLICATIONS;
    private final Option PRINT_TO_CONSOLE;
    private final Option WRITE_TO_FILE;
    private final Option GUI;

    public static void main(String[] args) throws Exception {
        new CLI(args);
    }

    private CLI(String[] args) throws Exception {
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"showHelp");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"shows available command line options and their arguments.");
        this.HELP = OptionBuilder.create((String)"help");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"importContextFromCXT");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"imports formal context file in Burmeister formatting (*.cxt)");
        this.IMPORT_CXT = OptionBuilder.create((String)"import");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"calculateConcepts");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"computes all formal concepts");
        this.CALC_CONCEPTS = OptionBuilder.create((String)"concepts");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"calculateNeighborhood");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"computes the neighborhood relation");
        this.CALC_NEIGHBORHOOD = OptionBuilder.create((String)"lattice");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"calculateImplications");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"computes implicational base");
        this.CALC_IMPLICATIONS = OptionBuilder.create((String)"implications");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"printToConsole");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"prints all results to console");
        this.PRINT_TO_CONSOLE = OptionBuilder.create((String)"print");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"writeToFile");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"writes all results to files");
        this.WRITE_TO_FILE = OptionBuilder.create((String)"write");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"starts the JavaFX gui");
        OptionBuilder.withLongOpt((String)"startGUI");
        this.GUI = OptionBuilder.create((String)"gui");
        this.OPTIONS.addOption(this.GUI);
        this.OPTIONS.addOption(this.HELP);
        this.OPTIONS.addOption(this.IMPORT_CXT);
        this.OPTIONS.addOption(this.CALC_CONCEPTS);
        this.OPTIONS.addOption(this.CALC_NEIGHBORHOOD);
        this.OPTIONS.addOption(this.CALC_IMPLICATIONS);
        this.OPTIONS.addOption(this.PRINT_TO_CONSOLE);
        this.OPTIONS.addOption(this.WRITE_TO_FILE);
        try {
            this.commandLine = new DefaultParser().parse(this.OPTIONS, args);
        }
        catch (ParseException e) {
            this.printHelp();
            throw new RuntimeException("Unable to parse command line arguments. Please check supplied arguments!", e);
        }
        if (!this.commandLine.getArgList().isEmpty()) {
            this.printHelp();
            throw new RuntimeException("Unrecognized Arguments: " + this.commandLine.getArgList());
        }
        this.execute();
    }

    private final void printHelp() {
        new HelpFormatter().printHelp(120, "java -jar conexp-fx-VERSION-jar-with_dependencies.jar [OPTIONS]", "Available command line options for Concept Explorer FX", this.OPTIONS, "");
    }

    private final void execute() throws Exception {
        if (this.commandLine.getOptions().length == 0 || this.commandLine.hasOption(this.GUI.getLongOpt())) {
            ConExpFX.main(new String[0]);
        } else if (this.commandLine.hasOption(this.HELP.getLongOpt())) {
            this.printHelp();
        } else {
            Consumer<Double> c4;
            Consumer<String> c3;
            Consumer c2;
            Consumer c1;
            if (this.commandLine.hasOption(this.PRINT_TO_CONSOLE.getLongOpt())) {
                c1 = System.out::println;
                c2 = System.out::println;
                c3 = System.out::println;
                c4 = System.out::println;
            } else {
                c1 = __ -> {};
                c2 = __ -> {};
                c3 = __ -> {};
                c4 = __ -> {};
            }
            if (!this.commandLine.hasOption(this.IMPORT_CXT.getLongOpt())) {
                throw new IllegalArgumentException("Unable to instanciate FCA service without formal context. Please specify a file in Burmeister formatting by adding a command line prefix\r\n\t--importContextFromCXT <path_to_file>");
            }
            File input = new File(this.commandLine.getOptionValue(this.IMPORT_CXT.getLongOpt()));
            this.cxt = CXTImporter.read(input);
            if (this.commandLine.hasOption(this.CALC_CONCEPTS.getLongOpt()) || this.commandLine.hasOption(this.CALC_IMPLICATIONS.getLongOpt()) || this.commandLine.hasOption(this.CALC_NEIGHBORHOOD.getLongOpt())) {
                Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> result = NextClosures2Bit.bitCompute(this.cxt, Executors.newWorkStealingPool(), c1, c2, c3, c4, () -> false);
                this.concepts = result.first();
                this.implications = result.second();
            }
            if (this.commandLine.hasOption(this.CALC_NEIGHBORHOOD.getLongOpt())) {
                // empty if block
            }
            if (this.commandLine.hasOption(this.WRITE_TO_FILE.getLongOpt())) {
                String filename = input.getName().substring(0, input.getName().lastIndexOf("."));
                if (this.concepts != null) {
                    Collections3.writeToFile(new File(input.getParentFile(), filename + ".concepts"), this.concepts, "Formal Concepts of " + input.getAbsolutePath(), new String[0]);
                }
                if (this.implications != null) {
                    Collections3.writeToFile(new File(input.getParentFile(), filename + ".implications"), this.implications, "Implications of " + input.getAbsolutePath(), new String[0]);
                }
                if (this.lattice != null) {
                    CXTExporter.export(this.lattice, new File(input.getParentFile(), filename + ".lattice"));
                }
            }
        }
    }
}

