/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.exploration;

import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CounterExample<G, M> {
    private final G object;
    private final Set<M> attributes;

    @SafeVarargs
    public CounterExample(G object, M ... attributes) {
        this(object, (Collection<M>)Arrays.asList(attributes));
    }

    public CounterExample(G object, Collection<M> attributes) {
        this.object = object;
        this.attributes = new HashSet<M>(attributes);
    }

    public final G getObject() {
        return this.object;
    }

    public final Set<M> getAttributes() {
        return this.attributes;
    }

    public final void insertIn(Context<G, M> cxt) {
        cxt.rowHeads().add(this.object);
        cxt.row(this.object).addAll(this.attributes);
    }

    public final void addTo(Implication<G, M> implication) {
        implication.getSupport().add(this.object);
        implication.getConclusion().retainAll(this.attributes);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof CounterExample)) {
            return false;
        }
        CounterExample that = (CounterExample)obj;
        return this.object.equals(that.object) && this.attributes.equals(that.attributes);
    }

    public final int hashCode() {
        return this.object.hashCode() + this.attributes.hashCode();
    }

    public final String toString() {
        return "counter-example (" + this.object + "): " + this.attributes;
    }
}

