/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.exploration;

import conexp.fx.core.algorithm.exploration.Expert;
import conexp.fx.core.algorithm.nextclosures.NextClosuresState;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.math.ClosureOperator;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.exploration.HumanExpertP;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ParallelAttributeExploration {
    public static final <M> Set<Implication<String, M>> explore(Context<String, M> cxt, Set<Implication<String, M>> backgroundKnowledge, Expert<String, M> expert, ExecutorService executor, Consumer<Implication<String, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled) {
        ClosureOperator clop;
        if (!cxt.models(backgroundKnowledge, new boolean[0])) {
            throw new IllegalArgumentException("Background knowledge does not hold in formal context");
        }
        NextClosuresState result = NextClosuresState.withHashSets(cxt.colHeads());
        int maxCardinality = cxt.colHeads().size();
        ClosureOperator<Object> closureOperator = clop = backgroundKnowledge == null || backgroundKnowledge.isEmpty() ? ClosureOperator.fromImplications(result.implications, true, false) : ClosureOperator.supremum(ClosureOperator.fromImplications(result.implications, true, false), ClosureOperator.fromImplications(backgroundKnowledge, false, false));
        while (result.cardinality <= maxCardinality && !isCancelled.get().booleanValue()) {
            double q = (double)result.cardinality / (double)maxCardinality;
            int p = (int)(100.0 * q);
            updateStatus.accept("current cardinality: " + result.cardinality + "/" + maxCardinality + " (" + p + "%)");
            updateProgress.accept(q);
            Set<Future> futures = Collections3.newConcurrentHashSet();
            result.candidates.keySet().parallelStream().filter(c -> c.size() == result.cardinality).forEach(candidate -> futures.add(executor.submit(() -> {
                Set closure = clop.closure(candidate);
                if (closure.size() == candidate.size()) {
                    Set candidateI = cxt.colAnd((Collection<?>)candidate);
                    Set candidateII = cxt.rowAnd(candidateI);
                    if (candidateII.size() != candidate.size()) {
                        candidateII.removeAll((Collection<?>)candidate);
                        Implication implication = new Implication(candidate, candidateII, candidateI);
                        try {
                            Set<Object> counterExamples = Collections.emptySet();
                            do {
                                if ((counterExamples = expert.getCounterExamples(implication)).isEmpty()) continue;
                                counterExamples.forEach(cex -> Platform2.runOnFXThreadAndWaitTryCatch(() -> {
                                    cex.insertIn(cxt);
                                    cex.addTo(implication);
                                }));
                            } while (!implication.isTrivial() && !counterExamples.isEmpty());
                        }
                        catch (InterruptedException __) {
                            result.cardinality = maxCardinality;
                        }
                        if (!implication.isTrivial()) {
                            result.implications.add(implication);
                            implicationConsumer.accept(implication);
                        }
                        HashSet intent = new HashSet();
                        intent.addAll(implication.getPremise());
                        intent.addAll(implication.getConclusion());
                        result.addNewCandidates(intent);
                    } else {
                        result.addNewCandidates(candidate);
                    }
                } else {
                    result.candidates.put(closure, result.cardinality);
                }
                result.candidates.remove(candidate);
            })));
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
            ++result.cardinality;
        }
        updateStatus.accept(result.implications.size() + " implications found");
        return result.implications;
    }

    public static final <M> TimeTask<?> createExplorationTask(final FCADataset<String, M> dataset) {
        return new TimeTask<Void>(dataset, "ParallelExploration"){

            protected Void call() throws Exception {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                HumanExpertP humexp = new HumanExpertP(dataset.context.selection);
                Platform2.runOnFXThreadAndWaitTryCatch(() -> {
                    humexp.init();
                    humexp.show();
                });
                ParallelAttributeExploration.explore(dataset.context.getSelection(), Collections.emptySet(), humexp, ConExpFX.instance.executor.tpe, implication -> Platform2.runOnFXThread(() -> dataset2.implications.add((Object)implication)), status -> this.updateMessage((String)status), progress -> this.updateProgress((double)progress, 1.0), () -> this.isCancelled());
                Platform2.runOnFXThreadAndWaitTryCatch(() -> humexp.hide());
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }
}

