/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.lattice;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.layout.LayoutEvolution;
import conexp.fx.core.layout.QualityMeasure;
import conexp.fx.gui.task.TimeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.Binding;
import javafx.collections.ObservableMap;
import javafx.geometry.Point3D;

public final class IFox2<G, M> {
    private static final <G, M> Attribute<M> attribute(MatrixContext<G, M> context, M m) {
        int _m = context.selection.colHeads().indexOf(m);
        for (Set set : context.selection._attributes) {
            if (!set.contains(_m)) continue;
            if (set.size() > 1) {
                return new Attribute(Type.EQUIVALENT, new Collection[]{Collections2.transform((Collection)Sets.difference((Set)set, Collections.singleton(_m)), context.selection.colHeads().indexGuava().inverse())});
            }
            if (context.selection._irreducibleAttributes.contains(set)) {
                return new Attribute(Type.IRREDUCIBLE, new Collection[0]);
            }
            return new Attribute(Type.REDUCIBLE, new Collection[0]);
        }
        return null;
    }

    private static final <G, M> void adjust(AdditiveConceptLayout<G, M> layout, M m, QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance, AbstractExecutorService tpe) {
        LayoutEvolution.Value v = new LayoutEvolution<G, M>(layout, (Concept)layout.lattice.attributeConcepts.get(m), ConceptMovement.INTENT_CHAIN_SEEDS, 2.0, 2.0, 1, 1, 1, conflictDistance, tpe).calculate();
        layout.updateSeeds(v.seedsG, v.seedsM);
    }

    public static final <G, M> TimeTask<Void> select(String id, final AdditiveConceptLayout<G, M> layout, final M m, QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance, ExecutorService tpe) {
        return new TimeTask<Void>(id + " - iFox Select"){
            private MatrixContext<G, M> I;
            private MatrixContext<G, M> IuJ;
            private Set<G> mJ;
            private Attribute<M> attribute;

            protected Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Calculating Incremental Update...");
                this.I = layout.lattice.context.selection;
                this.mJ = new HashSet(layout.lattice.context.col(m));
                layout.lattice.context.selectAttribute(m);
                this.IuJ = layout.lattice.context.selection;
                this.attribute = IFox2.attribute(layout.lattice.context.selection, m);
                switch (this.attribute.type) {
                    case EQUIVALENT: {
                        this.equivalent();
                        break;
                    }
                    case REDUCIBLE: {
                        this.reducible();
                        break;
                    }
                    case IRREDUCIBLE: {
                        this.irreducible();
                    }
                }
                layout.invalidate();
                layout.lattice.pushAllChangedEvent();
                this.updateProgress(1.0, 1.0);
                return null;
            }

            private void equivalent() {
                this.reducible();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void reducible() {
                for (Concept c : layout.lattice.rowHeads()) {
                    if (!this.mJ.containsAll((Collection<?>)c.extent())) continue;
                    c.intent().add(m);
                    if (this.mJ.size() != c.extent().size()) continue;
                    ObservableMap observableMap = layout.lattice.attributeConcepts;
                    synchronized (observableMap) {
                        layout.lattice.attributeConcepts.put(m, (Object)c);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void irreducible() {
                this.updateMessage("Determining old, varying and generating concepts...");
                this.updateProgress(0.1, 1.0);
                Set vars = layout.lattice.rowHeads().stream().filter(c -> this.mJ.containsAll((Collection<?>)c.extent())).collect(Collectors.toSet());
                Set olds = layout.lattice.rowHeads().stream().filter(c -> !vars.contains(c)).collect(Collectors.toSet());
                Set gens = olds.stream().filter(c -> this.I.rowAnd((Collection<?>)Sets.intersection(c.extent(), this.mJ)).equals(c.intent())).collect(Collectors.toSet());
                HashMap<Object, Concept> news = new HashMap<Object, Concept>(gens.size());
                this.updateMessage("Updating varying concepts...");
                this.updateProgress(0.2, 1.0);
                for (Concept v : vars) {
                    v.intent().add(m);
                    for (Concept concept : gens) {
                        layout.lattice.remove(v, concept);
                    }
                }
                this.updateMessage("Creating new concepts...");
                this.updateProgress(0.3, 1.0);
                double i = 0.0;
                for (Concept concept : gens) {
                    double d = i;
                    i = d + 1.0;
                    this.updateProgress(0.3 + 0.25 * (d / (double)gens.size()), 1.0);
                    HashSet gol = new HashSet(layout.lattice.objectLabels(concept));
                    Object n = concept.clone();
                    ((Concept)n).extent().retainAll(this.mJ);
                    ((Concept)n).intent().add(m);
                    news.put(n, concept);
                    Object object = layout.generators;
                    synchronized (object) {
                        layout.generators.put(n, concept);
                    }
                    layout.lattice.rowHeads().add(n);
                    layout.lattice.addFast(n, concept);
                    if (concept.extent().containsAll(this.mJ)) {
                        object = layout.lattice.attributeConcepts;
                        synchronized (object) {
                            layout.lattice.attributeConcepts.put(m, n);
                        }
                    }
                    for (Object ol : Sets.intersection((Set)gol, this.mJ)) {
                        ObservableMap observableMap = layout.lattice.objectConcepts;
                        synchronized (observableMap) {
                            layout.lattice.objectConcepts.put(ol, n);
                        }
                    }
                    for (Concept v : vars) {
                        if (!v.smaller(concept) || !Stream.concat(gens.stream(), vars.stream()).noneMatch(c -> v.smaller(c) && c.smaller(g2))) continue;
                        layout.lattice.addFast(v, n);
                    }
                }
                this.updateMessage("Creating new concepts neighborhood...");
                this.updateProgress(0.55, 1.0);
                i = 0.0;
                for (Map.Entry entry : news.entrySet()) {
                    for (Map.Entry n2 : news.entrySet()) {
                        double d = i;
                        i = d + 1.0;
                        this.updateProgress(0.55 + 0.25 * (d / Math.pow(news.size(), 2.0)), 1.0);
                        if (!((Concept)entry.getValue()).smaller((Concept)n2.getValue()) || !gens.stream().noneMatch(c -> ((Concept)n1.getValue()).smaller(c) && c.smaller((Concept)n2.getValue()))) continue;
                        layout.lattice.addFast(entry.getKey(), n2.getKey());
                    }
                }
                this.updateMessage("Updating seeds...");
                this.updateProgress(0.8, 1.0);
                Iterator<Object> iterator = layout.seedsM;
                synchronized (iterator) {
                    this.updateMessage("Determining new Reducibles...");
                    for (Object n : layout.seedsM.keySet()) {
                        int _n = this.IuJ.colHeads().indexOf(n);
                        Set eq2 = this.IuJ._attributes.stream().filter(c -> c.contains(_n)).findAny().get();
                        if (this.IuJ._irreducibleAttributes.contains(eq2)) continue;
                        this.updateMessage("Backup seed: " + n);
                        Point3D oldSeed = (Point3D)layout.seedsM.remove(n);
                        layout.seedHistoryM.put(n, oldSeed);
                    }
                    if (layout.seedHistoryM.containsKey(m) && !layout.seedsM.values().contains(layout.seedHistoryM.get(m))) {
                        this.updateMessage("Restoring seed: " + m);
                        layout.seedsM.put(m, (Object)layout.seedHistoryM.get(m));
                    } else {
                        this.updateMessage("Computing random seed: " + m);
                        layout.seedsM.put(m, (Object)new Point3D(1.0 + Math.random(), 0.5 + Math.random(), 0.0));
                    }
                }
                iterator = layout.seedsG;
                synchronized (iterator) {
                    this.IuJ._irreducibleObjects.stream().filter(eq -> eq.stream().map(this.IuJ.rowHeads()::get).filter(((Predicate<Object>)arg_0 -> layout2.seedsG.containsKey(arg_0)).negate()).findAny().isPresent()).map(arg_0 -> this.IuJ._firstObject.apply(arg_0)).forEach(g -> {
                        Point3D cfr_ignored_0 = (Point3D)layout2.seedsG.put(g, (Object)new Point3D(1.0 + Math.random(), 0.5 + Math.random(), 0.0));
                    });
                    layout.seedsG.keySet().removeIf(g -> !this.IuJ._irreducibleObjects.contains(this.IuJ._objects.stream().filter(c -> c.contains(this.IuJ.rowHeads().indexOf(g))).findAny().get()));
                }
                this.updateProgress(0.9, 1.0);
                this.updateMessage("Adjusting Layout...");
            }
        };
    }

    public static final <G, M> TimeTask<Void> ignore(String id, final AdditiveConceptLayout<G, M> layout, final M m, QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance, ExecutorService tpe) {
        return new TimeTask<Void>(id + " - iFox Ignore"){
            private MatrixContext<G, M> I;
            private Attribute<M> attribute;

            protected Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Calculating Incremental Update...");
                this.attribute = IFox2.attribute(layout.lattice.context.selection, m);
                layout.lattice.context.deselectAttribute(m);
                this.I = layout.lattice.context.selection;
                switch (this.attribute.type) {
                    case EQUIVALENT: {
                        this.equivalent();
                        break;
                    }
                    case REDUCIBLE: {
                        this.reducible();
                        break;
                    }
                    case IRREDUCIBLE: {
                        this.irreducible();
                    }
                }
                layout.lattice.pushAllChangedEvent();
                layout.invalidate();
                this.updateProgress(1.0, 1.0);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void equivalent() {
                Object object = layout.lattice.attributeConcepts;
                synchronized (object) {
                    layout.lattice.attributeConcepts.remove(m);
                }
                for (Concept c : layout.lattice.rowHeads()) {
                    c.intent().remove(m);
                }
                object = layout.seedsM;
                synchronized (object) {
                    Point3D seed = (Point3D)layout.seedsM.remove(m);
                    if (seed != null) {
                        layout.seedHistoryM.put(m, seed);
                        Object n = this.attribute.equivalents.iterator().next();
                        layout.seedsM.put(n, (Object)seed);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void reducible() {
                ObservableMap observableMap = layout.lattice.attributeConcepts;
                synchronized (observableMap) {
                    layout.lattice.attributeConcepts.remove(m);
                }
                for (Concept c : layout.lattice.rowHeads()) {
                    c.intent().remove(m);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void irreducible() {
                this.updateMessage("Determining old, varying and generating concepts...");
                this.updateProgress(0.1, 1.0);
                Set olds = layout.lattice.rowHeads().stream().filter(c -> !c.intent().contains(m)).collect(Collectors.toSet());
                Set vars = layout.lattice.rowHeads().stream().filter(c -> !olds.contains(c) && c.extent().equals(this.I.colAnd((Collection<?>)Sets.difference(c.intent(), Collections.singleton(m))))).collect(Collectors.toSet());
                Set _news = layout.lattice.rowHeads().stream().filter(c -> !olds.contains(c) && !vars.contains(c)).collect(Collectors.toSet());
                this.updateMessage("Computing generating concepts...");
                this.updateProgress(0.2, 1.0);
                ObservableMap observableMap = layout.lattice.attributeConcepts;
                synchronized (observableMap) {
                    layout.lattice.attributeConcepts.remove(m);
                }
                HashMap<Concept, Concept> news = new HashMap<Concept, Concept>();
                for (Concept n : _news) {
                    Concept concept = olds.stream().filter(c -> c.intent().equals(Sets.difference(n.intent(), Collections.singleton(m)))).findAny().get();
                    Object object = layout.lattice.objectConcepts;
                    synchronized (object) {
                        HashSet nol = new HashSet(layout.lattice.objectLabels(n));
                        for (Object ol : nol) {
                            layout.lattice.objectConcepts.put(ol, (Object)concept);
                        }
                    }
                    news.put(n, concept);
                    object = layout.generators;
                    synchronized (object) {
                        layout.generators.put(n, concept);
                    }
                }
                Set oldNonGens = olds.stream().filter(c -> !news.values().contains(c)).collect(Collectors.toSet());
                this.updateMessage("Updating varying concepts...");
                this.updateProgress(0.3, 1.0);
                for (Concept concept : vars) {
                    concept.intent().remove(m);
                }
                for (Map.Entry entry : news.entrySet()) {
                    for (Concept v : vars) {
                        if (!layout.lattice.contains(v, entry.getKey()) || !oldNonGens.stream().noneMatch(c -> v.smaller(c) && c.smaller((Concept)n.getValue()))) continue;
                        layout.lattice.addFast(v, entry.getValue());
                    }
                }
                this.updateMessage("Removing concepts...");
                for (Concept concept : news.keySet()) {
                    for (Concept z : layout.lattice.row(concept)) {
                        layout.lattice.remove(concept, z);
                    }
                    for (Concept z : layout.lattice.col(concept)) {
                        layout.lattice.remove(z, concept);
                    }
                    layout.lattice.rowHeads().remove(concept);
                }
                this.updateMessage("Updating seeds...");
                this.updateProgress(0.6, 1.0);
                Iterator<Object> iterator = layout.seedsM;
                synchronized (iterator) {
                    this.updateMessage("Backup seed: " + m);
                    Point3D point3D = (Point3D)layout.seedsM.remove(m);
                    layout.seedHistoryM.put(m, point3D);
                    HashSet _seeds = new HashSet(Collections2.transform((Collection)layout.seedsM.keySet(), this.I.colHeads().indexGuava()));
                    block23: for (Set set : this.I._irreducibleAttributes) {
                        if (Iterables.any(_seeds, (com.google.common.base.Predicate)Predicates.in((Collection)set))) continue;
                        for (Object n : Collections2.transform((Collection)set, this.I.colHeads().indexGuava().inverse())) {
                            Concept nc = this.I.attributeConcept(n);
                            if (layout.getPosition(nc) == null) continue;
                            Point3D np = (Point3D)((Binding)layout.getPosition(nc)).getValue();
                            Point3D nnp = (Point3D)((Binding)layout.getPosition((Concept)Iterables.getOnlyElement(layout.lattice.row(nc)))).getValue();
                            Point3D seed = np.subtract(nnp);
                            layout.seedsM.put(n, (Object)seed);
                            this.updateProgress(0.8, 1.0);
                            this.updateMessage("Adjusting Layout...");
                            continue block23;
                        }
                    }
                }
                iterator = layout.seedsG;
                synchronized (iterator) {
                    this.I._irreducibleObjects.stream().filter(eq -> eq.stream().map(this.I.rowHeads()::get).filter(((Predicate<Object>)arg_0 -> layout2.seedsG.containsKey(arg_0)).negate()).findAny().isPresent()).map(arg_0 -> this.I._firstObject.apply(arg_0)).forEach(g -> {
                        Point3D cfr_ignored_0 = (Point3D)layout2.seedsG.put(g, (Object)new Point3D(1.0 + Math.random(), 0.5 + Math.random(), 0.0));
                    });
                    layout.seedsG.keySet().removeIf(g -> !this.I._irreducibleObjects.contains(this.I._objects.stream().filter(c -> c.contains(this.I.rowHeads().indexOf(g))).findAny().get()));
                }
                this.updateProgress(0.9, 1.0);
            }
        };
    }

    private static final class Attribute<M> {
        private final Type type;
        private final Set<M> equivalents;

        @SafeVarargs
        private Attribute(Type type, Collection<M> ... equivalents) {
            this.type = type;
            this.equivalents = equivalents.length == 0 ? Collections.emptySet() : new HashSet<M>(equivalents[0]);
        }
    }

    private static enum Type {
        EQUIVALENT,
        REDUCIBLE,
        IRREDUCIBLE;

    }
}

