/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.lattice;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class IPred<G, M> {
    public static final <G, M> TimeTask<Void> neighborhood(String id, final ConceptLattice<G, M> lattice) {
        return new TimeTask<Void>(id + " - iPred"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Computing Concept Neighborhood...");
                lattice.empty();
                int bits = lattice.context.colHeads().size();
                ArrayList intents = new ArrayList(Lists.transform(lattice.rowHeads(), (Function)new Function<Concept<G, M>, BitSetFX>(){

                    public final BitSetFX apply(Concept<G, M> concept) {
                        return lattice.context.colHeads().subBitSet((Collection<?>)concept.intent());
                    }
                }));
                this.updateProgress(0.2, 1.0);
                Iterator intentIterator = intents.iterator();
                ArrayList borderIntents = new ArrayList(intents.size());
                HashMap<BitSetFX, BitSetFX> faceAccumulation = new HashMap<BitSetFX, BitSetFX>(intents.size(), 1.0f);
                for (BitSetFX intent : intents) {
                    faceAccumulation.put(intent, new BitSetFX(bits));
                }
                if (intentIterator.hasNext()) {
                    borderIntents.add(intentIterator.next());
                }
                double total = intents.size();
                double actual = 0.0;
                while (intentIterator.hasNext()) {
                    this.updateProgress(0.3 + 0.7 * ((actual += 1.0) / total), 1.0);
                    this.updateMessage("Computing Neighborhood: " + (int)actual + " of " + (int)total + " Concepts...");
                    BitSetFX intent = (BitSetFX)intentIterator.next();
                    ArrayList<BitSetFX> candidateIntents = new ArrayList<BitSetFX>(borderIntents.size());
                    for (BitSetFX borderIntent : borderIntents) {
                        BitSetFX candidateIntent = (BitSetFX)intent.clone();
                        candidateIntent.and(borderIntent);
                        candidateIntents.add(candidateIntent);
                    }
                    for (BitSetFX candidateIntent : candidateIntents) {
                        BitSetFX candidateFace = (BitSetFX)faceAccumulation.get(candidateIntent);
                        BitSetFX intentFace = (BitSetFX)intent.clone();
                        try {
                            intentFace.and(candidateFace);
                        }
                        catch (Exception e) {
                            System.err.println("intentFace: " + intentFace);
                            System.err.println("candidateFace: " + candidateFace);
                            e.printStackTrace();
                        }
                        if (!intentFace.isEmpty()) continue;
                        lattice._add((int)actual, intents.indexOf(candidateIntent));
                        BitSetFX face = (BitSetFX)intent.clone();
                        face.andNot(candidateIntent);
                        candidateFace.or(face);
                        borderIntents.remove(candidateIntent);
                    }
                    borderIntents.add(intent);
                }
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    public static final <G, M> ConceptLattice<G, M> getConceptLattice(MatrixContext<G, M> cxt, Set<Concept<G, M>> concepts) {
        ConceptLattice<G, M> lattice = new ConceptLattice<G, M>(cxt);
        lattice.rowHeads().addAll(concepts.parallelStream().sorted((c1, c2) -> (int)Math.signum(c1.extent().size() - c2.extent().size())).collect(Collectors.toList()));
        IPred.populateConceptLattice(lattice, __ -> {}, __ -> {}, () -> false);
        return lattice;
    }

    public static final <G, M> void populateConceptLattice(ConceptLattice<G, M> lattice, Consumer<String> messageConsumer, Consumer<Double> statusConsumer, Supplier<Boolean> isCancelled) {
        statusConsumer.accept(0.0);
        if (isCancelled.get().booleanValue()) {
            return;
        }
        messageConsumer.accept("Computing Concept Neighborhood...");
        lattice.empty();
        int bits = lattice.context.colHeads().size();
        List intents = lattice.rowHeads().parallelStream().map(concept -> lattice.context.colHeads().subBitSet((Collection<?>)concept.intent())).collect(Collectors.toList());
        statusConsumer.accept(0.2);
        Iterator intentIterator = intents.iterator();
        ArrayList<Object> borderIntents = new ArrayList<Object>(intents.size());
        Map<BitSetFX, BitSetFX> faceAccumulation = intents.parallelStream().collect(Collectors.toMap(intent -> intent, intent -> new BitSetFX(bits)));
        if (intentIterator.hasNext()) {
            borderIntents.add(intentIterator.next());
        }
        double total = intents.size();
        AtomicDouble actual = new AtomicDouble(0.0);
        while (intentIterator.hasNext() && !isCancelled.get().booleanValue()) {
            actual.set(actual.get() + 1.0);
            statusConsumer.accept(0.3 + 0.7 * (actual.get() / total));
            messageConsumer.accept("Computing Neighborhood: " + (int)actual.get() + " of " + (int)total + " Concepts...");
            BitSetFX intent2 = (BitSetFX)intentIterator.next();
            Set toBeRemoved = Collections3.newConcurrentHashSet();
            borderIntents.parallelStream().map(borderIntent -> {
                BitSetFX candidateIntent = (BitSetFX)intent2.clone();
                candidateIntent.and((BitSetFX)borderIntent);
                return candidateIntent;
            }).forEach(candidateIntent -> {
                BitSetFX candidateFace = (BitSetFX)faceAccumulation.get(candidateIntent);
                BitSetFX intentFace = (BitSetFX)intent2.clone();
                intentFace.and(candidateFace);
                if (intentFace.isEmpty()) {
                    int index = intents.indexOf(candidateIntent);
                    ConceptLattice conceptLattice = lattice;
                    synchronized (conceptLattice) {
                        lattice._add((int)actual.get(), index);
                    }
                    BitSetFX face = (BitSetFX)intent2.clone();
                    face.andNot((BitSetFX)candidateIntent);
                    candidateFace.or(face);
                    toBeRemoved.add(candidateIntent);
                }
            });
            borderIntents.removeAll(toBeRemoved);
            borderIntents.add(intent2);
        }
        statusConsumer.accept(1.0);
    }

    public static final <G, M> TimeTask<Void> neighborhoodP(final FCADataset<G, M> dataset) {
        return new TimeTask<Void>(dataset, "iPred (parallel)"){

            protected final Void call() {
                IPred.populateConceptLattice(dataset.lattice, m -> this.updateMessage((String)m), p -> this.updateProgress((double)p, 1.0), () -> this.isCancelled());
                return null;
            }
        };
    }
}

