/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import conexp.fx.core.algorithm.nextclosures.NextClosures1;
import conexp.fx.core.algorithm.nextclosures.NextClosures2;
import conexp.fx.core.algorithm.nextclosures.NextClosures2Bit;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.importer.CXTImporter;
import conexp.fx.core.util.Meter;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public final class Benchmark {
    private static final boolean compare(Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> r, Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> s) {
        return r.x().size() == s.x().size() && r.x().containsAll((Collection)s.x()) && s.x().containsAll((Collection)r.x()) && r.y().size() == s.y().size() && r.y().containsAll((Collection)s.y()) && s.y().containsAll((Collection)r.y());
    }

    private static final boolean compareSem(Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> r, Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> s) {
        return r.x().size() == s.x().size() && r.x().containsAll((Collection)s.x()) && s.x().containsAll((Collection)r.x()) && Implication.equivalent(r.y(), s.y());
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            Meter<Long> meter = Meter.newNanoStopWatch();
            MatrixContext<String, String> cxt = CXTImporter.read(new File("../../Data/Contexts/random/o1000a20d10.cxt"));
            System.out.println("Import:                  " + meter.measureAndFormat());
            meter.reset();
            NextClosures1.Result<String, String> x = NextClosures1.compute(cxt, false);
            System.out.println("NextClosures1:           " + meter.measureAndFormat());
            Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> x0 = Pair.of(x.concepts, x.implications.entrySet().parallelStream().map(e -> new Implication((Set)e.getKey(), (Set)e.getValue())).collect(Collectors.toSet()));
            meter.reset();
            Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> r0 = NextClosures2.compute(cxt, new Collection[0]);
            System.out.println("NextClosures2:           " + meter.measureAndFormat());
            meter.reset();
            Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> r2 = NextClosures2Bit.bitCompute(cxt);
            System.out.println("NextClosures2Bit:        " + meter.measureAndFormat());
            System.out.println("############################################");
            System.out.println(Benchmark.compare(r0, x0) + " : " + Benchmark.compareSem(r0, x0));
            System.out.println(Benchmark.compare(x0, r2) + " : " + Benchmark.compareSem(x0, r2));
            System.out.println("############################################");
            System.out.println();
        }
    }
}

