/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Sets;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.math.ClosureOperator;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class NextClosures1C {
    public static final <G, M> ResultC<G, M> compute(Context<G, M> cxt, ClosureOperator<M> clop, boolean verbose, ThreadPoolExecutor tpe) {
        if (verbose) {
            System.out.println("NextClosures running on " + tpe.getCorePoolSize() + " - " + tpe.getMaximumPoolSize() + " cores...");
        }
        ResultC result = new ResultC(clop);
        ClosureOperator sup = ClosureOperator.supremum(ClosureOperator.fromContext(cxt), clop);
        int maxCardinality = cxt.colHeads().size();
        while (result.cardinality <= maxCardinality) {
            if (verbose) {
                int p = (int)(100.0f * (float)result.cardinality / (float)maxCardinality);
                System.out.println("current cardinality: " + result.cardinality + "/" + maxCardinality + " (" + p + "%)");
            }
            Set<Future> futures = Collections3.newConcurrentHashSet();
            result.candidates.keySet().parallelStream().filter(c -> c.size() == result.cardinality).forEach(candidate -> futures.add(tpe.submit(() -> {
                Set closure = ClosureOperator.fromImplications(result.implications.entrySet().stream().map(e -> new Implication((Set)e.getKey(), (Set)e.getValue())).collect(Collectors.toSet()), true, true).closure(candidate);
                if (closure.size() == candidate.size()) {
                    Set candidateII = sup.closure(candidate);
                    if (result.addToProcessed(candidateII)) {
                        for (Object m : Sets.difference(cxt.colHeads(), candidateII)) {
                            HashSet candidateM = new HashSet(candidateII);
                            candidateM.add(m);
                            result.candidates.put(candidateM, 0);
                        }
                    }
                    result.concepts.add(new Concept(cxt.colAnd(candidateII), Sets.newHashSet(candidateII)));
                    if (candidateII.size() != candidate.size()) {
                        candidateII.removeAll((Collection<?>)candidate);
                        result.implications.put(candidate, candidateII);
                    }
                } else {
                    result.candidates.put(closure, result.cardinality);
                }
                result.candidates.remove(candidate);
            })));
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            ++result.cardinality;
        }
        if (verbose) {
            System.out.println(result.concepts.size() + " concepts found");
            System.out.println(result.implications.size() + " implications found");
        }
        return result;
    }

    public static final <G, M> ResultC<G, M> compute(Context<G, M> cxt, ClosureOperator<M> clop, boolean verbose, int cores) {
        if (cores > Runtime.getRuntime().availableProcessors()) {
            throw new IllegalArgumentException("Requested pool size is too large. VM has only " + Runtime.getRuntime().availableProcessors() + " available cpus, thus a thread pool with " + cores + " cores cannot be used here.");
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(cores, cores, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        tpe.prestartAllCoreThreads();
        ResultC<G, M> result = NextClosures1C.compute(cxt, clop, verbose, tpe);
        tpe.purge();
        tpe.shutdown();
        return result;
    }

    public static final <G, M> ResultC<G, M> compute(Context<G, M> cxt, ClosureOperator<M> clop, boolean verbose) {
        int maxc = Runtime.getRuntime().availableProcessors();
        int cores = maxc < 9 ? maxc : maxc * 3 / 4;
        return NextClosures1C.compute(cxt, clop, verbose, cores);
    }

    public static final <G, M> ResultC<G, M> computeWithBackgroundImplications(Context<G, M> cxt, Set<Implication<G, M>> backgroundImplications, boolean verbose) {
        return NextClosures1C.compute(cxt, ClosureOperator.fromImplications(backgroundImplications, false, true), verbose);
    }

    public static final <G, M> ResultC<G, M> computeIceberg(Context<G, M> cxt, int minSupp, boolean verbose) {
        return NextClosures1C.compute(cxt, ClosureOperator.byMinimalSupport(minSupp, cxt), verbose);
    }

    public static final <G, M> ResultC<G, M> computeByMaxCard(Context<G, M> cxt, int maxCard, boolean verbose) {
        return NextClosures1C.compute(cxt, ClosureOperator.byMaximalCardinality(maxCard, cxt.colHeads()), verbose);
    }

    public static final <G, M> ResultC<G, M> computeBelow(Context<G, M> cxt, Collection<M> elements, boolean verbose) {
        return NextClosures1C.compute(cxt, ClosureOperator.isSubsetOf(elements, cxt.colHeads()), verbose);
    }

    public static final <G, M> ResultC<G, M> computeAbove(Context<G, M> cxt, Collection<M> elements, boolean verbose) {
        return NextClosures1C.compute(cxt, ClosureOperator.containsAllFrom(elements, cxt.colHeads()), verbose);
    }

    public static final class ResultC<G, M> {
        public final Set<Concept<G, M>> concepts = Collections3.newConcurrentHashSet();
        public final Map<Set<M>, Set<M>> implications = new ConcurrentHashMap<Set<M>, Set<M>>();
        final Map<Set<M>, Integer> candidates = new ConcurrentHashMap<Set<M>, Integer>();
        private final Set<Set<M>> processed = Collections3.newConcurrentHashSet();
        int cardinality = 0;
        private final ClosureOperator<M> clop;

        public ResultC(ClosureOperator<M> clop) {
            this.clop = clop;
            this.candidates.put(new HashSet(), 0);
        }

        private final boolean isClosed(Set<M> candidate) {
            for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                if (candidate.size() <= implication.getKey().size() || !candidate.containsAll((Collection)implication.getKey()) || candidate.containsAll((Collection)implication.getValue())) continue;
                return false;
            }
            return true;
        }

        final Set<M> fastClosure(Set<M> candidate, int c) {
            HashSet<M> closure = new HashSet<M>(candidate);
            boolean changed = false;
            for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                if (implication.getKey().size() < c || closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                closure.addAll((Collection)implication.getValue());
                changed = true;
            }
            while (changed) {
                changed = false;
                for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                    if (closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                    closure.addAll((Collection)implication.getValue());
                    changed = true;
                }
            }
            return closure;
        }

        private final Set<M> closure(Set<M> candidate) {
            HashSet<M> closure = new HashSet<M>(candidate);
            boolean changed = true;
            while (changed) {
                changed = false;
                for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                    if (closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                    closure.addAll((Collection)implication.getValue());
                    changed = true;
                }
            }
            return closure;
        }

        final boolean addToProcessed(Set<M> s) {
            try {
                return this.processed.add(s);
            }
            catch (ConcurrentModificationException e) {
                return this.addToProcessed(s);
            }
        }
    }
}

