/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import conexp.fx.core.algorithm.nextclosures.NextClosuresState;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.math.ClosureOperator;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class NextClosures2 {
    public static final <T> Set<Set<T>> compute(Set<T> baseSet, ClosureOperator<T> clop, boolean verbose, ExecutorService tpe) {
        ConcurrentHashMap closures = new ConcurrentHashMap();
        Set<Set> candidates = Collections3.newConcurrentHashSet();
        candidates.add(new HashSet());
        AtomicInteger cardinality = new AtomicInteger(0);
        while (cardinality.get() < baseSet.size()) {
            System.out.println("current cardinality: " + cardinality.get());
            while (!Collections2.filter(candidates, c -> c.size() == cardinality.get()).isEmpty()) {
                Set<Future<?>> futures = Collections3.newConcurrentHashSet();
                long count = candidates.parallelStream().filter(c -> c.size() == cardinality.get()).count();
                System.out.println("processing " + count + " candidates");
                for (Set candidate : candidates) {
                    if (candidate.size() != cardinality.get()) continue;
                    futures.add(tpe.submit(() -> {
                        Optional<Map.Entry> optional = closures.entrySet().parallelStream().filter(e -> candidate.containsAll((Collection)e.getKey()) && ((Set)e.getValue()).containsAll(candidate)).findAny();
                        if (optional.isPresent()) {
                            Set closure = (Set)optional.get().getValue();
                        } else {
                            Set closure = clop.closure(candidate);
                            closures.put(candidate, closure);
                            Sets.difference((Set)baseSet, closure).parallelStream().forEach(individual -> {
                                HashSet nextCandidate = Sets.newHashSet((Iterable)closure);
                                nextCandidate.add(individual);
                                candidates.add(nextCandidate);
                            });
                        }
                    }));
                }
                candidates.removeIf(c -> c.size() == cardinality.get());
                futures.forEach(f -> {
                    try {
                        f.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            cardinality.incrementAndGet();
        }
        return closures.values().parallelStream().collect(Collectors.toSet());
    }

    @SafeVarargs
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, ExecutorService executor, Consumer<Concept<G, M>> conceptConsumer, Consumer<Implication<G, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled, Collection<Implication<G, M>> ... backgroundKnowledge) {
        if (!cxt.models(Collections3.union(backgroundKnowledge), new boolean[0])) {
            throw new RuntimeException("The background implications are not valid in the formal context.");
        }
        NextClosuresState result = NextClosuresState.withHashSets(cxt.colHeads());
        Function<Integer, ClosureOperator> clop = backgroundKnowledge.length == 0 ? i -> ClosureOperator.fromImplications(result.implications, i, true, true) : i -> ClosureOperator.supremum(ClosureOperator.fromImplications(result.implications, i, true, true), ClosureOperator.fromImplications(Collections3.union(backgroundKnowledge), false, true));
        int maxCardinality = cxt.colHeads().size();
        while (result.cardinality <= maxCardinality) {
            try {
                if (isCancelled.get().booleanValue()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            double q = (double)result.cardinality / (double)maxCardinality;
            int p = (int)(100.0 * q);
            updateStatus.accept("current cardinality: " + result.cardinality + "/" + maxCardinality + " (" + p + "%)");
            updateProgress.accept(q);
            Set<Future> futures = Collections3.newConcurrentHashSet();
            Set cc = result.getActualCandidates();
            cc.forEach(candidate -> futures.add(executor.submit(() -> {
                Set closure = ((ClosureOperator)clop.apply(result.candidates.get(candidate))).closure(candidate);
                if (closure.equals(candidate)) {
                    Set candidateI = cxt.colAnd((Collection<?>)candidate);
                    Set candidateII = cxt.rowAnd(candidateI);
                    if (result.isNewIntent(candidateII)) {
                        Concept concept = new Concept(candidateI, new HashSet(candidateII));
                        result.concepts.add(concept);
                        conceptConsumer.accept(concept);
                        result.addNewCandidates(candidateII);
                    }
                    if (candidateII.size() != candidate.size()) {
                        candidateII.removeAll((Collection<?>)candidate);
                        Implication implication = new Implication(candidate, candidateII, candidateI);
                        result.implications.add(implication);
                        implicationConsumer.accept(implication);
                    }
                } else {
                    result.candidates.put(closure, result.cardinality);
                }
            })));
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            result.candidates.keySet().removeAll(cc);
            ++result.cardinality;
        }
        updateStatus.accept(result.concepts.size() + " concepts, and " + result.implications.size() + " implications found");
        return result.getResultAndDispose();
    }

    @SafeVarargs
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, ExecutorService executor, Collection<Implication<G, M>> ... backgroundKnowledge) {
        return NextClosures2.compute(cxt, executor, (Concept<G, M> __) -> {}, (Implication<G, M> __) -> {}, (String __) -> {}, (Double __) -> {}, () -> false, backgroundKnowledge);
    }

    @SafeVarargs
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, int cores, Collection<Implication<G, M>> ... backgroundKnowledge) {
        if (cores > Runtime.getRuntime().availableProcessors()) {
            throw new IllegalArgumentException("Requested pool size is too large. VM has only " + Runtime.getRuntime().availableProcessors() + " available cpus, thus a thread pool with " + cores + " cores cannot be used here.");
        }
        ExecutorService tpe = Executors.newWorkStealingPool(cores);
        Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> result = NextClosures2.compute(cxt, tpe, backgroundKnowledge);
        tpe.shutdown();
        return result;
    }

    @SafeVarargs
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, Collection<Implication<G, M>> ... backgroundKnowledge) {
        return NextClosures2.compute(cxt, Runtime.getRuntime().availableProcessors(), backgroundKnowledge);
    }

    public static final <G, M> TimeTask<?> createTask(final FCADataset<G, M> dataset) {
        return new TimeTask<Void>(dataset, "NextClosures"){

            protected Void call() throws Exception {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                NextClosures2.compute(dataset.context.getSelection(), ConExpFX.instance.executor.tpe, concept -> Platform2.runOnFXThread(() -> dataset2.concepts.add(concept)), implication -> Platform2.runOnFXThread(() -> dataset2.implications.add((Object)implication)), status -> this.updateMessage((String)status), progress -> this.updateProgress((double)progress, 1.0), () -> this.isCancelled(), new Collection[0]);
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }
}

