/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import conexp.fx.core.algorithm.nextclosures.NextClosuresState;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.math.ClosureOperator;
import conexp.fx.core.math.Math3;
import conexp.fx.core.util.Meter;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NextClosures2Bit {
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> bitCompute(Context<G, M> cxt, ExecutorService executor, Consumer<Concept<G, M>> conceptConsumer, Consumer<Implication<G, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled) {
        MatrixRelation mcxt = cxt instanceof MatrixContext ? (MatrixContext)cxt : cxt.clone();
        int max = mcxt.colHeads().size();
        NextClosuresState<Integer, Integer, BitSetFX> state = NextClosuresState.withBitSets(max);
        while (state.cardinality <= max && !isCancelled.get().booleanValue()) {
            double q = (double)state.cardinality / (double)max;
            int p = (int)(100.0 * q);
            updateStatus.accept("current cardinality: " + state.cardinality + "/" + max + " (" + p + "%)");
            updateProgress.accept(q);
            Set<Future> fs = Collections3.newConcurrentHashSet();
            Set<BitSetFX> cc = state.getActualCandidates();
            cc.forEach(arg_0 -> NextClosures2Bit.lambda$bitCompute$1(fs, executor, state, (MatrixContext)mcxt, arg_0));
            for (Future f : fs) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
            state.candidates.keySet().removeAll(cc);
            ++state.cardinality;
        }
        updateStatus.accept(state.concepts.size() + " concepts, and " + state.implications.size() + " implications found");
        NextClosuresState r = NextClosuresState.withHashSets(cxt.colHeads());
        state.concepts.parallelStream().map(arg_0 -> NextClosures2Bit.lambda$bitCompute$2((MatrixContext)mcxt, arg_0)).forEach(conceptConsumer.andThen(r.concepts::add));
        state.implications.parallelStream().map(arg_0 -> NextClosures2Bit.lambda$bitCompute$3((MatrixContext)mcxt, arg_0)).forEach(implicationConsumer.andThen(r.implications::add));
        return r.getResultAndDispose();
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> bitCompute(Context<G, M> cxt) {
        return NextClosures2Bit.bitCompute(cxt, Executors.newWorkStealingPool(), __ -> {}, __ -> {}, __ -> {}, __ -> {}, () -> false);
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> bitCleanedCompute(Context<G, M> cxt, ExecutorService executor, Consumer<Concept<G, M>> conceptConsumer, Consumer<Implication<G, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled) {
        MatrixContext<G, M> mcxt = cxt.toMatrixContext();
        System.out.println("starting context cleaning...");
        Meter<Long> nsw = Meter.newNanoStopWatch();
        mcxt.clean();
        System.out.println("context cleaning took " + Math3.formatNanos(nsw.measure()));
        System.out.println("cloning cleaned context...");
        Meter<Long> nsw2 = Meter.newNanoStopWatch();
        MatrixRelation ccxt = mcxt.cleaned.clone();
        System.out.println("context cloning took " + Math3.formatNanos(nsw2.measure()));
        Meter<Long> nsw3 = Meter.newNanoStopWatch();
        Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> r = NextClosures2Bit.bitCompute(ccxt, executor, __ -> {}, __ -> {}, updateStatus, updateProgress, isCancelled);
        System.out.println("bitcleaned: " + nsw3.measureAndFormat());
        Meter<Long> nsw4 = Meter.newNanoStopWatch();
        NextClosuresState x = NextClosuresState.withHashSets(cxt.colHeads());
        r.first().parallelStream().map(c -> new Concept(c.extent().parallelStream().flatMap(Collection::parallelStream).collect(Collectors.toSet()), c.intent().parallelStream().flatMap(Collection::parallelStream).collect(Collectors.toSet()))).forEach(conceptConsumer.andThen(x.concepts::add));
        ConcurrentHashMap f = new ConcurrentHashMap();
        ccxt.colHeads().parallelStream().map(c -> new HashSet(c)).forEach(c -> f.put(c, c.iterator().next()));
        r.second().parallelStream().map(i -> new Implication(i.getPremise().parallelStream().map(f::get).collect(Collectors.toSet()), i.getConclusion().parallelStream().map(f::get).collect(Collectors.toSet()))).forEach(implicationConsumer.andThen(x.implications::add));
        f.keySet().parallelStream().flatMap(c -> c.size() > 1 ? c.parallelStream().map(m -> new Implication((Set)Collections.singleton(m), (Set)c)) : Stream.empty()).forEach(implicationConsumer.andThen(x.implications::add));
        System.out.println("transform: " + nsw3.measureAndFormat());
        return x.getResultAndDispose();
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> bitReducedCompute(Context<G, M> cxt, ExecutorService executor, Consumer<Concept<G, M>> conceptConsumer, Consumer<Implication<G, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled) {
        MatrixContext<G, M> mcxt = cxt.toMatrixContext();
        mcxt.reduce();
        MatrixRelation rcxt = mcxt.reduced.clone();
        MatrixRelation ccxt = mcxt.cleaned.clone();
        Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> r = NextClosures2Bit.bitCompute(rcxt, executor, __ -> {}, __ -> {}, updateStatus, updateProgress, isCancelled);
        NextClosuresState x = NextClosuresState.withHashSets(cxt.colHeads());
        ConcurrentHashMap irr = new ConcurrentHashMap();
        ccxt.colHeads().parallelStream().filter(arg_0 -> NextClosures2Bit.lambda$bitReducedCompute$19((MatrixContext)rcxt, arg_0)).forEach(arg_0 -> NextClosures2Bit.lambda$bitReducedCompute$20(irr, (MatrixContext)ccxt, arg_0));
        ConcurrentHashMap jrr = new ConcurrentHashMap();
        ccxt.rowHeads().parallelStream().filter(arg_0 -> NextClosures2Bit.lambda$bitReducedCompute$21((MatrixContext)rcxt, arg_0)).forEach(arg_0 -> NextClosures2Bit.lambda$bitReducedCompute$22(jrr, (MatrixContext)ccxt, arg_0));
        ConcurrentHashMap f = new ConcurrentHashMap();
        ccxt.colHeads().parallelStream().map(c -> new HashSet(c)).forEach(c -> f.put(c, c.iterator().next()));
        r.first().parallelStream().map(c -> new Concept(c.extent().parallelStream().flatMap(Collection::parallelStream).collect(Collectors.toSet()), c.intent().parallelStream().flatMap(Collection::parallelStream).collect(Collectors.toSet()))).forEach(conceptConsumer.andThen(x.concepts::add));
        for (Concept c2 : x.concepts) {
            for (Map.Entry e : irr.entrySet()) {
                if (!c2.intent().containsAll((Collection)((Set)e.getValue()).parallelStream().map(f::get).collect(Collectors.toSet()))) continue;
                c2.intent().addAll((Collection)e.getKey());
            }
            for (Map.Entry e : jrr.entrySet()) {
                if (!c2.extent().containsAll((Collection)((Set)e.getValue()).parallelStream().map(f::get).collect(Collectors.toSet()))) continue;
                c2.extent().addAll((Collection)e.getKey());
            }
        }
        r.second().parallelStream().map(i -> new Implication(i.getPremise().parallelStream().map(f::get).collect(Collectors.toSet()), i.getConclusion().parallelStream().map(f::get).collect(Collectors.toSet()))).forEach(implicationConsumer.andThen(x.implications::add));
        f.keySet().parallelStream().flatMap(c -> c.size() > 1 ? c.parallelStream().map(m -> new Implication((Set)Collections.singleton(m), (Set)c)) : Stream.empty()).forEach(implicationConsumer.andThen(x.implications::add));
        irr.keySet().parallelStream().flatMap(ir -> {
            Implication[] implicationArray = new Implication[2];
            implicationArray[0] = new Implication(Collections.singleton(f.get(ir)), ((Set)irr.get(ir)).parallelStream().map(f::get).collect(Collectors.toSet()));
            implicationArray[1] = new Implication(((Set)irr.get(ir)).parallelStream().map(f::get).collect(Collectors.toSet()), Collections.singleton(f.get(ir)));
            return Stream.of(implicationArray);
        }).forEach(implicationConsumer.andThen(x.implications::add));
        return x.getResultAndDispose();
    }

    public static final <G, M> TimeTask<?> createTask(final FCADataset<G, M> dataset) {
        return new TimeTask<Void>(dataset, "NextClosures"){

            protected Void call() throws Exception {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                NextClosures2Bit.bitCompute(dataset.context.getSelection(), ConExpFX.instance.executor.tpe, concept -> Platform2.runOnFXThread(() -> dataset2.concepts.add(concept)), implication -> Platform2.runOnFXThread(() -> dataset2.implications.add((Object)implication)), status -> this.updateMessage((String)status), progress -> this.updateProgress((double)progress, 1.0), () -> this.isCancelled());
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    private static /* synthetic */ void lambda$bitReducedCompute$22(Map jrr, MatrixContext ccxt, Set objs) {
        Set cfr_ignored_0 = jrr.put(objs, new HashSet(ccxt.objectQuasiOrder().col(objs)));
    }

    private static /* synthetic */ boolean lambda$bitReducedCompute$21(MatrixContext rcxt, Set objs) {
        return !rcxt.rowHeads().contains(objs);
    }

    private static /* synthetic */ void lambda$bitReducedCompute$20(Map irr, MatrixContext ccxt, Set atts) {
        Set cfr_ignored_0 = irr.put(atts, new HashSet(ccxt.attributeQuasiOrder().col(atts)));
    }

    private static /* synthetic */ boolean lambda$bitReducedCompute$19(MatrixContext rcxt, Set atts) {
        return !rcxt.colHeads().contains(atts);
    }

    private static /* synthetic */ Implication lambda$bitCompute$3(MatrixContext mcxt, Implication i) {
        return new Implication(mcxt.colHeads().getAll(i.getPremise(), true), mcxt.colHeads().getAll(i.getConclusion(), true));
    }

    private static /* synthetic */ Concept lambda$bitCompute$2(MatrixContext mcxt, Concept c) {
        return new Concept(mcxt.rowHeads().getAll(c.getExtent(), true), mcxt.colHeads().getAll(c.getIntent(), true));
    }

    private static /* synthetic */ void lambda$bitCompute$1(Set fs, ExecutorService executor, NextClosuresState state, MatrixContext mcxt, BitSetFX c) {
        fs.add(executor.submit(() -> {
            BitSetFX d = ClosureOperator.implicativeClosure(state.implications, state.getFirstPremiseSize(c), true, true, true, BitSetFX::new, c);
            if (c.geq(d)) {
                BitSetFX c1 = mcxt._colAnd(c);
                BitSetFX c2 = mcxt._rowAnd(c1);
                if (state.isNewIntent(c2)) {
                    state.concepts.add(new Concept<Integer, Integer>(c1, new BitSetFX(c2)));
                    state.addNewCandidates(c2);
                }
                if (!c.geq(c2)) {
                    c2.removeAll(c);
                    state.implications.add(new Implication(c, c2));
                }
            } else {
                state.addCandidate(d);
            }
        }));
    }
}

