/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import conexp.fx.core.algorithm.nextclosures.NextClosuresState;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.math.ClosureOperator;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class NextClosures2C {
    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, ExecutorService executor, Consumer<Concept<G, M>> conceptConsumer, Consumer<Implication<G, M>> implicationConsumer, Consumer<String> updateStatus, Consumer<Double> updateProgress, Supplier<Boolean> isCancelled, ClosureOperator<M> constraint) {
        int firstCardinality;
        NextClosuresState result = NextClosuresState.withHashSets(cxt.colHeads());
        result.candidates.clear();
        HashSet firstCandidate = new HashSet();
        constraint.close(firstCandidate);
        result.cardinality = firstCardinality = firstCandidate.size();
        result.candidates.put(firstCandidate, firstCardinality);
        ClosureOperator sup = ClosureOperator.supremum(ClosureOperator.fromContext(cxt), constraint);
        int maxCardinality = cxt.colHeads().size();
        while (result.cardinality <= maxCardinality) {
            try {
                if (isCancelled.get().booleanValue()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            double q = (double)result.cardinality / (double)maxCardinality;
            int p = (int)(100.0 * q);
            updateStatus.accept("current cardinality: " + result.cardinality + "/" + maxCardinality + " (" + p + "%)");
            updateProgress.accept(q);
            Set<Future> futures = Collections3.newConcurrentHashSet();
            result.candidates.keySet().parallelStream().filter(c -> c.size() == result.cardinality).forEach(candidate -> futures.add(executor.submit(() -> {
                Set closure = ClosureOperator.supremum(ClosureOperator.fromImplications(result.implications, result.candidates.get(candidate), true, true), constraint).closure(candidate);
                if (closure.size() == candidate.size()) {
                    Set candidateII = sup.closure(candidate);
                    Set candidateI = cxt.colAnd((Collection<?>)candidate);
                    if (result.isNewIntent(candidateII)) {
                        Concept concept = new Concept(candidateI, new HashSet(candidateII));
                        result.concepts.add(concept);
                        conceptConsumer.accept(concept);
                        result.addNewCandidates(candidateII);
                    }
                    if (candidateII.size() != candidate.size()) {
                        candidateII.removeAll((Collection<?>)candidate);
                        Implication implication = new Implication(candidate, candidateII, candidateI);
                        result.implications.add(implication);
                        implicationConsumer.accept(implication);
                    }
                } else {
                    result.candidates.put(closure, result.cardinality);
                }
                result.candidates.remove(candidate);
            })));
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            ++result.cardinality;
        }
        updateStatus.accept(result.concepts.size() + " concepts, and " + result.implications.size() + " implications found");
        return result.getResultAndDispose();
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, ExecutorService executor, ClosureOperator<M> constraint) {
        return NextClosures2C.compute(cxt, executor, __ -> {}, __ -> {}, System.out::println, System.out::println, () -> false, constraint);
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, int cores, ClosureOperator<M> constraint) {
        if (cores > Runtime.getRuntime().availableProcessors()) {
            throw new IllegalArgumentException("Requested pool size is too large. VM has only " + Runtime.getRuntime().availableProcessors() + " available cpus, thus a thread pool with " + cores + " cores cannot be used here.");
        }
        ExecutorService tpe = Executors.newWorkStealingPool(cores);
        Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> result = NextClosures2C.compute(cxt, tpe, constraint);
        tpe.shutdown();
        return result;
    }

    public static final <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> compute(Context<G, M> cxt, ClosureOperator<M> constraint) {
        return NextClosures2C.compute(cxt, Runtime.getRuntime().availableProcessors() - 1, constraint);
    }

    public static final <G, M> TimeTask<?> createTask(final FCADataset<G, M> dataset, final ClosureOperator<M> constraint) {
        return new TimeTask<Void>(dataset, "NextClosures"){

            protected Void call() throws Exception {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                NextClosures2C.compute(dataset.context.getSelection(), ConExpFX.instance.executor.tpe, concept -> Platform2.runOnFXThread(() -> dataset2.concepts.add(concept)), implication -> Platform2.runOnFXThread(() -> dataset2.implications.add((Object)implication)), status -> this.updateMessage((String)status), progress -> this.updateProgress((double)progress, 1.0), () -> this.isCancelled(), constraint);
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }
}

