/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures.mn;

import com.google.common.collect.Sets;
import conexp.fx.core.context.MatrixContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class MatrixContextMN<G, M> {
    private final MatrixContext<G, M> cxt;
    private final Set<M> premises;
    private final Set<M> conclusions;
    private final MatrixContext<G, M> cxtM;
    private final MatrixContext<G, M> cxtN;

    public MatrixContextMN(MatrixContext<G, M> cxt, Set<M> premises, Set<M> conclusions) {
        if (!Sets.intersection(premises, conclusions).isEmpty()) {
            throw new RuntimeException();
        }
        this.cxt = cxt;
        this.premises = premises;
        this.conclusions = conclusions;
        this.cxtM = cxt.subRelation((Collection)cxt.rowHeads(), premises).clone();
        this.cxtN = cxt.subRelation((Collection)cxt.rowHeads(), conclusions).clone();
    }

    public final Set<M> closureMN(Set<M> set) {
        if (!this.premises.containsAll(set)) {
            throw new RuntimeException();
        }
        return new HashSet(this.cxtN.rowAnd(new HashSet(this.cxtM.colAnd(set))));
    }

    public final Set<M> intentM(Set<M> set) {
        if (!this.premises.containsAll(set)) {
            throw new RuntimeException();
        }
        return new HashSet<M>(this.cxtM.intent(set));
    }
}

