/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.SortedSet;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BitSetFX
extends AbstractSet<Integer>
implements SortedSet<Integer>,
Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bits", long[].class)};
    private long[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkInvariants() {
        assert (this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0L);
        assert (this.wordsInUse >= 0 && this.wordsInUse <= this.words.length);
        assert (this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0L);
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0 && this.words[i] == 0L; --i) {
        }
        this.wordsInUse = i + 1;
    }

    public BitSetFX() {
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public BitSetFX(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
        this.sizeIsSticky = true;
    }

    private void initWords(int nbits) {
        this.words = new long[BitSetFX.wordIndex(nbits - 1) + 1];
    }

    private BitSetFX(long[] words) {
        this.words = words;
        this.wordsInUse = words.length;
        this.checkInvariants();
    }

    public static BitSetFX valueOf(long[] longs) {
        int n;
        for (n = longs.length; n > 0 && longs[n - 1] == 0L; --n) {
        }
        return new BitSetFX(Arrays.copyOf(longs, n));
    }

    public static BitSetFX valueOf(LongBuffer lb) {
        int n;
        lb = lb.slice();
        for (n = lb.remaining(); n > 0 && lb.get(n - 1) == 0L; --n) {
        }
        long[] words = new long[n];
        lb.get(words);
        return new BitSetFX(words);
    }

    public static BitSetFX valueOf(byte[] bytes) {
        return BitSetFX.valueOf(ByteBuffer.wrap(bytes));
    }

    public static BitSetFX valueOf(ByteBuffer bb) {
        int n;
        bb = bb.slice().order(ByteOrder.LITTLE_ENDIAN);
        for (n = bb.remaining(); n > 0 && bb.get(n - 1) == 0; --n) {
        }
        long[] words = new long[(n + 7) / 8];
        bb.limit(n);
        int i = 0;
        while (bb.remaining() >= 8) {
            words[i++] = bb.getLong();
        }
        int remaining = bb.remaining();
        for (int j = 0; j < remaining; ++j) {
            int n2 = i;
            words[n2] = words[n2] | ((long)bb.get() & 0xFFL) << 8 * j;
        }
        return new BitSetFX(words);
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse;
        if (n == 0) {
            return new byte[0];
        }
        int len = 8 * (n - 1);
        for (long x = this.words[n - 1]; x != 0L; x >>>= 8) {
            ++len;
        }
        byte[] bytes = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n - 1; ++i) {
            bb.putLong(this.words[i]);
        }
        for (long x = this.words[n - 1]; x != 0L; x >>>= 8) {
            bb.put((byte)(x & 0xFFL));
        }
        return bytes;
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.wordsInUse);
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            this.words = Arrays.copyOf(this.words, request);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSetFX.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] ^ 1L << bitIndex;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void flip(int fromIndex, int toIndex) {
        BitSetFX.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSetFX.wordIndex(fromIndex);
        int endWordIndex = BitSetFX.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] ^ firstWordMask;
            int i = startWordIndex + 1;
            while (i < endWordIndex) {
                int n2 = i++;
                this.words[n2] = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] ^ lastWordMask;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSetFX.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
        this.checkInvariants();
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        BitSetFX.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSetFX.wordIndex(fromIndex);
        int endWordIndex = BitSetFX.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = -1L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
        this.checkInvariants();
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSetFX.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void clear(int fromIndex, int toIndex) {
        BitSetFX.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSetFX.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = BitSetFX.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = 0L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    @Override
    public void clear() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0L;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = BitSetFX.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public BitSetFX get(int fromIndex, int toIndex) {
        BitSetFX.checkRange(fromIndex, toIndex);
        this.checkInvariants();
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new BitSetFX(0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        BitSetFX result = new BitSetFX(toIndex - fromIndex);
        int targetWords = BitSetFX.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = BitSetFX.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words[i] = wordAligned ? this.words[sourceIndex] : this.words[sourceIndex] >>> fromIndex | this.words[sourceIndex + 1] << -fromIndex;
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex;
        result.words[targetWords - 1] = (toIndex - 1 & 0x3F) < (fromIndex & 0x3F) ? this.words[sourceIndex] >>> fromIndex | (this.words[sourceIndex + 1] & lastWordMask) << -fromIndex : (this.words[sourceIndex] & lastWordMask) >>> fromIndex;
        result.wordsInUse = targetWords;
        result.recalculateWordsInUse();
        result.checkInvariants();
        return result;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetFX.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetFX.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetFX.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return this.length() - 1;
        }
        long word = this.words[u] & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u];
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSetFX.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long word = (this.words[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    @Override
    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BitSetFX set) {
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & set.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public void and(BitSetFX set) {
        if (this == set) {
            return;
        }
        while (this.wordsInUse > set.wordsInUse) {
            this.words[--this.wordsInUse] = 0L;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & set.words[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void or(BitSetFX set) {
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            int n = i;
            this.words[n] = this.words[n] | set.words[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
        }
        this.checkInvariants();
    }

    public void xor(BitSetFX set) {
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            int n = i;
            this.words[n] = this.words[n] ^ set.words[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse - wordsInCommon);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public void andNot(BitSetFX set) {
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & (set.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    @Override
    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse;
        while (--i >= 0) {
            h ^= this.words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int space() {
        return this.words.length * 64;
    }

    @Override
    public int size() {
        return this.cardinality();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BitSetFX)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BitSetFX set = (BitSetFX)obj;
        this.trimToSize();
        set.trimToSize();
        this.checkInvariants();
        set.checkInvariants();
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        try {
            BitSetFX result = (BitSetFX)super.clone();
            result.words = (long[])this.words.clone();
            result.checkInvariants();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.checkInvariants();
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("bits", this.words);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.words = (long[])fields.get("bits", null);
        this.wordsInUse = this.words.length;
        this.recalculateWordsInUse();
        this.sizeIsSticky = this.words.length > 0 && this.words[this.words.length - 1] == 0L;
        this.checkInvariants();
    }

    @Override
    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    @Override
    public Stream<Integer> stream() {
        return StreamSupport.stream(() -> Spliterators.spliterator(this.iterator(), (long)this.cardinality(), 21), 16469, false);
    }

    @Override
    public Iterator<Integer> iterator() {
        class BitSetIterator
        implements PrimitiveIterator.OfInt {
            int next;

            BitSetIterator() {
                this.next = BitSetFX.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public int nextInt() {
                if (this.next != -1) {
                    int ret = this.next;
                    this.next = BitSetFX.this.nextSetBit(this.next + 1);
                    return ret;
                }
                throw new NoSuchElementException();
            }
        }
        return new BitSetIterator();
    }

    public void and(BitSetFX ... sets) {
        this.and(Arrays.asList(sets));
    }

    public void and(Collection<BitSetFX> sets) {
        if (sets.isEmpty()) {
            return;
        }
        Integer minWordsInUse = sets.stream().map(set -> set.wordsInUse).min(Integer::compare).get();
        while (this.wordsInUse > minWordsInUse) {
            this.words[--this.wordsInUse] = 0L;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            for (BitSetFX set2 : sets) {
                int n = i;
                this.words[n] = this.words[n] & set2.words[i];
            }
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public BitSetFX(BitSetFX b) {
        this();
        this.or(b);
    }

    public BitSetFX(Collection<? extends Integer> c) {
        this();
        this.addAll(c);
    }

    public boolean geq(BitSetFX set) {
        this.trimToSize();
        set.trimToSize();
        this.checkInvariants();
        set.checkInvariants();
        if (set.wordsInUse == 0) {
            return true;
        }
        if (set.wordsInUse > this.wordsInUse) {
            return false;
        }
        for (int i = set.wordsInUse - 1; i >= 0; --i) {
            if ((set.words[i] & this.words[i]) == set.words[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.get((Integer)o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof BitSetFX) {
            BitSetFX other = (BitSetFX)c;
            return this.geq(other);
        }
        for (Object o : c) {
            if (this.get((Integer)o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Integer e) {
        if (this.get(e)) {
            return false;
        }
        this.set(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c instanceof BitSetFX) {
            int cardinality = this.cardinality();
            this.or((BitSetFX)c);
            return cardinality != this.cardinality();
        }
        boolean changed = false;
        Iterator<? extends Integer> iterator = c.iterator();
        while (iterator.hasNext()) {
            int e = iterator.next();
            changed |= this.add(e);
        }
        return changed;
    }

    public void addRange(int start, int end) {
        this.set(start, end);
    }

    @Override
    public boolean remove(Object o) {
        int e;
        if (o instanceof Integer && this.get(e = ((Integer)o).intValue())) {
            this.clear(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof BitSetFX) {
            int cardinality = this.cardinality();
            this.andNot((BitSetFX)c);
            return cardinality != this.cardinality();
        }
        boolean changed = false;
        for (Object e : c) {
            changed |= this.remove(e);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof BitSetFX) {
            int cardinality = this.cardinality();
            this.and((BitSetFX)c);
            return cardinality != this.cardinality();
        }
        boolean changed = false;
        int i = this.nextSetBit(0);
        while (i != -1) {
            if (!c.contains(i)) {
                this.clear(i);
                changed = true;
            }
            i = this.nextSetBit(i);
        }
        return changed;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return Integer::compare;
    }

    @Override
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        return this.get(fromElement, toElement);
    }

    @Override
    public SortedSet<Integer> headSet(Integer toElement) {
        return this.get(0, toElement);
    }

    @Override
    public SortedSet<Integer> tailSet(Integer fromElement) {
        return this.get(fromElement, this.length());
    }

    @Override
    public Integer first() {
        return this.nextSetBit(0);
    }

    @Override
    public Integer last() {
        return this.length() - 1;
    }
}

