/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.relation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.ListIterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.SimpleListIterator;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.relation.Relation;
import conexp.fx.core.collections.setlist.AbstractSetList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiPredicate;

public abstract class AbstractRelation<R, C>
implements Relation<R, C> {
    protected final boolean homogen;
    protected SetList<R> rowHeads;
    protected SetList<C> colHeads;
    private static final int colspan = 5;

    public static <R, C> AbstractRelation<R, C> fromPredicate(SetList<R> rowHeads, SetList<C> colHeads, final BiPredicate<R, C> predicate) {
        return new AbstractRelation<R, C>(rowHeads, colHeads, false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                try {
                    return predicate.test(o1, o2);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    public static <R> AbstractRelation<R, R> fromPredicate(SetList<R> heads, final BiPredicate<R, R> predicate) {
        return new AbstractRelation<R, R>(heads, heads, true){

            @Override
            public final boolean contains(Object o1, Object o2) {
                try {
                    return predicate.test(o1, o2);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    protected AbstractRelation(SetList<R> rowHeads, SetList<C> colHeads, boolean homogen) {
        this(homogen);
        if (homogen) {
            if (!rowHeads.equals(colHeads)) {
                throw new Relation.NoHomogenRelationException();
            }
            this.rowHeads = rowHeads;
            this.colHeads = this.rowHeads;
        } else {
            this.rowHeads = rowHeads;
            this.colHeads = colHeads;
        }
    }

    protected AbstractRelation(boolean homogen) {
        this.homogen = homogen;
    }

    @Override
    public SetList<R> rowHeads() {
        return this.rowHeads;
    }

    @Override
    public SetList<C> colHeads() {
        return this.colHeads;
    }

    @Override
    public abstract boolean contains(Object var1, Object var2);

    @Override
    public boolean containsAll(Relation<?, ?> r) {
        for (Pair pair : r) {
            if (this.contains(pair.x(), pair.y())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<C> row(Object o) {
        return this.rowAnd(o);
    }

    @Override
    public Set<R> col(Object o) {
        return this.colAnd(o);
    }

    @Override
    public final Set<C> rowAnd(Object ... rows) {
        return this.rowAnd(Arrays.asList(rows));
    }

    @Override
    public final Set<R> colAnd(Object ... cols) {
        return this.colAnd(Arrays.asList(cols));
    }

    @Override
    public Set<C> rowAnd(final Collection<?> rows) {
        return Sets.filter(this.colHeads(), (Predicate)new Predicate<C>(){

            public final boolean apply(C col) {
                for (Object row : rows) {
                    if (AbstractRelation.this.contains(row, col)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public Set<R> colAnd(final Collection<?> cols) {
        return Sets.filter(this.rowHeads(), (Predicate)new Predicate<R>(){

            public final boolean apply(R row) {
                for (Object col : cols) {
                    if (AbstractRelation.this.contains(row, col)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public Relation<R, C> subRelation(Collection<?> rows, Collection<?> cols) {
        return new AbstractRelation<R, C>(SetLists.intersection(this.rowHeads, rows), SetLists.intersection(this.colHeads, cols), false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                return this.rowHeads().contains(o1) && this.colHeads().contains(o2) && AbstractRelation.this.contains(o1, o2);
            }
        };
    }

    @Override
    public Relation<R, C> filter(Predicate<? super R> rowPredicate, Predicate<? super C> colPredicate, final Predicate<Pair<R, C>> relationPredicate) {
        return new AbstractRelation<R, C>(this.rowHeads.filter(rowPredicate), this.colHeads.filter(colPredicate), false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                return this.rowHeads().contains(o1) && this.colHeads().contains(o2) && AbstractRelation.this.contains(o1, o2) && relationPredicate.apply(new Pair<Object, Object>(o1, o2));
            }
        };
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Relation && this.size() == ((Relation)o).size() && this.containsAll((Relation)o);
    }

    @Override
    public final boolean smallerEq(Relation<R, C> r) {
        return r.containsAll(this);
    }

    @Override
    public final boolean smaller(Relation<R, C> r) {
        return this.size() < r.size() && this.smallerEq(r);
    }

    @Override
    public final boolean greaterEq(Relation<R, C> r) {
        return r.smallerEq(this);
    }

    @Override
    public final boolean greater(Relation<R, C> r) {
        return r.smaller(this);
    }

    @Override
    public final boolean uncomparable(Relation<R, C> r) {
        return !this.smallerEq(r) && !this.greaterEq(r);
    }

    @Override
    public final int compareTo(Relation<R, C> r) {
        if (this.equals(r)) {
            return 0;
        }
        if (this.smallerEq(r)) {
            return -1;
        }
        if (this.greaterEq(r)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterator<Pair<R, C>> iterator() {
        return Iterators.filter(ListIterators.cartesianProduct(this.rowHeads().listIterator(), this.colHeads().listIterator(), 0), (Predicate)new Predicate<Pair<R, C>>(){

            public final boolean apply(Pair<R, C> p) {
                return AbstractRelation.this.contains(p.x(), p.y());
            }
        });
    }

    @Override
    public int size() {
        int size = 0;
        for (Object row : this.rowHeads()) {
            for (Object col : this.colHeads()) {
                if (!this.contains(row, col)) continue;
                ++size;
            }
        }
        return size;
    }

    @Override
    public boolean isFull() {
        for (Object row : this.rowHeads()) {
            for (Object col : this.colHeads()) {
                if (this.contains(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Object row : this.rowHeads()) {
            for (Object col : this.colHeads()) {
                if (!this.contains(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public MatrixRelation<R, C> clone() {
        MatrixRelation<R, C> clone = new MatrixRelation<R, C>(this.rowHeads(), this.colHeads(), this.homogen);
        clone.addAllFast(this);
        return clone;
    }

    @Override
    public boolean[][] toArray() {
        boolean[][] a = new boolean[this.rowHeads().size()][this.colHeads().size()];
        for (int i = 0; i < this.rowHeads().size(); ++i) {
            for (int j = 0; j < this.colHeads().size(); ++j) {
                a[i][j] = this.contains(this.rowHeads().get(i), this.colHeads().get(j));
            }
        }
        return a;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getName() + "@" + this.hashCode() + "\r\n");
        s.append(this.rowHeads().size() + " domain elements.\r\n");
        s.append(this.colHeads().size() + " codomain elements.\r\n");
        String spaces = "";
        while (spaces.length() < 5) {
            spaces = spaces + " ";
        }
        s.append(spaces);
        spaces = spaces.substring(1);
        for (Object col : this.colHeads()) {
            String c = col.toString().substring(0, Math.min(5, col.toString().length()));
            while (c.length() < 5) {
                c = c + " ";
            }
            s.append("\t" + c);
        }
        s.append("\r\n");
        for (Object row : this.rowHeads()) {
            String r = row.toString().substring(0, Math.min(5, row.toString().length()));
            while (r.length() < 5) {
                r = r + " ";
            }
            s.append(r);
            for (Object col : this.colHeads()) {
                if (this.contains(row, col)) {
                    s.append("\tX" + spaces);
                    continue;
                }
                s.append("\t." + spaces);
            }
            s.append("\r\n");
        }
        return s.toString();
    }

    @Override
    public void empty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(R row, C col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addFast(Object o1, Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Relation<? extends R, ? extends C> r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllFast(Relation<?, ?> r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o1, Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Relation<?, ?> r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Relation<?, ?> r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHomogen() {
        return this.homogen;
    }

    protected final void checkHomogen() throws Relation.NoHomogenRelationException {
        if (!this.isHomogen()) {
            throw new Relation.NoHomogenRelationException();
        }
    }

    @Override
    public MatrixRelation<R, R> neighborhood() {
        this.checkHomogen();
        return ((MatrixRelation)this.clone()).neighborhood();
    }

    @Override
    public MatrixRelation<R, R> order() {
        this.checkHomogen();
        return ((MatrixRelation)this.clone()).order();
    }

    @Override
    public SetList<Set<R>> equivalenceClasses() {
        this.checkHomogen();
        return new AbstractSetList<Set<R>>(){

            @Override
            public final ListIterator<Set<R>> listIterator(final int i) {
                return new SimpleListIterator<Set<R>>(true){
                    private final HashSet<R> available;
                    {
                        super(dontCreateFirst);
                        this.available = new HashSet(AbstractRelation.this.rowHeads());
                        this.createFirst(i);
                    }

                    @Override
                    protected final Set<R> createNext() {
                        try {
                            Object head = Collections3.firstElement(this.available);
                            HashSet eq = new HashSet(AbstractRelation.this.col(head));
                            this.available.removeAll(eq);
                            return eq;
                        }
                        catch (NoSuchElementException e) {
                            return null;
                        }
                    }

                    @Override
                    protected final Set<R> createPrevious() {
                        return null;
                    }
                };
            }
        };
    }
}

