/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.relation;

import com.google.common.base.Predicate;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.math.PartialComparable;
import java.util.Collection;
import java.util.Set;

public interface Relation<R, C>
extends Iterable<Pair<R, C>>,
PartialComparable<Relation<R, C>>,
Cloneable {
    public SetList<R> rowHeads();

    public SetList<C> colHeads();

    public boolean add(R var1, C var2);

    public boolean addFast(Object var1, Object var2);

    public boolean addAll(Relation<? extends R, ? extends C> var1);

    public boolean addAllFast(Relation<?, ?> var1);

    public boolean contains(Object var1, Object var2);

    public boolean containsAll(Relation<?, ?> var1);

    public boolean remove(Object var1, Object var2);

    public boolean removeAll(Relation<?, ?> var1);

    public boolean retainAll(Relation<?, ?> var1);

    public Set<C> row(Object var1);

    public Set<R> col(Object var1);

    public Set<C> rowAnd(Object ... var1);

    public Set<R> colAnd(Object ... var1);

    public Set<C> rowAnd(Collection<?> var1);

    public Set<R> colAnd(Collection<?> var1);

    public Relation<R, C> subRelation(Collection<?> var1, Collection<?> var2);

    public Relation<R, C> filter(Predicate<? super R> var1, Predicate<? super C> var2, Predicate<Pair<R, C>> var3);

    public int size();

    default public double density() {
        return (double)this.size() / (double)(this.rowHeads().size() * this.colHeads().size());
    }

    public boolean isEmpty();

    public boolean isFull();

    public void empty();

    public void fill();

    public void dispose();

    public MatrixRelation<R, C> clone();

    public boolean[][] toArray();

    public boolean isHomogen();

    public MatrixRelation<R, R> neighborhood() throws NoHomogenRelationException;

    public MatrixRelation<R, R> order() throws NoHomogenRelationException;

    public SetList<Set<R>> equivalenceClasses() throws NoHomogenRelationException;

    public static final class NoHomogenRelationException
    extends RuntimeException {
        private static final long serialVersionUID = -3920949710978936537L;
    }
}

