/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.relation;

import conexp.fx.core.collections.Pair;
import java.util.Collections;
import java.util.Set;

public final class RelationEvent<R, C> {
    public static final Type ANY = Type.ANY;
    public static final Type ROWS = Type.ROWS;
    public static final Type ROWS_ADDED = Type.ROWS_ADDED;
    public static final Type ROWS_SET = Type.ROWS_SET;
    public static final Type ROWS_REMOVED = Type.ROWS_REMOVED;
    public static final Type ROWS_CLEARED = Type.ROWS_CLEARED;
    public static final Type COLUMNS = Type.COLUMNS;
    public static final Type COLUMNS_ADDED = Type.COLUMNS_ADDED;
    public static final Type COLUMNS_SET = Type.COLUMNS_SET;
    public static final Type COLUMNS_REMOVED = Type.COLUMNS_REMOVED;
    public static final Type COLUMNS_CLEARED = Type.COLUMNS_CLEARED;
    public static final Type ENTRIES = Type.ENTRIES;
    public static final Type ENTRIES_ADDED = Type.ENTRIES_ADDED;
    public static final Type ENTRIES_REMOVED = Type.ENTRIES_REMOVED;
    public static final Type ALL_CHANGED = Type.ALL_CHANGED;
    public static final Type SELECTION_CHANGED = Type.SELECTION_CHANGED;
    private final Type type;
    private final Set<R> rows;
    private final Set<Pair<R, R>> setRows;
    private final Set<C> cols;
    private final Set<Pair<C, C>> setCols;
    private final Set<Pair<R, C>> entries;

    public RelationEvent(Type type) {
        this.type = type;
        this.rows = Collections.unmodifiableSet(Collections.emptySet());
        this.setRows = Collections.unmodifiableSet(Collections.emptySet());
        this.cols = Collections.unmodifiableSet(Collections.emptySet());
        this.setCols = Collections.unmodifiableSet(Collections.emptySet());
        this.entries = Collections.unmodifiableSet(Collections.emptySet());
    }

    public RelationEvent(Type type, R row, C col) {
        this(type, row == null ? null : Collections.singleton(row), col == null ? null : Collections.singleton(col), null);
    }

    public RelationEvent(Type type, Set<R> rows, Set<C> columns, Set<Pair<R, C>> entries) {
        this.type = type;
        this.rows = Collections.unmodifiableSet(rows == null ? Collections.emptySet() : rows);
        this.setRows = Collections.unmodifiableSet(Collections.emptySet());
        this.cols = Collections.unmodifiableSet(columns == null ? Collections.emptySet() : columns);
        this.setCols = Collections.unmodifiableSet(Collections.emptySet());
        this.entries = Collections.unmodifiableSet(entries == null ? Collections.emptySet() : entries);
    }

    public RelationEvent(Type type, Pair<R, R> setRow, Pair<C, C> setColumn) {
        this(type, setRow == null ? null : Collections.singleton(setRow), setColumn == null ? null : Collections.singleton(setColumn));
    }

    public RelationEvent(Type type, Set<Pair<R, R>> setRows, Set<Pair<C, C>> setColumns) {
        this.type = type;
        this.rows = Collections.unmodifiableSet(Collections.emptySet());
        this.setRows = Collections.unmodifiableSet(setRows == null ? Collections.emptySet() : setRows);
        this.cols = Collections.unmodifiableSet(Collections.emptySet());
        this.setCols = Collections.unmodifiableSet(setColumns == null ? Collections.emptySet() : setColumns);
        this.entries = Collections.unmodifiableSet(Collections.emptySet());
    }

    public final Type getType() {
        return this.type;
    }

    public final Set<R> getRows() {
        return this.rows;
    }

    public final Set<Pair<R, R>> getSetRows() {
        return this.setRows;
    }

    public final Set<C> getColumns() {
        return this.cols;
    }

    public final Set<Pair<C, C>> getSetColumns() {
        return this.setCols;
    }

    public final Set<Pair<R, C>> getEntries() {
        return this.entries;
    }

    public static enum Type {
        ANY(null),
        ROWS(ANY),
        ROWS_ADDED(ROWS),
        ROWS_SET(ROWS),
        ROWS_REMOVED(ROWS),
        ROWS_CLEARED(ROWS),
        COLUMNS(ANY),
        COLUMNS_ADDED(COLUMNS),
        COLUMNS_SET(COLUMNS),
        COLUMNS_REMOVED(COLUMNS),
        COLUMNS_CLEARED(COLUMNS),
        ENTRIES(ANY),
        ENTRIES_ADDED(ENTRIES),
        ENTRIES_REMOVED(ENTRIES),
        ALL_CHANGED(ENTRIES),
        SELECTION_CHANGED(ANY);

        private final Type superType;

        private Type(Type superType) {
            this.superType = superType;
        }

        public final Type getSuperType() {
            return this.superType;
        }
    }
}

