/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.setlist;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.math.GuavaIsomorphism;
import conexp.fx.core.math.Isomorphism;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;

public interface SetList<E>
extends Set<E>,
List<E>,
Collection<E>,
Iterable<E>,
Cloneable {
    public boolean set(Object var1, E var2);

    public Collection<E> getAll(Collection<Integer> var1, boolean var2);

    public Collection<Integer> indicesOf(Collection<?> var1, boolean var2);

    @Override
    @Deprecated
    public int lastIndexOf(Object var1);

    public SetList<E> filter(Predicate<? super E> var1);

    @Override
    public SetList<E> subList(int var1, int var2);

    public BitSetFX subBitSet(Collection<?> var1);

    default public HashSetArrayList<E> clone() {
        return new HashSetArrayList(this);
    }

    default public GuavaIsomorphism<E, Integer> indexGuava() {
        return new GuavaIsomorphism<E, Integer>(){

            public final Integer apply(E e) {
                return SetList.this.indexOf(e);
            }

            @Override
            public final E invert(Integer i) {
                return SetList.this.get(i);
            }
        };
    }

    default public Isomorphism<E, Integer> index() {
        return new Isomorphism<Object, Integer>(this::indexOf, this::get);
    }

    default public Isomorphism<E, Integer> currentIndex() {
        ConcurrentHashMap indexOfMap = new ConcurrentHashMap();
        ConcurrentHashMap getMap = new ConcurrentHashMap();
        int i = 0;
        for (Object e : this) {
            indexOfMap.put(e, i);
            getMap.put(i, e);
            ++i;
        }
        return new Isomorphism<Object, Integer>(indexOfMap::get, getMap::get);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 16);
    }

    default public LecticOrder<E> getLecticOrder() {
        return new LecticOrder(this);
    }

    public static class LecticOrder<E> {
        private final SetList<E> base;

        private LecticOrder(SetList<E> base) {
            this.base = base;
        }

        public static final <T> Comparator<T> toComparator(BiPredicate<T, T> isSmallerPredicate) {
            return (x, y) -> x.equals(y) ? 0 : (isSmallerPredicate.test(x, y) ? -1 : 1);
        }

        public final Comparator<E> getIndexComparator() {
            return (x, y) -> {
                int j;
                int i = this.base.indexOf(x);
                if (i == (j = this.base.indexOf(y))) {
                    return 0;
                }
                if (i < j) {
                    return -1;
                }
                return 1;
            };
        }

        public final Comparator<Set<E>> getLecticComparator() {
            return LecticOrder.toComparator(this::isSmaller);
        }

        public final Comparator<Set<E>> getLecticComparator(E element) {
            return LecticOrder.toComparator((x, y) -> this.isSmaller((Set<E>)x, (Set<E>)y, element));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isSmaller(Set<E> set1, Set<E> set2) {
            if (set1.equals(set2)) return false;
            if (Sets.symmetricDifference(set1, set2).stream().sorted(this.getIndexComparator()).findFirst().map(set2::contains).get() == false) return false;
            return true;
        }

        public final boolean isSmaller(Set<E> set1, Set<E> set2, E element) {
            return !set1.equals(set2) && set2.contains(element) && Sets.symmetricDifference(set1, set2).stream().sorted(this.getIndexComparator()).findFirst().get().equals(element);
        }

        public final Set<E> oplus(Set<E> set, E m) {
            HashSet<E> result = new HashSet<E>(set);
            result.retainAll(this.base.subList(0, this.base.indexOf(m)));
            result.add(m);
            return result;
        }
    }
}

