/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.setlist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import conexp.fx.core.collections.ListIterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.UnmodifiableSetList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;

public final class SetLists {
    public static final <E> SetList<E> empty() {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.empty();
            }
        };
    }

    public static final <E> HashSetArrayList<E> create(E ... e) {
        return SetLists.create(Arrays.asList(e));
    }

    public static final <E> HashSetArrayList<E> create(Collection<? extends E> c) {
        return new HashSetArrayList<E>(c);
    }

    public static final <E> SetList<E> unmodifiable(final SetList<E> s) {
        if (s instanceof UnmodifiableSetList) {
            return (UnmodifiableSetList)s;
        }
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.unmodifiable(s.listIterator(i));
            }
        };
    }

    public static final <E> SetList<E> filter(final SetList<? extends E> s, final Predicate<? super E> p) {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.filter(s.listIterator(), p, i);
            }
        };
    }

    public static final <T, E> SetList<E> transform(final SetList<? extends T> s, final Function<? super T, E> f) {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.transform(s.listIterator(i), f);
            }
        };
    }

    public static final SetList<Integer> integers(final int size) {
        return new UnmodifiableSetList<Integer>(){

            @Override
            public final ListIterator<Integer> listIterator(int i) {
                return ListIterators.integers(i, size);
            }

            @Override
            public final int size() {
                return size;
            }
        };
    }

    public static final <T, E> SetList<Pair<T, E>> disjointUnion(final SetList<T> s1, final SetList<E> s2) {
        return new UnmodifiableSetList<Pair<T, E>>(){

            @Override
            public final ListIterator<Pair<T, E>> listIterator(int i) {
                return ListIterators.disjointUnion(s1.listIterator(), s2.listIterator(), i);
            }
        };
    }

    public static final <T, E> SetList<Pair<T, E>> cartesianProduct(final SetList<T> s1, final SetList<E> s2) {
        return new UnmodifiableSetList<Pair<T, E>>(){

            @Override
            public final ListIterator<Pair<T, E>> listIterator(int i) {
                return ListIterators.cartesianProduct(s1.listIterator(), s2.listIterator(), i);
            }
        };
    }

    public static final <E> SetList<E> union(final SetList<? extends E> s1, final SetList<? extends E> s2) {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.concat(s1.listIterator(), ListIterators.filter(s2.listIterator(), Predicates.not((Predicate)Predicates.in((Collection)s1))), i);
            }
        };
    }

    public static final <E> SetList<E> intersection(final SetList<E> s, final Collection<?> c) {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.filter(s.listIterator(), Predicates.in((Collection)c), i);
            }
        };
    }

    public static final <E> SetList<E> difference(final SetList<E> s, final Collection<?> c) {
        return new UnmodifiableSetList<E>(){

            @Override
            public final ListIterator<E> listIterator(int i) {
                return ListIterators.filter(s.listIterator(), Predicates.not((Predicate)Predicates.in((Collection)c)), i);
            }
        };
    }

    public static final <E> SetList<SetList<E>> powerSet(final SetList<E> s) {
        return new UnmodifiableSetList<SetList<E>>(){
            private final int size;
            {
                this.size = 1 << s.size();
            }

            @Override
            public final int size() {
                return this.size;
            }

            @Override
            public final boolean isEmpty() {
                return false;
            }

            @Override
            public final SetList<E> get(final int i) {
                if (i < 0 || i > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new UnmodifiableSetList<E>(){

                    @Override
                    public ListIterator<E> listIterator(int j) {
                        return ListIterators.filter(s.listIterator(), new Predicate<E>(){

                            public final boolean apply(E e) {
                                return (i >> s.indexOf(e)) % 2 == 1;
                            }
                        }, j);
                    }
                };
            }

            @Override
            public final ListIterator<SetList<E>> listIterator(int i) {
                return ListIterators.transform(ListIterators.integers(i, this.size), new Function<Integer, SetList<E>>(){

                    public final SetList<E> apply(Integer j) {
                        return this.get(j);
                    }
                });
            }
        };
    }
}

