/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import conexp.fx.core.collections.relation.AbstractRelation;
import conexp.fx.core.collections.relation.Relation;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.MatrixContext;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiPredicate;

public abstract class AbstractContext<G, M>
extends AbstractRelation<G, M>
implements Context<G, M> {
    public static <G, M> AbstractContext<G, M> fromPredicate(SetList<G> objects, SetList<M> attributes, final BiPredicate<G, M> predicate) {
        return new AbstractContext<G, M>(objects, attributes, false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                try {
                    return predicate.test(o1, o2);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    public static <G> AbstractContext<G, G> fromPredicate(SetList<G> objects, final BiPredicate<G, G> predicate) {
        return new AbstractContext<G, G>(objects, objects, true){

            @Override
            public final boolean contains(Object o1, Object o2) {
                try {
                    return predicate.test(o1, o2);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        };
    }

    protected AbstractContext(SetList<G> objects, SetList<M> attributes, boolean homogen) {
        super(objects, attributes, homogen);
    }

    @Override
    public Set<G> extent(Collection<?> objects) {
        return this.colAnd(this.rowAnd(objects));
    }

    @Override
    public Set<M> intent(Collection<?> attributes) {
        return this.rowAnd(this.colAnd(attributes));
    }

    @Override
    public Set<G> extent(Object ... objects) {
        if (objects.length == 1) {
            return this.colAnd(this.row(objects[0]));
        }
        return this.colAnd(this.rowAnd(objects));
    }

    @Override
    public Set<M> intent(Object ... attributes) {
        if (attributes.length == 1) {
            return this.rowAnd(this.col(attributes[0]));
        }
        return this.rowAnd(this.colAnd(attributes));
    }

    @Override
    public final Relation<G, G> objectQuasiOrder() {
        return new AbstractRelation<G, G>(this.rowHeads(), this.rowHeads(), true){

            @Override
            public final boolean contains(Object object1, Object object2) {
                return AbstractContext.this.row(object1).containsAll(AbstractContext.this.row(object2));
            }
        };
    }

    @Override
    public final Relation<M, M> attributeQuasiOrder() {
        return new AbstractRelation<M, M>(this.colHeads(), this.colHeads(), true){

            @Override
            public final boolean contains(Object attribute1, Object attribute2) {
                return AbstractContext.this.col(attribute1).containsAll(AbstractContext.this.col(attribute2));
            }
        };
    }

    @Override
    public MatrixContext<G, M> clone() {
        MatrixContext clone = new MatrixContext(this.rowHeads().clone(), this.colHeads().clone(), false);
        clone.rowHeads().parallelStream().forEach(object -> clone.row(object).addAll(this.row(object)));
        return clone;
    }

    @Override
    public final AbstractContext<G, M> getSelection() {
        return this;
    }
}

