/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import conexp.fx.core.math.PartialComparable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

public class Concept<G, M>
implements de.tudresden.inf.tcs.fcaapi.Concept<M, G>,
PartialComparable<Concept<G, M>>,
Cloneable {
    private final ObservableSet<G> extent;
    private final ObservableSet<M> intent;

    public Concept(Set<G> extent, Set<M> intent) {
        this.extent = extent instanceof ObservableSet ? (ObservableSet)extent : FXCollections.observableSet(extent);
        this.intent = intent instanceof ObservableSet ? (ObservableSet)intent : FXCollections.observableSet(intent);
    }

    public Concept(Collection<G> extent, Collection<M> intent) {
        this((Set<G>)new HashSet<G>(extent), (Set<M>)new HashSet<M>(intent));
    }

    public final ObservableSet<G> extent() {
        return this.extent;
    }

    public Set<G> getExtent() {
        return this.extent;
    }

    public final ObservableSet<M> intent() {
        return this.intent;
    }

    public Set<M> getIntent() {
        return this.intent;
    }

    @Override
    public final boolean smallerEq(Concept<G, M> concept) {
        return this.intent.containsAll(concept.intent);
    }

    @Override
    public final boolean smaller(Concept<G, M> concept) {
        return this.intent.size() > concept.intent.size() && this.smallerEq(concept);
    }

    @Override
    public final boolean greaterEq(Concept<G, M> concept) {
        return concept.smallerEq(this);
    }

    @Override
    public final boolean greater(Concept<G, M> concept) {
        return concept.smaller(this);
    }

    @Override
    public final boolean uncomparable(Concept<G, M> concept) {
        return !this.smallerEq(concept) && !this.greaterEq(concept);
    }

    @Override
    public final int compareTo(Concept<G, M> concept) {
        if (this.equals(concept)) {
            return 0;
        }
        if (this.smallerEq(concept)) {
            return -1;
        }
        if (this.greaterEq(concept)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public final Concept<G, M> clone() {
        return new Concept<G, M>(new HashSet<G>(this.extent), new HashSet<M>(this.intent));
    }

    public final boolean equals(Object object) {
        return object != null && object instanceof Concept && this.extent.equals(((Concept)object).extent);
    }

    public final int hashCode() {
        return this.extent.hashCode();
    }

    public final String toString() {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append("{");
        boolean first = true;
        for (Object g : this.extent) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(g.toString());
        }
        s.append("}");
        s.append(",");
        s.append("{");
        first = true;
        for (Object m : this.intent) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(m.toString());
        }
        s.append("}");
        s.append(")");
        return s.toString();
    }
}

