/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import com.google.common.collect.Sets;
import conexp.fx.core.collections.relation.Relation;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import java.util.Collection;
import java.util.Set;

public interface Context<G, M>
extends Relation<G, M> {
    public Set<G> extent(Collection<?> var1);

    public Set<M> intent(Collection<?> var1);

    public Set<G> extent(Object ... var1);

    public Set<M> intent(Object ... var1);

    public Relation<G, G> objectQuasiOrder();

    public Relation<M, M> attributeQuasiOrder();

    @Override
    public MatrixContext<G, M> clone();

    public Context<G, M> getSelection();

    default public boolean models(Implication<G, M> implication, boolean ... checkSupport) {
        Set support = this.colAnd(implication.getPremise());
        double confidence = support.isEmpty() ? 1.0 : (double)this.colAnd((Collection<?>)Sets.union((Set)implication.getPremise(), (Set)implication.getConclusion())).size() / (double)support.size();
        return implication.getConfidence() == confidence && (checkSupport.length == 0 || !checkSupport[0] || implication.getSupport().equals(support));
    }

    default public boolean models(Collection<Implication<G, M>> implications, boolean ... checkSupport) {
        return implications.parallelStream().allMatch(implication -> this.models((Implication<G, M>)((Object)implication), checkSupport));
    }

    default public boolean has(Concept<G, M> concept) {
        return concept.extent().equals(this.colAnd((Collection<?>)concept.intent())) && concept.intent().equals(this.rowAnd((Collection<?>)concept.extent()));
    }

    default public MatrixContext<G, M> toMatrixContext() {
        return this instanceof MatrixContext ? (MatrixContext)this : this.clone();
    }
}

