/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.exporter.CXTExporter;
import conexp.fx.core.importer.CXTImporter;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.calculation.Calculation;

public class Contexts {
    public static final MatrixContext<Integer, Integer> randomWithDensity(int objects, int attributes, int density) {
        MatrixContext<Integer, Integer> cxt = new MatrixContext<Integer, Integer>(SetLists.integers(objects), SetLists.integers(attributes), false);
        Random rng = new Random();
        int target = (int)((double)(objects * attributes * density) / 100.0);
        int current = 0;
        while (current < target) {
            int g = rng.nextInt(objects);
            int m = rng.nextInt(attributes);
            if (cxt.matrix().getBoolean(new long[]{g, m})) continue;
            cxt.matrix().setBoolean(true, new long[]{g, m});
            ++current;
        }
        return cxt;
    }

    public static final MatrixContext<Integer, Integer> randomWithProbability(int objects, int attributes, int probability) {
        MatrixContext<Integer, Integer> cxt = new MatrixContext<Integer, Integer>(SetLists.integers(objects), SetLists.integers(attributes), false);
        Random rng = new Random();
        for (int g = 0; g < objects; ++g) {
            for (int m = 0; m < attributes; ++m) {
                if (!(rng.nextDouble() <= (double)probability)) continue;
                cxt.addFast(g, m);
            }
        }
        return cxt;
    }

    public static final <G, M> Map<Set<M>, Set<M>> pseudoIntents(MatrixContext<G, M> cxt) {
        HashMap<Set<M>, Set<M>> pseudoIntents = new HashMap<Set<M>, Set<M>>();
        for (Set set : SetLists.powerSet(cxt.colHeads())) {
            Set<M> intent;
            if (set.containsAll(intent = cxt.intent(set))) continue;
            boolean isPseudoIntent = true;
            for (Map.Entry pseudoIntent : pseudoIntents.entrySet()) {
                if (set.size() <= ((Set)pseudoIntent.getKey()).size() || !set.containsAll((Collection)pseudoIntent.getKey()) || set.containsAll((Collection)pseudoIntent.getValue())) continue;
                isPseudoIntent = false;
                break;
            }
            if (!isPseudoIntent) continue;
            intent = new HashSet<M>(intent);
            intent.removeAll(set);
            pseudoIntents.put(set, intent);
        }
        return pseudoIntents;
    }

    public static final void extractFast(File input, File output, int steps) throws Exception {
        MatrixContext<String, String> cxt = new MatrixContext<String, String>(false);
        CXTImporter.read(cxt, input);
        SetList domain = cxt.rowHeads();
        SetList codomain = cxt.colHeads();
        BooleanMatrix matrix = cxt.matrix();
        int objs = domain.size();
        int atts = codomain.size();
        for (int att = steps; att < atts; att += steps) {
            BooleanMatrix submatrix = matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, 0L, objs - 1, att - 1}).toBooleanMatrix();
            CXTExporter.export(new MatrixContext(domain, codomain.subList(0, att), submatrix, false), new File(output.getAbsolutePath().replace(".cxt", "_" + att + ".cxt")));
        }
    }

    public static final void extractAttributeSubcontextFamily(File input, File output, int steps) throws Exception {
        MatrixContext<String, String> cxt = new MatrixContext<String, String>(false);
        CXTImporter.read(cxt, input);
        int atts = cxt.colHeads().size();
        for (int att = steps; att < atts; att += steps) {
            MatrixRelation subcxt = cxt.subRelation((Collection)cxt.rowHeads(), (Collection)cxt.colHeads().subList(0, att)).clone();
            System.out.println(subcxt.rowHeads().size());
            System.out.println(subcxt.colHeads().size());
        }
    }

    public static final void extractSubcontext(File input, File output, int objs, int atts) throws Exception {
        MatrixContext<String, String> context = new MatrixContext<String, String>(false);
        CXTImporter.read(context, input);
        MatrixRelation subcxt = context.subRelation((Collection)context.rowHeads().subList(0, objs), (Collection)context.colHeads().subList(0, atts)).clone();
        CXTExporter.export(subcxt, output);
    }
}

