/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import conexp.fx.core.math.ClosureOperator;
import de.tudresden.inf.tcs.fcaapi.FCAImplication;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class Implication<G, M>
extends de.tudresden.inf.tcs.fcalib.Implication<M> {
    private final Set<G> support;
    private final double confidence;

    public static final <G, M> boolean equivalent(Set<Implication<G, M>> x, Set<Implication<G, M>> y) {
        return Implication.entails(x, y) && Implication.entails(y, x);
    }

    public static final <G, M> boolean entails(Set<Implication<G, M>> x, Set<Implication<G, M>> y) {
        return y.parallelStream().allMatch(z -> Implication.entails(x, z));
    }

    public static final <G, M> Set<Implication<G, M>> diff(Set<Implication<G, M>> x, Set<Implication<G, M>> y) {
        return y.parallelStream().filter(z -> !Implication.entails(x, z)).collect(Collectors.toSet());
    }

    public static final <G, M> boolean entails(Set<Implication<G, M>> x, Implication<G, M> y) {
        return ClosureOperator.fromImplications(x, false, false).closure(y.getPremise()).containsAll(y.getConclusion());
    }

    public Implication() {
        this(new HashSet(), new HashSet(), new HashSet());
    }

    public Implication(Set<M> premise, Set<M> conclusion) {
        this(premise, conclusion, new HashSet());
    }

    public Implication(Set<M> premise, Set<M> conclusion, Set<G> support) {
        this(premise, conclusion, support, 1.0);
    }

    public Implication(Set<M> premise, Set<M> conclusion, Set<G> support, double confidence) {
        super(premise, conclusion);
        this.support = support;
        if (confidence < 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be in range [0,1]");
        }
        this.confidence = confidence;
    }

    public Implication(Collection<M> premise, Collection<M> conclusion) {
        this(new HashSet<M>(premise), new HashSet<M>(conclusion));
    }

    public Implication(Collection<M> premise, Collection<M> conclusion, Collection<G> support) {
        this(premise instanceof Set ? premise : new HashSet(premise), conclusion instanceof Set ? conclusion : new HashSet(conclusion), support instanceof Set ? support : new HashSet(support), 1.0);
    }

    public Implication(M premise, Set<M> conclusion) {
        this(Collections.singleton(premise), conclusion);
    }

    public Implication(Set<M> premise, M conclusion) {
        this(premise, Collections.singleton(conclusion));
    }

    public Implication(M premise, M conclusion) {
        this(Collections.singleton(premise), Collections.singleton(conclusion));
    }

    public final Set<G> getSupport() {
        return this.support;
    }

    public final double getConfidence() {
        return this.confidence;
    }

    public boolean isTrivial() {
        return this.getPremise().containsAll(this.getConclusion());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Implication)) {
            if (obj instanceof FCAImplication) {
                return super.equals((FCAImplication)obj);
            }
            return false;
        }
        Implication other = (Implication)((Object)obj);
        return this.getPremise().equals(other.getPremise()) && this.getConclusion().equals(other.getConclusion());
    }

    public int hashCode() {
        return this.getPremise().hashCode() + this.getConclusion().hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<Object> pit = this.getPremise().iterator();
        if (pit.hasNext()) {
            s.append(pit.next());
        }
        pit.forEachRemaining(m -> s.append(" \u22c0 " + m));
        s.append(" \u27f6 ");
        UnmodifiableIterator cit = Sets.difference((Set)this.getConclusion(), (Set)this.getPremise()).iterator();
        if (cit.hasNext()) {
            s.append(cit.next());
        }
        cit.forEachRemaining(m -> s.append(" \u22c0 " + m));
        if (this.confidence < 1.0) {
            s.append(" (" + (int)(100.0 * this.confidence) + "%)");
        }
        return s.toString();
    }
}

