/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import conexp.fx.core.algorithm.nextclosure.NextConcept;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.AbstractRelation;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.relation.Relation;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.AbstractContext;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import conexp.fx.core.math.BooleanMatrices;
import conexp.fx.core.math.GuavaIsomorphism;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.calculation.Calculation;

public class MatrixContext<G, M>
extends MatrixRelation<G, M>
implements Context<G, M> {
    public final StringProperty id = new SimpleStringProperty(null);
    public MatrixContext<G, M> selection = this;
    public final SetList<Set<Integer>> _objects = new HashSetArrayList<Set<Integer>>();
    public final SetList<Set<Integer>> _attributes = new HashSetArrayList<Set<Integer>>();
    private final Collection<Integer> i = Collections2.transform(this._objects, Collections3.firstElement());
    private final Collection<Integer> j = Collections2.transform(this._attributes, Collections3.firstElement());
    public final Context<Set<Integer>, Set<Integer>> _cleaned = new AbstractContext<Set<Integer>, Set<Integer>>(this._objects, this._attributes, false){

        @Override
        public final boolean contains(Object _i, Object _j) {
            return MatrixContext.this.matrix.getBoolean(new long[]{((Integer)Collections3.firstElement((Set)_i)).intValue(), ((Integer)Collections3.firstElement((Set)_j)).intValue()});
        }

        @Override
        public final MatrixContext<Set<Integer>, Set<Integer>> clone() {
            return new MatrixContext<Set<Integer>, Set<Integer>>(MatrixContext.this._objects, MatrixContext.this._attributes, (BooleanMatrix)MatrixContext.this.matrix.selectRows(Calculation.Ret.NEW, MatrixContext.this.i).selectColumns(Calculation.Ret.NEW, MatrixContext.this.j), false);
        }
    };
    public Relation<Set<Integer>, Set<Integer>> _downArrows = new AbstractRelation<Set<Integer>, Set<Integer>>(this._objects, this._attributes, false){

        @Override
        public final boolean contains(Object object, Object attribute) {
            int rowIndex = (Integer)Collections3.firstElement((Set)object);
            int columnIndex = (Integer)Collections3.firstElement((Set)attribute);
            if (!MatrixContext.this.matrix.getBoolean(new long[]{rowIndex, columnIndex})) {
                return MatrixContext.this._col(columnIndex, MatrixContext.this.i).containsAll(MatrixContext.this._extent(Collections.singleton(rowIndex), Collections2.filter((Collection)MatrixContext.this.i, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)rowIndex))), MatrixContext.this.j));
            }
            return false;
        }
    };
    public Relation<Set<Integer>, Set<Integer>> _upArrows = new AbstractRelation<Set<Integer>, Set<Integer>>(this._objects, this._attributes, false){

        @Override
        public final boolean contains(Object object, Object attribute) {
            int _i = (Integer)Collections3.firstElement((Set)object);
            int _j = (Integer)Collections3.firstElement((Set)attribute);
            if (!MatrixContext.this.matrix.getBoolean(new long[]{_i, _j})) {
                return MatrixContext.this._row(_i, MatrixContext.this.j).containsAll(MatrixContext.this._intent(Collections.singleton(_j), MatrixContext.this.i, Collections2.filter((Collection)MatrixContext.this.j, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)_j)))));
            }
            return false;
        }
    };
    public Relation<Set<Integer>, Set<Integer>> _downPaths;
    public Relation<Set<Integer>, Set<Integer>> _upPaths;
    private final Predicate<Set<Integer>> _isIrreducibleObject = new Predicate<Set<Integer>>(){

        public final boolean apply(Set<Integer> i) {
            for (Set set : MatrixContext.this._attributes) {
                if (!MatrixContext.this._downArrows.contains(i, set)) continue;
                return true;
            }
            return false;
        }
    };
    private final Predicate<Set<Integer>> _isIrreducibleAttribute = new Predicate<Set<Integer>>(){

        public final boolean apply(Set<Integer> j) {
            for (Set set : MatrixContext.this._objects) {
                if (!MatrixContext.this._upArrows.contains(set, j)) continue;
                return true;
            }
            return false;
        }
    };
    public final SetList<Set<Integer>> _irreducibleObjects = new HashSetArrayList<Set<Integer>>();
    public final SetList<Set<Integer>> _irreducibleAttributes = new HashSetArrayList<Set<Integer>>();
    public final Context<Set<Integer>, Set<Integer>> _reduced = new AbstractContext<Set<Integer>, Set<Integer>>(this._irreducibleObjects, this._irreducibleAttributes, false){

        @Override
        public final boolean contains(Object _i, Object _j) {
            return MatrixContext.this.matrix.getBoolean(new long[]{((Integer)Collections3.firstElement((Set)_i)).intValue(), ((Integer)Collections3.firstElement((Set)_j)).intValue()});
        }

        @Override
        public final MatrixContext<Set<Integer>, Set<Integer>> clone() {
            return new MatrixContext<Set<Integer>, Set<Integer>>(MatrixContext.this._irreducibleObjects, MatrixContext.this._irreducibleAttributes, (BooleanMatrix)MatrixContext.this.matrix.selectRows(Calculation.Ret.NEW, Collections2.transform(MatrixContext.this._irreducibleObjects, Collections3.firstElement())).selectColumns(Calculation.Ret.NEW, Collections2.transform(MatrixContext.this._irreducibleAttributes, Collections3.firstElement())), false);
        }
    };
    public final Function<Iterable<Integer>, G> _firstObject = Functions.compose(this.rowHeads.indexGuava().inverse(), Collections3.firstElement());
    public final Function<Iterable<Integer>, M> _firstAttribute = Functions.compose(this.colHeads.indexGuava().inverse(), Collections3.firstElement());
    public final GuavaIsomorphism<Set<Integer>, Set<G>> _allObjects = new GuavaIsomorphism<Set<Integer>, Set<G>>(){

        public final Set<G> apply(Set<Integer> set) {
            return Collections3.transform(set, GuavaIsomorphism.invert(MatrixContext.this.rowHeads().indexGuava()));
        }

        @Override
        public Set<Integer> invert(Set<G> set) {
            return Collections3.transform(set, MatrixContext.this.rowHeads().indexGuava());
        }
    };
    public final GuavaIsomorphism<Set<Integer>, Set<M>> _allAttributes = new GuavaIsomorphism<Set<Integer>, Set<M>>(){

        public final Set<M> apply(Set<Integer> set) {
            return Collections3.transform(set, GuavaIsomorphism.invert(MatrixContext.this.colHeads().indexGuava()));
        }

        @Override
        public Set<Integer> invert(Set<M> set) {
            return Collections3.transform(set, MatrixContext.this.colHeads().indexGuava());
        }
    };
    public final AbstractContext<Set<G>, Set<M>> cleaned = new AbstractContext<Set<G>, Set<M>>(SetLists.transform(this._objects, this._allObjects), SetLists.transform(this._attributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._cleaned.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }

        @Override
        public MatrixContext<Set<G>, Set<M>> clone() {
            return new MatrixContext(this.rowHeads().clone(), this.colHeads().clone(), ((MatrixContext)MatrixContext.this._cleaned.clone()).matrix, false);
        }
    };
    public final AbstractContext<Set<G>, Set<M>> reduced = new AbstractContext<Set<G>, Set<M>>(SetLists.transform(this._irreducibleObjects, this._allObjects), SetLists.transform(this._irreducibleAttributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._reduced.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }
    };
    public final AbstractRelation<Set<G>, Set<M>> downArrows = new AbstractRelation<Set<G>, Set<M>>(SetLists.transform(this._objects, this._allObjects), SetLists.transform(this._attributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._downArrows.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }
    };
    public final AbstractRelation<Set<G>, Set<M>> upArrows = new AbstractRelation<Set<G>, Set<M>>(SetLists.transform(this._objects, this._allObjects), SetLists.transform(this._attributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._upArrows.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }
    };
    public final AbstractRelation<G, M> DownArrows = new AbstractRelation<G, M>(this.rowHeads, this.colHeads, false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._downArrows.contains(MatrixContext.this._objectEquivalence().col(this.rowHeads().indexOf(o1)), MatrixContext.this._attributeEquivalence().col(this.colHeads().indexOf(o2)));
        }
    };
    public final AbstractRelation<G, M> UpArrows = new AbstractRelation<G, M>(this.rowHeads, this.colHeads, false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._upArrows.contains(MatrixContext.this._objectEquivalence().col(this.rowHeads().indexOf(o1)), MatrixContext.this._attributeEquivalence().col(this.colHeads().indexOf(o2)));
        }
    };
    public final AbstractRelation<Set<G>, Set<M>> downPaths = new AbstractRelation<Set<G>, Set<M>>(SetLists.transform(this._objects, this._allObjects), SetLists.transform(this._attributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._downPaths.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }
    };
    public final AbstractRelation<Set<G>, Set<M>> upPaths = new AbstractRelation<Set<G>, Set<M>>(SetLists.transform(this._objects, this._allObjects), SetLists.transform(this._attributes, this._allAttributes), false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._upPaths.contains(MatrixContext.this._allObjects.invert((Set)o1), MatrixContext.this._allAttributes.invert((Set)o2));
        }
    };
    public final AbstractRelation<G, M> DownPaths = new AbstractRelation<G, M>(this.rowHeads, this.colHeads, false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._downPaths.contains(MatrixContext.this._objectEquivalence().col(this.rowHeads().indexOf(o1)), MatrixContext.this._attributeEquivalence().col(this.colHeads().indexOf(o2)));
        }
    };
    public final AbstractRelation<G, M> UpPaths = new AbstractRelation<G, M>(this.rowHeads, this.colHeads, false){

        @Override
        public boolean contains(Object o1, Object o2) {
            return MatrixContext.this._upPaths.contains(MatrixContext.this._objectEquivalence().col(this.rowHeads().indexOf(o1)), MatrixContext.this._attributeEquivalence().col(this.colHeads().indexOf(o2)));
        }
    };
    private final Set<M> ignoredAttributes = new HashSet<M>();
    private final Set<G> ignoredObjects = new HashSet<G>();
    private boolean lock = false;

    public MatrixContext(boolean homogen) {
        super(homogen);
        this.initHandlers(true, AutomaticMode.REDUCE);
    }

    public MatrixContext(SetList<G> objects, SetList<M> attributes, boolean homogen) {
        super(objects, attributes, homogen);
        this.initHandlers(true, AutomaticMode.REDUCE);
    }

    public MatrixContext(SetList<G> objects, SetList<M> attributes, BooleanMatrix matrix, boolean homogen) {
        super(objects, attributes, matrix, homogen);
        this.initHandlers(true, AutomaticMode.REDUCE);
    }

    public MatrixContext(boolean homogen, AutomaticMode automaticMode) {
        super(homogen);
        this.initHandlers(true, automaticMode);
    }

    public MatrixContext(SetList<G> objects, SetList<M> attributes, boolean homogen, AutomaticMode automaticMode) {
        super(objects, attributes, homogen);
        this.initHandlers(true, automaticMode);
    }

    public MatrixContext(SetList<G> objects, SetList<M> attributes, BooleanMatrix matrix, boolean homogen, AutomaticMode automaticMode) {
        super(objects, attributes, matrix, homogen);
        this.initHandlers(true, automaticMode);
    }

    public final void lock() {
        this.lock = true;
    }

    public final void unlock() {
        this.lock = false;
    }

    public void initHandlers(boolean selfSelecting, AutomaticMode auto) {
        if (selfSelecting) {
            this.addEventHandler(__ -> this.select(), RelationEvent.SELECTION_CHANGED);
            this.select();
        }
        switch (auto) {
            case REDUCE: {
                this.addEventHandler(__ -> {
                    if (!this.lock) {
                        this.reduce();
                    }
                }, RelationEvent.ALL_CHANGED, RelationEvent.ENTRIES);
                this.reduce();
                break;
            }
            case CLEAN: {
                this.addEventHandler(__ -> {
                    if (!this.lock) {
                        this.clean();
                    }
                }, RelationEvent.ALL_CHANGED, RelationEvent.ENTRIES);
                this.clean();
                break;
            }
        }
    }

    public final synchronized void select() {
        HashSetArrayList selectedColHeads = SetLists.difference(this.colHeads, this.ignoredAttributes).clone();
        HashSetArrayList selectedRowHeads = SetLists.difference(this.rowHeads, this.ignoredObjects).clone();
        if (this.ignoredAttributes.isEmpty() && this.ignoredObjects.isEmpty()) {
            this.selection = this;
            this.reduce();
        } else {
            this.selection = selectedColHeads.isEmpty() && selectedRowHeads.isEmpty() ? new MatrixContext<G, M>(false) : new MatrixContext(selectedRowHeads, selectedColHeads, (BooleanMatrix)this.matrix.selectColumns(Calculation.Ret.NEW, this.colHeads().indicesOf(selectedColHeads, false)).selectRows(Calculation.Ret.NEW, this.rowHeads().indicesOf(selectedRowHeads, false)), false);
        }
    }

    public final synchronized void clean() {
        this._objects.clear();
        this._objects.addAll(this._objectEquivalence().equivalenceClasses());
        this._attributes.clear();
        this._attributes.addAll(this._attributeEquivalence().equivalenceClasses());
    }

    public final synchronized void reduce() {
        this.clean();
        this._downArrows = new AbstractRelation<Set<Integer>, Set<Integer>>(this._objects, this._attributes, false){

            @Override
            public final boolean contains(Object object, Object attribute) {
                int rowIndex = (Integer)Collections3.firstElement((Set)object);
                int columnIndex = (Integer)Collections3.firstElement((Set)attribute);
                if (!MatrixContext.this.matrix.getBoolean(new long[]{rowIndex, columnIndex})) {
                    return MatrixContext.this._col(columnIndex, MatrixContext.this.i).containsAll(MatrixContext.this._extent(Collections.singleton(rowIndex), Collections2.filter((Collection)MatrixContext.this.i, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)rowIndex))), MatrixContext.this.j));
                }
                return false;
            }
        };
        this._upArrows = new AbstractRelation<Set<Integer>, Set<Integer>>(this._objects, this._attributes, false){

            @Override
            public final boolean contains(Object object, Object attribute) {
                int _i = (Integer)Collections3.firstElement((Set)object);
                int _j = (Integer)Collections3.firstElement((Set)attribute);
                if (!MatrixContext.this.matrix.getBoolean(new long[]{_i, _j})) {
                    return MatrixContext.this._row(_i, MatrixContext.this.j).containsAll(MatrixContext.this._intent(Collections.singleton(_j), MatrixContext.this.i, Collections2.filter((Collection)MatrixContext.this.j, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)_j)))));
                }
                return false;
            }
        };
        this._irreducibleObjects.clear();
        this._irreducibleObjects.addAll(this._objects.filter(this._isIrreducibleObject));
        this._irreducibleAttributes.clear();
        this._irreducibleAttributes.addAll(this._attributes.filter(this._isIrreducibleAttribute).clone());
    }

    public final Pair<Incidence, Incidence> getValue(G g, M m, boolean ... withArrows) {
        if (withArrows.length == 0 || withArrows[0]) {
            Incidence first;
            boolean down = false;
            boolean up = false;
            if (this.contains(g, m)) {
                first = Incidence.CROSS;
            } else {
                down = this.DownArrows.contains(g, m);
                up = this.UpArrows.contains(g, m);
                first = down && up ? Incidence.BOTH_ARROW : (down ? Incidence.DOWN_ARROW : (up ? Incidence.UP_ARROW : Incidence.NO_CROSS));
            }
            Incidence second = null;
            if (withArrows.length == 0 || withArrows.length > 1 && withArrows[1]) {
                boolean Down = this.DownPaths.contains(g, m);
                boolean Up = this.UpPaths.contains(g, m);
                if (up || down) {
                    second = null;
                } else if (Down && Up) {
                    second = Incidence.BOTH_PATH;
                } else if (Down) {
                    second = Incidence.DOWN_PATH;
                } else if (Up) {
                    second = Incidence.UP_PATH;
                }
            }
            return Pair.of(first, second);
        }
        if (this.contains(g, m)) {
            return Pair.of(Incidence.CROSS, null);
        }
        return Pair.of(Incidence.NO_CROSS, null);
    }

    public final Iterable<Concept<G, M>> concepts() {
        return new NextConcept(this);
    }

    @Override
    public final Relation<G, G> objectQuasiOrder() {
        return new AbstractRelation<G, G>(this.rowHeads(), this.rowHeads(), true){

            @Override
            public final boolean contains(Object object1, Object object2) {
                return !MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{this.rowHeads().indexOf(object1)}).ge(Calculation.Ret.LINK, MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{this.rowHeads().indexOf(object2)})).containsBoolean(false);
            }
        };
    }

    @Override
    public final Relation<M, M> attributeQuasiOrder() {
        return new AbstractRelation<M, M>(this.colHeads(), this.colHeads(), true){

            @Override
            public final boolean contains(Object attribute1, Object attribute2) {
                return !MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{this.colHeads().indexOf(attribute1)}).ge(Calculation.Ret.LINK, MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{this.colHeads().indexOf(attribute2)})).containsBoolean(false);
            }
        };
    }

    public final Relation<Integer, Integer> _objectEquivalence() {
        return new AbstractRelation<Integer, Integer>(SetLists.integers(this.rowHeads().size()), SetLists.integers(this.rowHeads().size()), true){

            @Override
            public final boolean contains(Object i1, Object i2) {
                return MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{((Integer)i1).intValue()}).equals(MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{((Integer)i2).intValue()}));
            }

            @Override
            public final Set<Integer> col(Object i1) {
                Matrix row = MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{((Integer)i1).intValue()});
                return ((Stream)Stream.iterate(0, Math::incrementExact).limit(MatrixContext.this.rowHeads.size()).parallel()).filter(i2 -> row.equals(MatrixContext.this.matrix.selectRows(Calculation.Ret.LINK, new long[]{i2.intValue()}))).collect(Collectors.toSet());
            }

            @Override
            public final Set<Integer> row(Object i2) {
                return this.col(i2);
            }
        };
    }

    public final Relation<Integer, Integer> _attributeEquivalence() {
        return new AbstractRelation<Integer, Integer>(SetLists.integers(this.colHeads().size()), SetLists.integers(this.colHeads().size()), true){

            @Override
            public final boolean contains(Object j1, Object j2) {
                return MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{((Integer)j1).intValue()}).equals(MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{((Integer)j2).intValue()}));
            }

            @Override
            public final Set<Integer> col(Object j1) {
                Matrix col = MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{((Integer)j1).intValue()});
                return ((Stream)Stream.iterate(0, Math::incrementExact).limit(MatrixContext.this.colHeads.size()).parallel()).filter(j2 -> col.equals(MatrixContext.this.matrix.selectColumns(Calculation.Ret.LINK, new long[]{j2.intValue()}))).collect(Collectors.toSet());
            }

            @Override
            public final Set<Integer> row(Object i2) {
                return this.col(i2);
            }
        };
    }

    public final Set<M> infimumIrreducibles() {
        return new HashSet<M>(SetLists.transform(this._irreducibleAttributes, this._firstAttribute));
    }

    public final Set<G> supremumIrreducibles() {
        return new HashSet<G>(SetLists.transform(this._irreducibleObjects, this._firstObject));
    }

    @Override
    public final Set<G> extent(Object ... objects) {
        return this.extent(Arrays.asList(objects));
    }

    @Override
    public final Set<M> intent(Object ... attributes) {
        return this.intent(Arrays.asList(attributes));
    }

    @Override
    public final Set<G> extent(Collection<?> objects) {
        return Collections3.fromIterator(() -> this.rowHeads.getAll(this._extent(this.rowHeads.indicesOf(objects, true)), true).iterator());
    }

    @Override
    public final Set<M> intent(Collection<?> attributes) {
        return Collections3.fromIterator(() -> this.colHeads.getAll(this._intent(this.colHeads.indicesOf(attributes, true)), true).iterator());
    }

    public final Collection<Integer> _extent(int ... rowIndices) {
        return this._extent(Ints.asList((int[])rowIndices));
    }

    public final Collection<Integer> _intent(int ... columnIndices) {
        return this._intent(Ints.asList((int[])columnIndices));
    }

    public final Collection<Integer> _extent(Iterable<Integer> rowIndices) {
        return this._colAnd(this._rowAnd(rowIndices));
    }

    public final Collection<Integer> _intent(Iterable<Integer> columnIndices) {
        return this._rowAnd(this._colAnd(columnIndices));
    }

    public final Collection<Integer> _extent(Collection<Integer> rowIndices, Collection<Integer> subRowIndices, Collection<Integer> subColumnIndices) {
        return this._colAnd(this._rowAnd(rowIndices, subColumnIndices), subRowIndices);
    }

    public final Collection<Integer> _intent(Collection<Integer> columnIndices, Collection<Integer> subRowIndices, Collection<Integer> subColumnIndices) {
        return this._rowAnd(this._colAnd(columnIndices, subRowIndices), subColumnIndices);
    }

    public final Concept<G, M> topConcept() {
        HashSet extent = new HashSet(this.rowHeads());
        return new Concept(extent, this.rowAnd(extent));
    }

    public final Concept<G, M> bottomConcept() {
        HashSet intent = new HashSet(this.colHeads());
        return new Concept(this.colAnd(intent), intent);
    }

    public final Concept<G, M> objectConcept(G g) {
        HashSet intent = new HashSet(this.row(g));
        return new Concept(this.colAnd(intent), intent);
    }

    public final Concept<G, M> attributeConcept(M m) {
        HashSet extent = new HashSet(this.col(m));
        return new Concept(extent, this.rowAnd(extent));
    }

    public final SetList<G> objectLabels(Set<G> extent, final Set<M> intent) {
        return SetLists.filter(SetLists.intersection(this.rowHeads(), extent), new Predicate<G>(){

            public final boolean apply(G object) {
                return MatrixContext.this.row(object).equals(intent);
            }
        });
    }

    public final SetList<M> attributeLabels(final Set<G> extent, Set<M> intent) {
        return SetLists.filter(SetLists.intersection(this.colHeads(), intent), new Predicate<M>(){

            public final boolean apply(M attribute) {
                return MatrixContext.this.col(attribute).equals(extent);
            }
        });
    }

    public final void selectAttribute(M attribute) {
        this.ignoredAttributes.remove(attribute);
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void deselectAttribute(M attribute) {
        this.ignoredAttributes.add(attribute);
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void selectAllAttributes() {
        this.ignoredAttributes.clear();
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void deselectAllAttributes() {
        this.ignoredAttributes.addAll(this.colHeads());
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final Set<M> selectedAttributes() {
        return Sets.difference((Set)this.colHeads, this.ignoredAttributes);
    }

    public final void selectObject(G object) {
        this.ignoredObjects.remove(object);
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void deselectObject(G object) {
        this.ignoredObjects.add(object);
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void selectAllObjects() {
        this.ignoredObjects.clear();
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final void deselectAllObjects() {
        this.ignoredObjects.addAll(this.rowHeads());
        this.select();
        this.push(new RelationEvent(RelationEvent.SELECTION_CHANGED));
    }

    public final Set<G> selectedObjects() {
        return Sets.difference((Set)this.rowHeads, this.ignoredObjects);
    }

    @Override
    public final MatrixContext<G, M> getSelection() {
        return this.selection;
    }

    @Override
    public final Context<G, M> subRelation(Collection<?> objects, Collection<?> attributes) {
        return new AbstractContext<G, M>(SetLists.intersection(this.rowHeads, objects), SetLists.intersection(this.colHeads, attributes), false){

            @Override
            public final boolean contains(Object object, Object attribute) {
                return this.rowHeads().contains(object) && this.colHeads().contains(attribute) && MatrixContext.this.contains(object, attribute);
            }

            @Override
            public final MatrixContext<G, M> clone() {
                return new MatrixContext(this.rowHeads(), this.colHeads(), (BooleanMatrix)MatrixContext.this.matrix.selectRows(Calculation.Ret.NEW, MatrixContext.this.rowHeads().indicesOf(this.rowHeads(), false)).selectColumns(Calculation.Ret.NEW, MatrixContext.this.colHeads().indicesOf(this.colHeads(), false)), false);
            }
        };
    }

    public final Context<M, G> dual() {
        return new AbstractContext<M, G>(this.colHeads(), this.rowHeads(), false){

            @Override
            public final boolean contains(Object attribute, Object object) {
                return !MatrixContext.this.contains(object, attribute);
            }

            @Override
            public final MatrixContext<M, G> clone() {
                return new MatrixContext(MatrixContext.this.colHeads().clone(), MatrixContext.this.rowHeads().clone(), BooleanMatrices.dual(MatrixContext.this.matrix), false);
            }
        };
    }

    public final Context<G, M> complement() {
        return new AbstractContext<G, M>(this.rowHeads(), this.colHeads(), false){

            @Override
            public final boolean contains(Object object, Object attribute) {
                return !MatrixContext.this.contains(object, attribute);
            }

            @Override
            public final MatrixContext<G, M> clone() {
                return new MatrixContext(MatrixContext.this.rowHeads().clone(), MatrixContext.this.colHeads().clone(), BooleanMatrices.complement(MatrixContext.this.matrix), false);
            }
        };
    }

    public final Context<M, G> contrary() {
        return new AbstractContext<M, G>(this.colHeads(), this.rowHeads(), false){

            @Override
            public final boolean contains(Object attribute, Object object) {
                return !MatrixContext.this.contains(object, attribute);
            }

            @Override
            public final MatrixContext<M, G> clone() {
                return new MatrixContext(MatrixContext.this.colHeads().clone(), MatrixContext.this.rowHeads().clone(), BooleanMatrices.complement(BooleanMatrices.dual(MatrixContext.this.matrix)), false);
            }
        };
    }

    public final Relation<Pair<G, M>, Pair<G, M>> ferrersGraph() {
        SetList vertices = SetLists.cartesianProduct(this.rowHeads(), this.colHeads()).filter(new Predicate<Pair<G, M>>(){

            public final boolean apply(Pair<G, M> p) {
                return !MatrixContext.this.contains(p.x(), p.y());
            }
        });
        return new AbstractRelation<Pair<G, M>, Pair<G, M>>(vertices, vertices, false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                return MatrixContext.this.contains(((Pair)o1).x(), ((Pair)o2).y()) && MatrixContext.this.contains(((Pair)o2).x(), ((Pair)o1).y());
            }
        };
    }

    @Override
    public MatrixContext<G, M> clone() {
        return new MatrixContext(this.rowHeads(), this.colHeads(), BooleanMatrices.clone(this.matrix), this.homogen);
    }

    @Override
    public String toString() {
        if (this.id.get() == null) {
            return super.toString();
        }
        return (String)this.id.get();
    }

    public Set<M> getEquivalenceClass(M m) {
        return new HashSet<M>(this.attributeQuasiOrder().col(m));
    }

    public boolean isIrreducible(M m) {
        int j = this.colHeads.indexOf(m);
        return this.infimumIrreducibles().contains(m) || this._irreducibleAttributes.parallelStream().anyMatch(s -> s.parallelStream().anyMatch(i -> i.equals(j)));
    }

    public static enum AutomaticMode {
        NONE,
        CLEAN,
        REDUCE;


        public static final AutomaticMode fromSize(int objs, int atts) {
            if (objs > 1000 || atts > 1000) {
                return NONE;
            }
            if (objs * atts > 10000) {
                return CLEAN;
            }
            return REDUCE;
        }
    }

    public static enum Incidence {
        CROSS("\u2715"),
        DOWN_ARROW("\u2199"),
        UP_ARROW("\u2197"),
        BOTH_ARROW("\u21c6"),
        DOWN_PATH("\u21c7"),
        UP_PATH("\u21c9"),
        BOTH_PATH("\u21ba"),
        NO_CROSS("\u00b7");

        private final String character;

        private Incidence(String character) {
            this.character = character;
        }

        public final String toString() {
            return this.character;
        }
    }
}

