/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.AbstractContext;
import java.util.HashSet;
import java.util.Set;

public class SparseContext<G, M>
extends AbstractContext<G, M> {
    private final Set<Pair<G, M>> incidences = new HashSet<Pair<G, M>>();

    public SparseContext(SetList<G> objects, SetList<M> attributes, boolean homogen) {
        super(objects, attributes, homogen);
    }

    @Override
    public boolean contains(Object o1, Object o2) {
        return this.incidences.contains(new Pair<Object, Object>(o1, o2));
    }

    @Override
    public boolean add(G row, M col) {
        return this.incidences.add(Pair.of(row, col));
    }

    @Override
    public boolean addFast(Object o1, Object o2) {
        return this.incidences.add(Pair.of(o1, o2));
    }

    public final SparseContext<Set<G>, M> cleanDomain() {
        HashSetArrayList eqClasses = new HashSetArrayList(this.objectQuasiOrder().equivalenceClasses());
        SparseContext cleanedContext = new SparseContext(eqClasses, this.colHeads(), false);
        for (Set g : cleanedContext.rowHeads()) {
            for (Object m : cleanedContext.colHeads()) {
                if (!this.contains(g.iterator().next(), m)) continue;
                cleanedContext.add((G)g, (M)m);
            }
        }
        return cleanedContext;
    }
}

