/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context.temporal;

public final class LTL<M> {
    private final Type type;
    private final M m;
    private final M n;

    public LTL(Type type, M m) {
        this(type, m, null);
    }

    public LTL(Type type, M m, M n) {
        if (m == null) {
            throw new NullPointerException("temporalized attribute m cannot be null.");
        }
        this.type = type;
        this.m = m;
        this.n = n;
    }

    public final Type getType() {
        return this.type;
    }

    public final M getM() {
        return this.m;
    }

    public final M getN() {
        return this.n;
    }

    public String toString() {
        switch (this.type) {
            case UNTILS: 
            case UNTILW: {
                return this.m + " " + this.type.symbol + " " + this.n;
            }
            case NOW: {
                return this.m.toString();
            }
        }
        return this.type.symbol + " " + this.m + "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LTL)) {
            return false;
        }
        LTL other = (LTL)obj;
        return other.type.equals((Object)this.type) && other.m.equals(this.m) && (other.n == null && this.n == null || other.n.equals(this.n));
    }

    public final int hashCode() {
        return this.type.hashCode() + 7 * this.m.hashCode() + 13 * (this.n == null ? 0 : this.n.hashCode());
    }

    public static enum Type {
        NOW(""),
        NEXTW("o"),
        NEXTS("o"),
        SOMETIMES("<>"),
        ALWAYS("[]"),
        UNTILW("U"),
        UNTILS("U");

        private final String symbol;

        private Type(String symbol) {
            this.symbol = symbol;
        }

        public final String getSymbol() {
            return this.symbol;
        }
    }
}

