/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import conexp.fx.core.algorithm.nextclosures.NextClosures2;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.SparseContext;
import conexp.fx.core.dl.Constructor;
import conexp.fx.core.dl.Interpretation;
import conexp.fx.core.dl.Signature;
import conexp.fx.core.math.ClosureOperator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;

public abstract class AInterpretation<C, G, T>
implements Interpretation<IRI, C, G, T> {
    protected final Set<IRI> domain;
    protected final Signature signature;
    protected final Multimap<IRI, IRI> conceptNameExtensions;
    protected final Multimap<IRI, Pair<IRI, IRI>> roleNameExtensions;
    private final Map<C, Set<IRI>> cache = new ConcurrentHashMap<C, Set<IRI>>();
    protected final Multimap<IRI, IRI> conceptNamesPerIndividual = HashMultimap.create();
    protected final Multimap<IRI, Pair<IRI, IRI>> roleSuccessors = HashMultimap.create();

    public AInterpretation(IRI baseIRI) {
        this(new Signature(baseIRI), new HashSet<IRI>());
    }

    public AInterpretation(Signature signature) {
        this(signature, signature.getIndividualNames());
    }

    public AInterpretation(Signature signature, Set<IRI> domain) {
        this.domain = domain;
        this.signature = signature;
        this.conceptNameExtensions = HashMultimap.create();
        this.roleNameExtensions = HashMultimap.create();
    }

    @Override
    public Set<IRI> getDomain() {
        return this.domain;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean addConceptNameAssertion(IRI conceptName, IRI individual) {
        return this.conceptNameExtensions.put((Object)conceptName, (Object)individual);
    }

    @Override
    public boolean addConceptNameAssertion(String conceptName, String individual) {
        return this.addConceptNameAssertion(IRI.create((String)conceptName), IRI.create((String)individual));
    }

    @Override
    public boolean addRoleNameAssertion(IRI roleName, IRI individual1, IRI individual2) {
        return this.roleNameExtensions.put((Object)roleName, new Pair<IRI, IRI>(individual1, individual2));
    }

    @Override
    public boolean addRoleNameAssertion(String roleName, String individual1, String individual2) {
        return this.addRoleNameAssertion(IRI.create((String)roleName), IRI.create((String)individual1), IRI.create((String)individual2));
    }

    @Override
    public Collection<IRI> getConceptNameExtension(IRI conceptName) {
        return this.conceptNameExtensions.get((Object)conceptName);
    }

    @Override
    public Collection<Pair<IRI, IRI>> getRoleNameExtension(IRI roleName) {
        return this.roleNameExtensions.get((Object)roleName);
    }

    @Override
    public Set<IRI> getRoleSuccessors(IRI roleName, IRI individual) {
        return this.getRoleSuccessorStream(roleName, individual).collect(Collectors.toSet());
    }

    @Override
    public Set<IRI> getRolePredecessors(IRI roleName, IRI individual) {
        return this.getRolePredecessorStream(roleName, individual).collect(Collectors.toSet());
    }

    @Override
    public Set<IRI> getConceptExpressionExtension(C conceptExpression) {
        if (this.cache.containsKey(conceptExpression)) {
            return this.cache.get(conceptExpression);
        }
        Set<IRI> extent = this.getDomain().parallelStream().filter(individual -> this.isInstanceOf(individual, conceptExpression)).collect(Collectors.toSet());
        this.cache.put(conceptExpression, extent);
        return extent;
    }

    @Override
    public boolean subsumes(C subsumer, C subsumee) {
        return this.getConceptExpressionExtension(subsumer).containsAll(this.getConceptExpressionExtension(subsumee));
    }

    @Override
    public boolean isSubsumedBy(C subsumee, C subsumer) {
        return this.getConceptExpressionExtension(subsumer).containsAll(this.getConceptExpressionExtension(subsumee));
    }

    @Override
    public Set<C> getAllMostSpecificConcepts(int roleDepth, int maxCardinality, Constructor ... constructors) {
        Set<Set<IRI>> extents = NextClosures2.compute(this.domain, this.getClosureOperator(roleDepth, maxCardinality, constructors), true, new ThreadPoolExecutor(24, 24, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
        System.out.println(extents.size() + " mmscs");
        return extents.parallelStream().filter(ex -> !ex.isEmpty()).map(extent -> this.getMostSpecificConcept(extent, roleDepth, maxCardinality, constructors)).collect(Collectors.toSet());
    }

    protected abstract SetList<C> getAttributeSetForInducedContext(int var1, int var2, Constructor ... var3);

    @Override
    public Context<IRI, C> getInducedContext(Collection<IRI> individuals, int roleDepth, int maxCardinality, Constructor ... constructors) {
        this.checkRoleDepth(roleDepth);
        HashSetArrayList<IRI> _domain = new HashSetArrayList<IRI>(this.domain);
        SetList<C> _codomain = this.getAttributeSetForInducedContext(roleDepth, maxCardinality, constructors);
        SparseContext inducedContext = new SparseContext((SetList<IRI>)_domain, _codomain, false);
        for (Object mmsc : _codomain) {
            for (IRI individual : this.getConceptExpressionExtension(mmsc)) {
                inducedContext.add(individual, mmsc);
            }
        }
        return inducedContext;
    }

    protected abstract Set<Implication<IRI, C>> getBackgroundImplications(Context<IRI, C> var1, T var2);

    @Override
    public final ClosureOperator<IRI> getClosureOperator(int roleDepth, int maxCardinality, Constructor ... constructors) {
        return set -> this.getConceptExpressionExtension(this.getMostSpecificConcept(set, roleDepth, maxCardinality, constructors));
    }

    public Multimap<IRI, IRI> getConceptNameExtensions() {
        return this.conceptNameExtensions;
    }

    public Multimap<IRI, Pair<IRI, IRI>> getRoleNameExtensions() {
        return this.roleNameExtensions;
    }

    protected Stream<IRI> getRoleSuccessorStream(IRI roleName, IRI individual) {
        return this.getRoleNameExtension(roleName).parallelStream().filter(p -> ((IRI)p.x()).equals((Object)individual)).map(p -> (IRI)p.y());
    }

    protected Stream<IRI> getRolePredecessorStream(IRI roleName, IRI individual) {
        return this.getRoleNameExtension(roleName).parallelStream().filter(p -> ((IRI)p.y()).equals((Object)individual)).map(p -> (IRI)p.x());
    }

    public final void updateSuccessorSets() {
        this.conceptNamesPerIndividual.clear();
        this.roleSuccessors.clear();
        for (Map.Entry entry : this.conceptNameExtensions.entries()) {
            this.conceptNamesPerIndividual.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : this.roleNameExtensions.entries()) {
            this.roleSuccessors.put(((Pair)entry.getValue()).x(), Pair.of(entry.getKey(), ((Pair)entry.getValue()).y()));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interpretation)) {
            return false;
        }
        Interpretation other = (Interpretation)obj;
        return this.getDomain().equals(other.getDomain()) && this.getSignature().equals(other.getSignature()) && this.getSignature().getConceptNames().parallelStream().allMatch(conceptName -> this.getConceptNameExtension((IRI)conceptName).equals(other.getConceptNameExtension(conceptName))) && this.getSignature().getRoleNames().parallelStream().allMatch(roleName -> this.getRoleNameExtension((IRI)roleName).equals(other.getRoleNameExtension(roleName)));
    }

    public int hashCode() {
        return 7 + 11 * this.getDomain().hashCode() + 13 * this.getSignature().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Interpretation\r\n");
        sb.append("with domain:\r\n" + this.getDomain().toString() + "\r\n");
        sb.append("on signature:\r\n" + this.getSignature().toString() + "\r\n");
        sb.append("with primitive extensions:\r\n");
        for (IRI conceptName : this.signature.getConceptNames()) {
            sb.append(conceptName + " :: " + this.getConceptNameExtension(conceptName).toString() + "\r\n");
        }
        for (IRI roleName : this.signature.getRoleNames()) {
            sb.append(roleName + " :: " + this.getRoleNameExtension(roleName).toString() + "\r\n");
        }
        return sb.toString();
    }
}

