/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.dl.ELLeastCommonSubsumer;
import conexp.fx.core.dl.ELReasoner;
import conexp.fx.core.dl.ELSyntaxException;
import conexp.fx.core.dl.Signature;
import conexp.fx.core.math.PartialComparable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;

public final class ELConceptDescription
implements PartialComparable<ELConceptDescription>,
Cloneable {
    private static final OWLDataFactory df = OWLManager.getOWLDataFactory();
    private final Set<IRI> conceptNames;
    private final Multimap<IRI, ELConceptDescription> existentialRestrictions;

    public static final ELConceptDescription of(OWLClassExpression concept) {
        return new ELConceptDescription(concept);
    }

    public static final ELConceptDescription bot() {
        return new ELConceptDescription(Sets.newHashSet((Object[])new IRI[]{df.getOWLNothing().getIRI()}), (Multimap<IRI, ELConceptDescription>)HashMultimap.create());
    }

    public static final ELConceptDescription top() {
        return new ELConceptDescription();
    }

    public static final ELConceptDescription conceptName(IRI conceptName) {
        return new ELConceptDescription(Sets.newHashSet((Object[])new IRI[]{conceptName}), (Multimap<IRI, ELConceptDescription>)HashMultimap.create());
    }

    public static final ELConceptDescription existentialRestriction(IRI roleName, ELConceptDescription filler) {
        ELConceptDescription C = new ELConceptDescription();
        C.getExistentialRestrictions().put((Object)roleName, (Object)filler);
        return C;
    }

    public static final ELConceptDescription conjunction(ELConceptDescription ... conjuncts) {
        return ELConceptDescription.conjunction(Arrays.asList(conjuncts));
    }

    public static final ELConceptDescription conjunction(Collection<ELConceptDescription> conjuncts) {
        ELConceptDescription conjunction = new ELConceptDescription();
        conjuncts.forEach(conjunct -> {
            conjunction.getConceptNames().addAll(conjunct.getConceptNames());
            conjunction.getExistentialRestrictions().putAll(conjunct.getExistentialRestrictions());
        });
        return conjunction;
    }

    public static final BiPredicate<ELConceptDescription, ELConceptDescription> quasiOrder() {
        return (x, y) -> x.isSubsumedBy((ELConceptDescription)y);
    }

    public static final BiPredicate<ELConceptDescription, ELConceptDescription> dualQuasiOrder() {
        return (x, y) -> x.subsumes((ELConceptDescription)y);
    }

    public static final BiPredicate<ELConceptDescription, ELConceptDescription> equivalence() {
        return (x, y) -> x.isEquivalentTo((ELConceptDescription)y);
    }

    public static final BiPredicate<ELConceptDescription, ELConceptDescription> neighborhood() {
        return (x, y) -> x.isLowerNeighborOf((ELConceptDescription)y);
    }

    public static final BiPredicate<ELConceptDescription, ELConceptDescription> dualNeighborhood() {
        return (x, y) -> x.isUpperNeighborOf((ELConceptDescription)y);
    }

    public static final BiFunction<ELConceptDescription, ELConceptDescription, Integer> distance() {
        return (x, y) -> x.distanceTo((ELConceptDescription)y);
    }

    public ELConceptDescription(OWLClassExpression concept) {
        this.conceptNames = new HashSet<IRI>();
        this.existentialRestrictions = HashMultimap.create();
        if (concept.isOWLThing()) {
            return;
        }
        if (concept.isOWLNothing()) {
            this.conceptNames.add(df.getOWLNothing().getIRI());
            return;
        }
        if (concept instanceof OWLClass) {
            this.conceptNames.add(((OWLClass)concept).getIRI());
            return;
        }
        if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom existentialRestriction = (OWLObjectSomeValuesFrom)concept;
            this.existentialRestrictions.put((Object)((OWLObjectProperty)existentialRestriction.getProperty()).getIRI(), (Object)new ELConceptDescription((OWLClassExpression)existentialRestriction.getFiller()));
            return;
        }
        if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf conjunction = (OWLObjectIntersectionOf)concept;
            for (OWLClassExpression conjunct : conjunction.asConjunctSet()) {
                if (conjunct instanceof OWLClass) {
                    this.conceptNames.add(((OWLClass)conjunct).getIRI());
                    continue;
                }
                if (conjunct instanceof OWLObjectSomeValuesFrom) {
                    this.existentialRestrictions.put((Object)((OWLObjectProperty)((OWLObjectSomeValuesFrom)conjunct).getProperty()).getIRI(), (Object)new ELConceptDescription((OWLClassExpression)((OWLObjectSomeValuesFrom)conjunct).getFiller()));
                    continue;
                }
                throw new ELSyntaxException();
            }
            return;
        }
        throw new ELSyntaxException();
    }

    public ELConceptDescription(Set<IRI> conceptNames, Multimap<IRI, ELConceptDescription> existentialRestrictions) {
        this.conceptNames = conceptNames;
        this.existentialRestrictions = existentialRestrictions;
    }

    public ELConceptDescription() {
        this.conceptNames = Sets.newHashSet();
        this.existentialRestrictions = HashMultimap.create();
    }

    public final boolean isBot() {
        return this.conceptNames.contains(df.getOWLNothing().getIRI());
    }

    public final boolean isTop() {
        return this.conceptNames.isEmpty() && this.existentialRestrictions.isEmpty();
    }

    public final Set<IRI> getConceptNames() {
        return this.conceptNames;
    }

    public final Multimap<IRI, ELConceptDescription> getExistentialRestrictions() {
        return this.existentialRestrictions;
    }

    public final OWLClassExpression toOWLClassExpression() {
        if (this.isTop()) {
            return df.getOWLThing();
        }
        if (this.isBot()) {
            return df.getOWLNothing();
        }
        if (this.conceptNames.size() == 1 && this.existentialRestrictions.isEmpty()) {
            return df.getOWLClass(this.conceptNames.iterator().next());
        }
        if (this.conceptNames.isEmpty() && this.existentialRestrictions.size() == 1) {
            Map.Entry existentialRestriction = (Map.Entry)this.existentialRestrictions.entries().iterator().next();
            return df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)df.getOWLObjectProperty((IRI)existentialRestriction.getKey()), ((ELConceptDescription)existentialRestriction.getValue()).toOWLClassExpression());
        }
        HashSet<Object> conjuncts = new HashSet<Object>();
        for (IRI conceptName : this.conceptNames) {
            conjuncts.add(df.getOWLClass(conceptName));
        }
        for (Map.Entry existentialRestriction : this.existentialRestrictions.entries()) {
            conjuncts.add(df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)df.getOWLObjectProperty((IRI)existentialRestriction.getKey()), ((ELConceptDescription)existentialRestriction.getValue()).toOWLClassExpression()));
        }
        return df.getOWLObjectIntersectionOf(conjuncts);
    }

    public final boolean isSubsumedBy(ELConceptDescription other) {
        return ELReasoner.isSubsumedBy(this, other);
    }

    public final boolean subsumes(ELConceptDescription other) {
        return ELReasoner.subsumes(this, other);
    }

    public final boolean isEquivalentTo(ELConceptDescription other) {
        return ((Stream)Stream.of(() -> this.subsumes(other), () -> other.subsumes(this)).parallel()).allMatch(Supplier::get);
    }

    public final boolean isLowerNeighborOf(ELConceptDescription other) {
        return this.upperNeighborsReduced().parallelStream().anyMatch(other::isEquivalentTo);
    }

    public final boolean isUpperNeighborOf(ELConceptDescription other) {
        return other.isLowerNeighborOf(this);
    }

    public final ELConceptDescription reduce() {
        for (Map.Entry er : this.existentialRestrictions.entries()) {
            ((ELConceptDescription)er.getValue()).reduce();
        }
        Function<Map.Entry, Stream> f = er1 -> this.existentialRestrictions.entries().parallelStream().filter(er2 -> ((IRI)er1.getKey()).equals(er2.getKey())).filter(er2 -> !er1.equals(er2)).map(er2 -> Pair.of(er1, er2));
        Set<Map.Entry> superfluousERs = this.existentialRestrictions.entries().parallelStream().map(f).reduce(Stream::concat).orElseGet(Stream::empty).filter(p -> ((ELConceptDescription)((Map.Entry)p.first()).getValue()).isSubsumedBy((ELConceptDescription)((Map.Entry)p.second()).getValue())).map(Pair::second).collect(Collectors.toSet());
        superfluousERs.forEach(x -> this.existentialRestrictions.remove(x.getKey(), x.getValue()));
        return this;
    }

    public final int roleDepth() {
        if (this.existentialRestrictions.isEmpty()) {
            return 0;
        }
        return 1 + this.existentialRestrictions.entries().parallelStream().map(Map.Entry::getValue).map(ELConceptDescription::roleDepth).max(Integer::compare).orElse(0);
    }

    public final int size() {
        return Math.max(1, 2 * this.conceptNames.size() + this.existentialRestrictions.size() - 1 + this.existentialRestrictions.entries().parallelStream().map(Map.Entry::getValue).map(c -> 1 + c.size()).reduce(0, Integer::sum));
    }

    public final int rank() {
        return this.clone().reduce().unreducedRank();
    }

    public final int unreducedRank() {
        if (this.isTop()) {
            return 0;
        }
        return 1 + this.oneUpperNeighbor().unreducedRank();
    }

    private final ELConceptDescription oneUpperNeighbor() {
        if (!this.conceptNames.isEmpty()) {
            ELConceptDescription upperNeighbor = this.clone();
            Iterator<IRI> it = upperNeighbor.conceptNames.iterator();
            it.next();
            it.remove();
            return upperNeighbor;
        }
        if (!this.existentialRestrictions.isEmpty()) {
            ELConceptDescription upperNeighbor = this.clone();
            Iterator it = upperNeighbor.existentialRestrictions.entries().iterator();
            Map.Entry ER = (Map.Entry)it.next();
            it.remove();
            ((Stream)((ELConceptDescription)ER.getValue()).upperNeighborsReduced().parallelStream().filter(uER -> upperNeighbor.existentialRestrictions.entries().parallelStream().filter(otherER -> !otherER.equals(ER)).filter(otherER -> ((IRI)ER.getKey()).equals(otherER.getKey())).map(Map.Entry::getValue).noneMatch(uER::subsumes)).map(uER -> Pair.of(ER.getKey(), uER)).sequential()).forEach(p -> upperNeighbor.existentialRestrictions.put(p.first(), p.second()));
            return upperNeighbor;
        }
        return null;
    }

    public final int rank2() {
        return this.clone().reduce().unreducedRank2();
    }

    public final int unreducedRank2() {
        return this.getConceptNames().size() + this.getExistentialRestrictions().keySet().parallelStream().map(r -> {
            ELConceptDescription rDs = new ELConceptDescription();
            rDs.getExistentialRestrictions().putAll(r, (Iterable)this.getExistentialRestrictions().get(r));
            return rDs;
        }).mapToInt(ELConceptDescription::unreducedRank).sum();
    }

    public final int rank3() {
        Set<ELConceptDescription> Us = this.upperNeighborsReduced();
        if (Us.isEmpty()) {
            return 0;
        }
        if (Us.size() == 1) {
            return 1 + Us.iterator().next().clone().reduce().rank3();
        }
        return Us.size() + ELLeastCommonSubsumer.lcs(Us).clone().reduce().rank3();
    }

    public final int rank4() {
        return this.clone().reduce().unreducedRank4();
    }

    public final int unreducedRank4() {
        return this.getConceptNames().size() + this.getExistentialRestrictions().keySet().parallelStream().map(r -> this.getExistentialRestrictions().get(r)).mapToInt(ELConceptDescription::recurseUnreducedRank4).sum();
    }

    private static final int recurseUnreducedRank4(Collection<ELConceptDescription> Ds) {
        if (Ds.isEmpty()) {
            return 0;
        }
        if (Ds.size() == 1) {
            return 1 + ELConceptDescription.recurseUnreducedRank4(Ds.iterator().next().upperNeighborsReduced());
        }
        return IntStream.range(1, Ds.size() + 1).boxed().map(i -> (int)(Math.pow(-1.0, i + 1) * (double)Sets.combinations((Set)Sets.newHashSet((Iterable)Ds), (int)i).parallelStream().map(ELLeastCommonSubsumer::lcs).map(ELConceptDescription::reduce).collect(Collectors.toSet()).parallelStream().map(Collections::singleton).collect(Collectors.summingInt(ELConceptDescription::recurseUnreducedRank4)).intValue())).collect(Collectors.summingInt(Integer::valueOf));
    }

    public final int distanceTo(ELConceptDescription other) {
        List x = ((Stream)Stream.of(() -> ELConceptDescription.conjunction(this, other).rank(), () -> ELLeastCommonSubsumer.lcs(this, other).rank()).parallel()).map(Supplier::get).collect(Collectors.toList());
        return (Integer)x.get(0) - (Integer)x.get(1);
    }

    public final int distanceTo2(ELConceptDescription other) {
        ELConceptDescription lcs = ELLeastCommonSubsumer.lcs(this, other);
        int distance = -1;
        for (ELConceptDescription C = ELConceptDescription.conjunction(this, other).reduce(); C != null; C = C.oneUpperNeighborBelow(lcs)) {
            ++distance;
        }
        return distance;
    }

    private final ELConceptDescription oneUpperNeighborBelow(ELConceptDescription other) {
        return Stream.concat(this.conceptNames.parallelStream().map(A -> {
            ELConceptDescription upperNeighbor = this.clone();
            upperNeighbor.conceptNames.remove(A);
            return upperNeighbor;
        }), this.existentialRestrictions.entries().parallelStream().map(ER -> {
            ELConceptDescription upperNeighbor = this.clone();
            upperNeighbor.existentialRestrictions.remove(ER.getKey(), ER.getValue());
            ((Stream)((ELConceptDescription)ER.getValue()).upperNeighborsReduced().parallelStream().filter(uER -> upperNeighbor.existentialRestrictions.entries().parallelStream().filter(otherER -> !otherER.equals(ER)).filter(otherER -> ((IRI)ER.getKey()).equals(otherER.getKey())).map(Map.Entry::getValue).noneMatch(uER::subsumes)).map(uER -> Pair.of(ER.getKey(), uER)).sequential()).forEach(p -> upperNeighbor.existentialRestrictions.put(p.first(), p.second()));
            return upperNeighbor;
        })).filter(other::subsumes).findAny().orElse(null);
    }

    public final Set<ELConceptDescription> neighborhood(int radius, Signature sigma) {
        if (radius < 0) {
            throw new IllegalArgumentException();
        }
        HashSet next = Sets.newHashSet((Object[])new ELConceptDescription[]{this});
        HashSet neighborhood = Sets.newHashSet((Object[])new ELConceptDescription[]{this});
        for (int k = 0; k < radius; ++k) {
            Set news = Stream.concat(next.parallelStream().flatMap(C -> C.upperNeighborsReduced().parallelStream()), next.parallelStream().flatMap(C -> C.lowerNeighborsReduced(sigma).parallelStream())).collect(Collectors.toSet());
            next.clear();
            next.addAll(news);
            next.removeAll(neighborhood);
            neighborhood.addAll(news);
        }
        return neighborhood;
    }

    public final Set<ELConceptDescription> upperNeighbors() {
        ELConceptDescription reducedForm = this.clone().reduce();
        return Stream.concat(reducedForm.conceptNames.parallelStream().map(A -> {
            ELConceptDescription upperNeighbor = reducedForm.clone();
            upperNeighbor.conceptNames.remove(A);
            return upperNeighbor;
        }), reducedForm.existentialRestrictions.entries().parallelStream().map(ER -> {
            ELConceptDescription upperNeighbor = reducedForm.clone();
            upperNeighbor.existentialRestrictions.remove(ER.getKey(), ER.getValue());
            ((Stream)((ELConceptDescription)ER.getValue()).upperNeighbors().parallelStream().sequential()).forEach(uER -> upperNeighbor.existentialRestrictions.put(ER.getKey(), uER));
            return upperNeighbor;
        })).collect(Collectors.toSet());
    }

    public final Set<ELConceptDescription> upperNeighborsReduced() {
        ELConceptDescription reducedForm = this.clone().reduce();
        return Collections3.representatives(Stream.concat(reducedForm.conceptNames.parallelStream().map(A -> {
            ELConceptDescription upperNeighbor = reducedForm.clone();
            upperNeighbor.conceptNames.remove(A);
            return upperNeighbor;
        }), reducedForm.existentialRestrictions.entries().parallelStream().map(ER -> {
            ELConceptDescription upperNeighbor = reducedForm.clone();
            upperNeighbor.existentialRestrictions.remove(ER.getKey(), ER.getValue());
            ((Stream)((ELConceptDescription)ER.getValue()).upperNeighborsReduced().parallelStream().filter(uER -> reducedForm.existentialRestrictions.entries().parallelStream().filter(otherER -> !otherER.equals(ER)).filter(otherER -> ((IRI)ER.getKey()).equals(otherER.getKey())).map(Map.Entry::getValue).noneMatch(uER::subsumes)).sequential()).forEach(uER -> upperNeighbor.existentialRestrictions.put(ER.getKey(), uER));
            return upperNeighbor;
        })).collect(Collectors.toSet()), (X, Y) -> X.isEquivalentTo((ELConceptDescription)Y));
    }

    public final Set<ELConceptDescription> lowerNeighbors(Signature sigma) {
        ELConceptDescription C = this.clone().reduce();
        Set lowerNeighbors = Sets.newConcurrentHashSet();
        sigma.getConceptNames().parallelStream().filter(A -> !C.conceptNames.contains(A)).map(A -> {
            ELConceptDescription lowerNeighbor = C.clone();
            lowerNeighbor.conceptNames.add((IRI)A);
            return lowerNeighbor;
        }).forEach(lowerNeighbors::add);
        sigma.getRoleNames().parallelStream().forEach(r -> {
            Set<ELConceptDescription> filter = C.existentialRestrictions.entries().parallelStream().filter(existentialRestriction -> ((IRI)existentialRestriction.getKey()).equals(r)).map(Map.Entry::getValue).collect(Collectors.toSet());
            if (filter.isEmpty()) {
                ELConceptDescription lowerNeighbor = C.clone();
                lowerNeighbor.existentialRestrictions.put(r, (Object)ELConceptDescription.top());
                lowerNeighbors.add(lowerNeighbor);
            } else {
                this.recurseLowerNeighbors(sigma, (IRI)r, C, Collections.singleton(ELConceptDescription.top()), filter, lowerNeighbors);
            }
        });
        return lowerNeighbors;
    }

    private final void recurseLowerNeighbors(Signature sigma, IRI r, ELConceptDescription C, Set<ELConceptDescription> currentCandidates, Set<ELConceptDescription> filter, Set<ELConceptDescription> lowerNeighbors) {
        Set nextCandidates = Sets.newConcurrentHashSet();
        currentCandidates.parallelStream().forEach(D -> {
            if (!D.upperNeighborsReduced().parallelStream().allMatch(U -> C.isSubsumedBy(ELConceptDescription.existentialRestriction(r, U)))) {
                return;
            }
            if (filter.parallelStream().anyMatch(F -> F.isSubsumedBy((ELConceptDescription)D))) {
                D.lowerNeighbors(sigma).parallelStream().forEach(nextCandidates::add);
            } else {
                ELConceptDescription X = C.clone();
                X.existentialRestrictions.put((Object)r, D);
                lowerNeighbors.add(X);
            }
        });
        if (!nextCandidates.isEmpty()) {
            this.recurseLowerNeighbors(sigma, r, C, nextCandidates, filter, lowerNeighbors);
        }
    }

    public final Set<ELConceptDescription> lowerNeighborsReduced(Signature sigma) {
        Set<ELConceptDescription> lowerNeighbors = this.lowerNeighbors(sigma);
        lowerNeighbors.parallelStream().forEach(ELConceptDescription::reduce);
        return lowerNeighbors;
    }

    protected final Set<ELConceptDescription> lowerNeighbors2(Signature sigma) {
        Set lowerNeighbors = Sets.newConcurrentHashSet();
        sigma.getConceptNames().parallelStream().filter(A -> !this.conceptNames.contains(A)).map(A -> {
            ELConceptDescription lowerNeighbor = this.clone();
            lowerNeighbor.conceptNames.add((IRI)A);
            return lowerNeighbor;
        }).forEach(lowerNeighbors::add);
        sigma.getRoleNames().parallelStream().forEach(r -> {
            ELConceptDescription rLCS = ELLeastCommonSubsumer.lcs(this.clone().reduce().existentialRestrictions.entries().parallelStream().filter(sD -> ((IRI)sD.getKey()).equals(r)).map(Map.Entry::getValue).collect(Collectors.toSet()));
            rLCS.reduce();
            this.recurseLowerNeighbors2a(sigma, (IRI)r, rLCS, lowerNeighbors);
            this.recurseLowerNeighbors2b(sigma, (IRI)r, new ELConceptDescription(), rLCS, lowerNeighbors);
        });
        return lowerNeighbors;
    }

    private final void recurseLowerNeighbors2a(Signature sigma, IRI r, ELConceptDescription D, Set<ELConceptDescription> lowerNeighbors) {
        if (this.isSubsumedBy(ELConceptDescription.existentialRestriction(r, D))) {
            D.lowerNeighbors2(sigma).parallelStream().forEach(E -> this.recurseLowerNeighbors2a(sigma, r, (ELConceptDescription)E, lowerNeighbors));
        } else if (D.upperNeighborsReduced().parallelStream().allMatch(E -> this.isSubsumedBy(ELConceptDescription.existentialRestriction(r, E)))) {
            ELConceptDescription lowerNeighbor = this.clone();
            lowerNeighbor.existentialRestrictions.put((Object)r, (Object)D);
            lowerNeighbors.add(lowerNeighbor);
        }
    }

    private final void recurseLowerNeighbors2b(Signature sigma, IRI r, ELConceptDescription D, ELConceptDescription rLCS, Set<ELConceptDescription> lowerNeighbors) {
        if (rLCS.subsumes(D)) {
            return;
        }
        if (this.isSubsumedBy(ELConceptDescription.existentialRestriction(r, D))) {
            D.lowerNeighbors2(sigma).parallelStream().forEach(E -> this.recurseLowerNeighbors2b(sigma, r, (ELConceptDescription)E, rLCS, lowerNeighbors));
        } else if (D.upperNeighborsReduced().parallelStream().allMatch(E -> this.isSubsumedBy(ELConceptDescription.existentialRestriction(r, E)))) {
            ELConceptDescription lowerNeighbor = this.clone();
            lowerNeighbor.existentialRestrictions.put((Object)r, (Object)D);
            lowerNeighbors.add(lowerNeighbor);
        }
    }

    protected final Set<ELConceptDescription> lowerNeighbors3(Signature sigma) {
        ELConceptDescription C = this.clone().reduce();
        Set lowerNeighbors = Sets.newConcurrentHashSet();
        sigma.getConceptNames().parallelStream().filter(A -> !this.conceptNames.contains(A)).map(A -> {
            ELConceptDescription lowerNeighbor = C.clone();
            lowerNeighbor.conceptNames.add((IRI)A);
            return lowerNeighbor;
        }).forEach(lowerNeighbors::add);
        sigma.getRoleNames().parallelStream().forEach(r -> {
            Set Ds = C.existentialRestrictions.entries().parallelStream().filter(sD -> ((IRI)sD.getKey()).equals(r)).map(Map.Entry::getValue).collect(Collectors.toSet());
            if (Ds.isEmpty()) {
                ELConceptDescription X = C.clone();
                X.existentialRestrictions.put(r, (Object)ELConceptDescription.top());
                lowerNeighbors.add(X);
            } else {
                Collections.singleton(Pair.of(Ds, ELConceptDescription.top())).parallelStream().forEach(p -> this.recurseLowerNeighbors3(sigma, (IRI)r, C, (ELConceptDescription)p.second(), (Set)p.first(), lowerNeighbors));
            }
        });
        return lowerNeighbors;
    }

    private final void recurseLowerNeighbors3(Signature sigma, IRI r, ELConceptDescription C, ELConceptDescription D, Set<ELConceptDescription> filter, Set<ELConceptDescription> lowerNeighbors) {
        if (!D.upperNeighborsReduced().parallelStream().allMatch(U -> C.isSubsumedBy(ELConceptDescription.existentialRestriction(r, U)))) {
            return;
        }
        if (filter.parallelStream().anyMatch(F -> F.isSubsumedBy(D))) {
            D.lowerNeighbors3(sigma).parallelStream().forEach(E -> this.recurseLowerNeighbors3(sigma, r, C, (ELConceptDescription)E, filter, lowerNeighbors));
        } else {
            ELConceptDescription X = C.clone();
            X.existentialRestrictions.put((Object)r, (Object)D);
            lowerNeighbors.add(X);
        }
    }

    public final String toString() {
        Map.Entry existentialRestriction;
        Iterator it2;
        if (this.isBot()) {
            return "\u22a5";
        }
        if (this.isTop()) {
            return "\u22a4";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<IRI> it1 = this.conceptNames.iterator();
        if (it1.hasNext()) {
            sb.append(it1.next().toString());
        }
        while (it1.hasNext()) {
            sb.append("\u2293");
            sb.append(it1.next().toString());
        }
        if (!this.conceptNames.isEmpty() && !this.existentialRestrictions.isEmpty()) {
            sb.append("\u2293");
        }
        if ((it2 = this.existentialRestrictions.entries().iterator()).hasNext()) {
            existentialRestriction = (Map.Entry)it2.next();
            sb.append("\u2203");
            sb.append(((IRI)existentialRestriction.getKey()).toString());
            sb.append(".");
            if (((ELConceptDescription)existentialRestriction.getValue()).conceptNames.size() + ((ELConceptDescription)existentialRestriction.getValue()).existentialRestrictions.size() <= 1) {
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toString());
            } else {
                sb.append("(");
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toString());
                sb.append(")");
            }
        }
        while (it2.hasNext()) {
            sb.append("\u2293");
            existentialRestriction = (Map.Entry)it2.next();
            sb.append("\u2203");
            sb.append(((IRI)existentialRestriction.getKey()).toString());
            sb.append(".");
            if (((ELConceptDescription)existentialRestriction.getValue()).conceptNames.size() + ((ELConceptDescription)existentialRestriction.getValue()).existentialRestrictions.size() <= 1) {
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toString());
                continue;
            }
            sb.append("(");
            sb.append(((ELConceptDescription)existentialRestriction.getValue()).toString());
            sb.append(")");
        }
        return sb.toString();
    }

    public final String toLaTeXString() {
        Map.Entry existentialRestriction;
        if (this.isBot()) {
            return "\\bot";
        }
        if (this.isTop()) {
            return "\\top";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<IRI> it1 = this.conceptNames.iterator();
        if (it1.hasNext()) {
            sb.append(it1.next().toString());
        }
        while (it1.hasNext()) {
            sb.append(" \\sqcap ");
            sb.append(it1.next().toString());
        }
        Iterator it2 = this.existentialRestrictions.entries().iterator();
        if (this.conceptNames.isEmpty()) {
            sb.append(" \\sqcap ");
        }
        if (it2.hasNext()) {
            existentialRestriction = (Map.Entry)it2.next();
            sb.append(" \\exists ");
            sb.append(((IRI)existentialRestriction.getKey()).toString());
            sb.append(" . ");
            if (((ELConceptDescription)existentialRestriction.getValue()).conceptNames.size() + ((ELConceptDescription)existentialRestriction.getValue()).existentialRestrictions.size() <= 1) {
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toLaTeXString());
            } else {
                sb.append(" \\left( ");
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toLaTeXString());
                sb.append(" \\right) ");
            }
        }
        while (it2.hasNext()) {
            existentialRestriction = (Map.Entry)it2.next();
            sb.append(" \\sqcap ");
            sb.append(" \\exists ");
            sb.append(((IRI)existentialRestriction.getKey()).toString());
            sb.append(" . ");
            if (((ELConceptDescription)existentialRestriction.getValue()).conceptNames.size() + ((ELConceptDescription)existentialRestriction.getValue()).existentialRestrictions.size() <= 1) {
                sb.append(((ELConceptDescription)existentialRestriction.getValue()).toLaTeXString());
                continue;
            }
            sb.append(" \\left( ");
            sb.append(((ELConceptDescription)existentialRestriction.getValue()).toLaTeXString());
            sb.append(" \\right) ");
        }
        return sb.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ELConceptDescription)) {
            return false;
        }
        ELConceptDescription other = (ELConceptDescription)obj;
        return this.conceptNames.equals(other.conceptNames) && this.existentialRestrictions.equals(other.existentialRestrictions);
    }

    public final int hashCode() {
        return 2 * this.conceptNames.hashCode() + 3 * this.existentialRestrictions.hashCode();
    }

    public final ELConceptDescription clone() {
        ELConceptDescription clone = new ELConceptDescription();
        clone.getConceptNames().addAll(this.getConceptNames());
        ((Stream)this.getExistentialRestrictions().entries().parallelStream().map(ER -> Pair.of(ER.getKey(), ((ELConceptDescription)ER.getValue()).clone())).sequential()).forEach(ER -> clone.getExistentialRestrictions().put(ER.x(), ER.y()));
        return clone;
    }

    @Override
    public final int compareTo(ELConceptDescription other) {
        List x = ((Stream)Stream.of(() -> this.subsumes(other), () -> other.subsumes(this)).parallel()).map(Supplier::get).collect(Collectors.toList());
        if (((Boolean)x.get(0)).booleanValue() && ((Boolean)x.get(1)).booleanValue()) {
            return 0;
        }
        if (((Boolean)x.get(0)).booleanValue()) {
            return 1;
        }
        if (((Boolean)x.get(1)).booleanValue()) {
            return -1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean smaller(ELConceptDescription other) {
        return ((Stream)Stream.of(() -> !this.subsumes(other), () -> other.subsumes(this)).parallel()).allMatch(Supplier::get);
    }

    @Override
    public final boolean greater(ELConceptDescription other) {
        return ((Stream)Stream.of(() -> this.subsumes(other), () -> !other.subsumes(this)).parallel()).allMatch(Supplier::get);
    }

    @Override
    public final boolean smallerEq(ELConceptDescription other) {
        return this.isSubsumedBy(other);
    }

    @Override
    public final boolean greaterEq(ELConceptDescription other) {
        return this.subsumes(other);
    }

    @Override
    public final boolean uncomparable(ELConceptDescription other) {
        return ((Stream)Stream.of(() -> !this.subsumes(other), () -> !other.subsumes(this)).parallel()).allMatch(Supplier::get);
    }
}

