/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import conexp.fx.core.algorithm.nextclosures.NextClosures1C;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.dl.AInterpretation;
import conexp.fx.core.dl.Constructor;
import conexp.fx.core.dl.ELConceptDescription;
import conexp.fx.core.dl.ELConceptInclusion;
import conexp.fx.core.dl.ELLeastCommonSubsumer;
import conexp.fx.core.dl.ELReasoner;
import conexp.fx.core.dl.ELTBox;
import conexp.fx.core.dl.Signature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;

public final class ELInterpretation
extends AInterpretation<ELConceptDescription, ELConceptInclusion, ELTBox> {
    public ELInterpretation(IRI baseIRI) {
        super(baseIRI);
    }

    public ELInterpretation(Signature signature) {
        super(signature);
    }

    public ELInterpretation(Signature signature, Set<IRI> domain) {
        super(signature, domain);
    }

    @Override
    public final boolean isInstanceOf(IRI individual, ELConceptDescription conceptExpression) {
        if (conceptExpression.isBot()) {
            return false;
        }
        if (conceptExpression.isTop()) {
            return true;
        }
        return conceptExpression.getConceptNames().parallelStream().allMatch(conceptName -> this.conceptNameExtensions.get(conceptName).contains(individual)) && conceptExpression.getExistentialRestrictions().entries().parallelStream().allMatch(existentialRestriction -> this.getRoleSuccessorStream((IRI)existentialRestriction.getKey(), individual).anyMatch(successor -> this.isInstanceOf((IRI)successor, (ELConceptDescription)existentialRestriction.getValue())));
    }

    @Override
    public final boolean satisfies(ELConceptInclusion gci) {
        return this.isSubsumedBy(gci.getSubsumee(), gci.getSubsumer());
    }

    @Override
    public final boolean models(ELTBox tBox) {
        return tBox.getGCIs().parallelStream().allMatch(this::satisfies);
    }

    @Override
    public ELConceptDescription getMostSpecificConcept(IRI individual, int roleDepth, int maxCardinality, Constructor ... constructors) {
        this.checkRoleDepth(roleDepth);
        HashSet conceptNames = new HashSet(this.conceptNamesPerIndividual.get((Object)individual));
        Set<Object> existentialRestrictions = roleDepth > 0 ? this.roleSuccessors.get((Object)individual).parallelStream().map(p -> new Pair(p.x(), this.getMostSpecificConcept((IRI)p.y(), 0, roleDepth - 1, new Constructor[0]))).collect(Collectors.toSet()) : new HashSet();
        ELConceptDescription msc = new ELConceptDescription();
        msc.getConceptNames().addAll(conceptNames);
        for (Pair pair : existentialRestrictions) {
            msc.getExistentialRestrictions().put(pair.x(), pair.y());
        }
        msc.reduce();
        return msc;
    }

    @Override
    public final ELConceptDescription getMostSpecificConcept(Set<IRI> individuals, int roleDepth, int maxCardinality, Constructor ... constructors) {
        this.checkRoleDepth(roleDepth);
        return ELLeastCommonSubsumer.lcs(new HashSet<ELConceptDescription>(Collections2.transform(individuals, individual -> this.getMostSpecificConcept((IRI)individual, 0, roleDepth, new Constructor[0]))));
    }

    @Override
    protected final SetList<ELConceptDescription> getAttributeSetForInducedContext(int roleDepth, int maxCardinality, Constructor ... constructors) {
        Set mmscs = this.getAllMostSpecificConcepts(roleDepth - 1, 0, new Constructor[0]);
        HashSetArrayList<ELConceptDescription> _codomain = new HashSetArrayList<ELConceptDescription>();
        _codomain.add(ELConceptDescription.bot());
        _codomain.addAll(Collections2.transform(this.signature.getConceptNames(), ELConceptDescription::conceptName));
        for (IRI roleName : this.signature.getRoleNames()) {
            _codomain.addAll(Collections2.transform(mmscs, mmsc -> ELConceptDescription.existentialRestriction(roleName, mmsc)));
        }
        return _codomain;
    }

    @Override
    protected final Set<Implication<IRI, ELConceptDescription>> getBackgroundImplications(Context<IRI, ELConceptDescription> inducedContext, ELTBox backgroundTBox) {
        BiPredicate<ELConceptDescription, ELConceptDescription> subsumptionTest = backgroundTBox == null ? (concept1, concept2) -> ELReasoner.isSubsumedBy(concept1, concept2) : (concept1, concept2) -> ELReasoner.isSubsumedBy(concept1, concept2, backgroundTBox);
        HashSet<Implication<IRI, ELConceptDescription>> backgroundImplications = new HashSet<Implication<IRI, ELConceptDescription>>();
        for (ELConceptDescription concept12 : inducedContext.colHeads()) {
            for (ELConceptDescription concept22 : inducedContext.colHeads()) {
                if (concept12.equals(concept22) || !subsumptionTest.test(concept12, concept22)) continue;
                backgroundImplications.add(new Implication(Collections.singleton(concept12), Collections.singleton(concept22), Collections.emptySet()));
            }
        }
        return backgroundImplications;
    }

    @Override
    public final ELTBox computeTBoxBase(int roleDepth, int maxCardinality, ELTBox backgroundTBox, Constructor ... constructors) {
        this.checkRoleDepth(roleDepth);
        ELTBox tbox = new ELTBox();
        Context<IRI, ELConceptDescription> inducedContext = this.getInducedContext(this.domain, roleDepth, maxCardinality, new Constructor[0]);
        Set backgroundImplications = this.getBackgroundImplications(inducedContext, backgroundTBox);
        NextClosures1C.ResultC<IRI, ELConceptDescription> result = NextClosures1C.computeWithBackgroundImplications(inducedContext, backgroundImplications, false);
        for (Map.Entry entry : result.implications.entrySet()) {
            tbox.getGCIs().add(new ELConceptInclusion(ELConceptDescription.conjunction(entry.getKey()).clone().reduce(), ELConceptDescription.conjunction(entry.getValue()).clone().reduce()));
        }
        return tbox;
    }

    public static final ELInterpretation fromTriples(File rdfFile, IRI baseIRI, String isaRole) {
        IRI d;
        ELInterpretation i = new ELInterpretation(baseIRI);
        HashMultimap concepts = HashMultimap.create();
        HashMultimap roles = HashMultimap.create();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(rdfFile));
            Iterator it = reader.lines().iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                while (next.contains("  ")) {
                    next = next.replace("  ", " ");
                }
                String[] triple = (next = next.replace("<", "").replace(">", "")).split(" ");
                if (triple.length <= 2) continue;
                if (triple[1].contains(isaRole)) {
                    concepts.put((Object)triple[0], (Object)triple[2]);
                    continue;
                }
                roles.put((Object)triple[1], new Pair<String, String>(triple[0], triple[2]));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Map.Entry entry : concepts.entries()) {
            IRI c = IRI.create((String)((String)entry.getKey()));
            d = IRI.create((String)((String)entry.getValue()));
            i.getSignature().getConceptNames().add(d);
            i.getDomain().add(c);
            i.addConceptNameAssertion(d, c);
        }
        for (Map.Entry entry : roles.entries()) {
            IRI r = IRI.create((String)((String)entry.getKey()));
            d = IRI.create((String)((String)((Pair)entry.getValue()).x()));
            IRI e = IRI.create((String)((String)((Pair)entry.getValue()).y()));
            i.getSignature().getRoleNames().add(r);
            i.getDomain().add(d);
            i.getDomain().add(e);
            i.addRoleNameAssertion(r, d, e);
        }
        return i;
    }

    public static final ELInterpretation fromTriples(List<IRI[]> triples, IRI baseIRI, IRI isaRole) {
        ELInterpretation i = new ELInterpretation(baseIRI);
        for (IRI[] triple : triples) {
            if (triple[1].equals((Object)isaRole)) {
                i.getSignature().getConceptNames().add(triple[2]);
                i.getDomain().add(triple[0]);
                i.addConceptNameAssertion(triple[2], triple[0]);
                continue;
            }
            i.getSignature().getRoleNames().add(triple[1]);
            i.getDomain().add(triple[0]);
            i.getDomain().add(triple[2]);
            i.addRoleNameAssertion(triple[1], triple[0], triple[2]);
        }
        return i;
    }
}

