/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.Sets;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.dl.ELConceptDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class ELLeastCommonSubsumer {
    private static final OWLDataFactory df = OWLManager.getOWLDataFactory();

    public static final ELConceptDescription lcs(ELConceptDescription C, ELConceptDescription D) {
        return ELLeastCommonSubsumer.lcs(Sets.newHashSet((Object[])new ELConceptDescription[]{C, D}));
    }

    public static final ELConceptDescription lcs(Set<ELConceptDescription> Cs) {
        Cs.parallelStream().forEach(ELConceptDescription::reduce);
        Set<ELConceptDescription> Ds = Collections3.representatives(Cs, (X, Y) -> X.isEquivalentTo((ELConceptDescription)Y));
        if (Ds.isEmpty()) {
            return ELConceptDescription.bot();
        }
        if (Ds.size() == 1) {
            return Ds.iterator().next().clone();
        }
        ELConceptDescription lcs = new ELConceptDescription();
        Iterator<ELConceptDescription> it = Ds.iterator();
        ELConceptDescription D = it.next();
        it.remove();
        Set commonConceptNames = D.getConceptNames().parallelStream().filter(A -> Ds.parallelStream().map(ELConceptDescription::getConceptNames).allMatch(As -> As.contains(A))).collect(Collectors.toSet());
        lcs.getConceptNames().addAll(commonConceptNames);
        Set commonRoleNames = D.getExistentialRestrictions().keySet().parallelStream().filter(r -> Ds.parallelStream().map(ELConceptDescription::getExistentialRestrictions).allMatch(ERs -> ERs.keySet().parallelStream().anyMatch(arg_0 -> ((IRI)r).equals(arg_0)))).collect(Collectors.toSet());
        Ds.add(D);
        ((Stream)commonRoleNames.parallelStream().map(r -> Pair.of(r, Sets.cartesianProduct(Ds.parallelStream().map(ELConceptDescription::getExistentialRestrictions).map(m -> m.get(r)).map(HashSet::new).collect(Collectors.toList())).parallelStream().map(HashSet::new).map(ELLeastCommonSubsumer::lcs).map(ELConceptDescription::reduce).collect(Collectors.toSet()))).sequential()).forEach(p -> lcs.getExistentialRestrictions().putAll(p.x(), (Iterable)p.y()));
        return lcs.clone().reduce();
    }

    public static final OWLClassExpression of(OWLClassExpression concept1, OWLClassExpression concept2) {
        return ELLeastCommonSubsumer.lcs(ELConceptDescription.of(concept1), ELConceptDescription.of(concept2)).toOWLClassExpression();
    }

    public static final OWLClassExpression of(OWLClassExpression ... concepts) {
        if (concepts.length == 0) {
            return df.getOWLThing();
        }
        if (concepts.length == 1) {
            return concepts[0];
        }
        if (concepts.length == 2) {
            return ELLeastCommonSubsumer.of(concepts[0], concepts[1]);
        }
        return ELLeastCommonSubsumer.of(Arrays.asList(concepts));
    }

    public static final OWLClassExpression of(Collection<OWLClassExpression> concepts) {
        if (concepts.isEmpty()) {
            return df.getOWLThing();
        }
        Iterator<OWLClassExpression> it = concepts.iterator();
        if (concepts.size() == 1) {
            return it.next();
        }
        if (concepts.size() == 2) {
            return ELLeastCommonSubsumer.of(it.next(), it.next());
        }
        OWLClassExpression lcs = it.next();
        while (it.hasNext()) {
            lcs = ELLeastCommonSubsumer.of(lcs, it.next());
        }
        return lcs;
    }
}

