/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.dl.ELConceptDescription;
import conexp.fx.core.dl.ELParser;
import conexp.fx.core.dl.Signature;
import conexp.fx.core.util.Meter;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;

public final class ELNeighborhoodTest {
    public static void main(String[] args) {
        ELNeighborhoodTest.test12();
    }

    public static final void test1() {
    }

    private static final void test2() {
        LinkedList<String> sources = new LinkedList<String>();
        sources.add("A1 and A2 and A3 and A4 and A5");
        for (int i = 1; i < 100; ++i) {
            sources.add((String)sources.getFirst() + " and exists r.(" + (String)sources.getLast() + ")");
            ELConceptDescription C = ELParser.read((String)sources.getLast());
            Set<ELConceptDescription> Us = C.upperNeighbors();
            System.out.println("C" + i);
            System.out.println("has size " + C.size());
            System.out.println("and squared size " + C.size() * C.size());
            System.out.println("and its upper neighbors have size " + Us.parallelStream().collect(Collectors.summingLong(ELConceptDescription::size)));
            System.out.println();
        }
    }

    private static final void test3() {
        Meter<Long> timer = Meter.newNanoStopWatch();
        ELConceptDescription C = ELParser.read("exists r.(A and exists r.(A and B) and exists r.(B and C))");
        System.out.println(C);
        AtomicInteger p = new AtomicInteger(0);
        BitSetFX ds = new BitSetFX();
        ELNeighborhoodTest.recurse(C, 0, p::incrementAndGet, d -> {
            BitSetFX bitSetFX = ds;
            synchronized (bitSetFX) {
                ds.add((Integer)d);
            }
        });
        System.out.println("branches: " + p);
        System.out.println("quasi rank: " + ds);
        System.out.println("computation time: " + timer.measureAndFormat());
        timer.reset();
        System.out.println("rank: " + C.rank());
        System.out.println("computation time: " + timer.measureAndFormat());
    }

    private static final void recurse(ELConceptDescription C, int d, Supplier<Integer> pinc, Consumer<Integer> dadd) {
        if (C.isTop()) {
            pinc.get();
            dadd.accept(d);
            return;
        }
        C.upperNeighborsReduced().parallelStream().forEach(D -> ELNeighborhoodTest.recurse(D, d + 1, pinc, dadd));
    }

    private static final void test4() {
        ELConceptDescription C = ELParser.read("exists r.(A and B) and exists r.(A and C) and exists r.(B and C)");
        C.upperNeighborsReduced().forEach(System.out::println);
    }

    private static final void test5() {
        ELConceptDescription C = ELParser.read("exists r.(A and exists r.(A and B))");
        C.upperNeighborsReduced().forEach(System.out::println);
    }

    private static final void test6() {
        ELConceptDescription C = ELParser.read("A and exists r.(A and B)");
        C.upperNeighborsReduced().forEach(System.out::println);
    }

    private static final void test7() {
        Meter<Long> timer = Meter.newNanoStopWatch();
        ELConceptDescription C = ELParser.read("exists r.(A and exists r.(A and B) and exists r.(B and C))");
        System.out.println(C);
        System.out.println("rank: " + C.rank());
        System.out.println("computation time: " + timer.measureAndFormat());
    }

    private static final void test8() {
        Signature sigma = new Signature(IRI.create((String)"foo"));
        sigma.addConceptNames("A1", "A2", "A3", "A4");
        sigma.addRoleNames("r", "s");
        ELConceptDescription C = ELParser.read("exists r.(A1\u2293A2\u2293A3\u2293\u2203s.(A1\u2293\u2203r.A3\u2293\u2203s.A3\u2293\u2203r.(A2\u2293\u2203s.\u22a4))\u2293\u2203s.(\u2203r.\u22a4\u2293\u2203s.(A2\u2293\u2203r.A3)\u2293\u2203s.\u2203r.A4)\u2293\u2203r.(A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293A3)))");
        C.reduce();
        System.out.println(C);
        Meter<Long> timer = Meter.newNanoStopWatch();
        System.out.println("has role depth: " + C.roleDepth());
        System.out.println("computation time: " + timer.measureAndFormat());
        timer.reset();
        System.out.println("has size: " + C.size());
        System.out.println("computation time: " + timer.measureAndFormat());
        timer.reset();
        System.out.println("has rank: " + C.rank());
        System.out.println("computation time: " + timer.measureAndFormat());
        System.out.println("and has the following upper neighbors:");
        timer.reset();
        Set<ELConceptDescription> upperNeighbors = C.upperNeighborsReduced();
        String upperNeighborsTime = timer.measureAndFormat();
        AtomicInteger i = new AtomicInteger(0);
        upperNeighbors.forEach(D -> System.out.println(i.incrementAndGet() + " --- " + D.rank() + " --- " + D));
        System.out.println("computation time: " + upperNeighborsTime);
        System.out.println("and has the following lower neighbors:");
        timer.reset();
        Set<ELConceptDescription> lowerNeighbors = C.lowerNeighbors(sigma);
        String lowerNeighborsTime = timer.measureAndFormat();
        i.set(0);
        lowerNeighbors.forEach(D -> {
            D.reduce();
            System.out.println(i.incrementAndGet() + " --- " + D.upperNeighborsReduced().parallelStream().anyMatch(C::isEquivalentTo) + " --- " + D.rank() + " --- " + D);
        });
        System.out.println("computation time: " + lowerNeighborsTime);
        System.out.println("and has the following lower neighbors (v3):");
        timer.reset();
        Set<ELConceptDescription> lowerNeighbors3 = C.lowerNeighbors3(sigma);
        String lowerNeighbors3Time = timer.measureAndFormat();
        i.set(0);
        lowerNeighbors3.forEach(D -> {
            D.reduce();
            System.out.println(i.incrementAndGet() + " --- " + D.upperNeighborsReduced().parallelStream().anyMatch(C::isEquivalentTo) + " --- " + D.rank() + " --- " + D);
        });
        System.out.println("computation time: " + lowerNeighbors3Time);
        System.out.println();
        System.out.println("1=3   " + ELNeighborhoodTest.equalsEquivalent(lowerNeighbors, lowerNeighbors3));
    }

    private static final boolean containsEquivalent(Set<ELConceptDescription> Cs, Set<ELConceptDescription> Ds) {
        return Cs.parallelStream().allMatch(C -> Ds.parallelStream().anyMatch(C::isEquivalentTo));
    }

    private static final boolean equalsEquivalent(Set<ELConceptDescription> Cs, Set<ELConceptDescription> Ds) {
        return ((Stream)Stream.of(() -> ELNeighborhoodTest.containsEquivalent(Cs, Ds), () -> ELNeighborhoodTest.containsEquivalent(Ds, Cs)).parallel()).allMatch(Supplier::get);
    }

    private static final void test9() {
        ELConceptDescription C = ELParser.read("A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293A3))");
        C.reduce();
        System.out.println(C);
        Meter<Long> timer = Meter.newNanoStopWatch();
        for (int i = 0; i < 3; ++i) {
            timer.reset();
            System.out.println("rank: " + C.unreducedRank());
            System.out.println("computation time: " + timer.measureAndFormat());
            timer.reset();
            System.out.println("rank2: " + C.unreducedRank2());
            System.out.println("computation time: " + timer.measureAndFormat());
            timer.reset();
            System.out.println("rank3: " + C.rank3());
            System.out.println("computation time: " + timer.measureAndFormat());
            timer.reset();
            System.out.println("rank4: " + C.unreducedRank4());
            System.out.println("computation time: " + timer.measureAndFormat());
        }
    }

    private static final void test10() {
        Meter<Long> timer = Meter.newNanoStopWatch();
        String source = "(A\u2293B\u2293C)";
        for (int i = 0; i < 10; ++i) {
            source = "\u2203r." + source;
            ELConceptDescription C = ELParser.read(source);
            System.out.println(C);
            timer.reset();
            System.out.println("rank1: " + C.rank());
            System.out.println("computation time: " + timer.measureAndFormat());
            timer.reset();
            System.out.println("rank2: " + C.rank2());
            System.out.println("computation time: " + timer.measureAndFormat());
            System.out.println();
        }
    }

    private static final void test11() {
        ELConceptDescription C = ELParser.read("A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2))");
        ELConceptDescription D = ELParser.read("A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293\u2203r.(A1\u2293A2\u2293A3)\u2293\u2203r.\u2203s.(A1 and A2 AND A3))");
        C.reduce();
        D.reduce();
        System.out.println(C);
        System.out.println(D);
        Meter<Long> timer = Meter.newNanoStopWatch();
        for (int i = 0; i < 3; ++i) {
            timer.reset();
            System.out.println("distance: " + C.distanceTo(D));
            System.out.println("computation time: " + timer.measureAndFormat());
            timer.reset();
            System.out.println("distance2: " + C.distanceTo2(D));
            System.out.println("computation time: " + timer.measureAndFormat());
        }
    }

    private static final void test12() {
        Signature sigma = new Signature(IRI.create((String)"foo"));
        sigma.addConceptNames("A1", "A2", "A3", "A4");
        sigma.addRoleNames("r", "s");
        ELConceptDescription C = ELParser.read("A1\u2293A2\u2293A3\u2293\u2203r.(A1\u2293A2\u2293\u2203r.(A1\u2293A2\u2293A3)\u2293\u2203s.(A1 and \u2203r.A3))");
        C.reduce();
        int radius = 3;
        System.out.println(C);
        System.out.println("radius: 3");
        Meter<Long> timer = Meter.newNanoStopWatch();
        for (int i = 0; i < 3; ++i) {
            timer.reset();
            Set<ELConceptDescription> neighborhood = C.neighborhood(3, sigma);
            String ctime = timer.measureAndFormat();
            System.out.println(neighborhood.size() + " neighbors:");
            neighborhood.forEach(D -> System.out.println(D));
            System.out.println("computation time: " + ctime);
        }
    }
}

