/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.Sets;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.dl.Constructor;
import conexp.fx.core.dl.DescriptionLogic;
import conexp.fx.core.dl.Matrix3D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;

public class Interpretation2 {
    protected final Matrix3D<OWLNamedIndividual, OWLObjectProperty, OWLClass> concepts;
    protected final Matrix3D<OWLNamedIndividual, OWLObjectProperty, OWLNamedIndividual> roles;
    protected final OWLDataFactory df;
    protected final OWLObjectProperty type;

    public Interpretation2(int individuals, int concepts, int roles) {
        this.concepts = new Matrix3D(individuals, 1, concepts);
        this.roles = new Matrix3D(individuals, roles, individuals);
        this.df = OWLManager.getOWLDataFactory();
        this.type = this.df.getOWLObjectProperty(IRI.create((String)RDF.TYPE.stringValue()));
        this.concepts.addM(this.type);
    }

    public final void addIndividual(OWLNamedIndividual d) {
        this.concepts.addG(d);
        this.roles.addG(d);
        this.roles.addW(d);
    }

    public final void addIndividual(String d) {
        this.addIndividual(this.df.getOWLNamedIndividual(IRI.create((String)d)));
    }

    public final void addConcept(OWLClass c) {
        this.concepts.addW(c);
    }

    public final void addConcept(String c) {
        this.addConcept(this.df.getOWLClass(IRI.create((String)c)));
    }

    public final void addRole(OWLObjectProperty r) {
        this.roles.addM(r);
    }

    public final void addRole(String r) {
        this.addRole(this.df.getOWLObjectProperty(IRI.create((String)r)));
    }

    public final void addConceptAssertion(OWLNamedIndividual d, OWLClass c) {
        this.concepts.add(d, this.type, c);
    }

    public final void addConceptAssertion(String d, String c) {
        this.addConceptAssertion(this.df.getOWLNamedIndividual(IRI.create((String)d)), this.df.getOWLClass(IRI.create((String)c)));
    }

    public final void addRoleAssertion(OWLNamedIndividual d, OWLObjectProperty r, OWLNamedIndividual e) {
        this.roles.add(d, r, e);
    }

    public final void addRoleAssertion(String d, String r, String e) {
        this.addRoleAssertion(this.df.getOWLNamedIndividual(IRI.create((String)d)), this.df.getOWLObjectProperty(IRI.create((String)r)), this.df.getOWLNamedIndividual(IRI.create((String)e)));
    }

    public final Set<OWLNamedIndividual> getIndividuals() {
        return Sets.union(this.concepts.getGs(), (Set)Sets.union(this.roles.getGs(), this.roles.getWs()));
    }

    public final Set<OWLClass> getConcepts() {
        return this.concepts.getWs();
    }

    public final Set<OWLObjectProperty> getRoles() {
        return this.roles.getMs();
    }

    public final Set<OWLNamedIndividual> getIndividuals(String clazz) {
        return this.getIndividuals(this.df.getOWLClass(IRI.create((String)clazz)));
    }

    public final Set<OWLNamedIndividual> getIndividuals(OWLClass clazz) {
        return this.concepts.row(this.type, clazz).collect(Collectors.toSet());
    }

    public final Set<Pair<OWLNamedIndividual, OWLNamedIndividual>> getIndividuals(OWLObjectProperty role) {
        return null;
    }

    public final boolean isInstanceOf(OWLNamedIndividual i, OWLClassExpression c) {
        if (c.equals(this.df.getOWLThing())) {
            return true;
        }
        if (c.equals(this.df.getOWLNothing())) {
            return false;
        }
        if (c instanceof OWLClass) {
            return this.concepts.get(i, this.type, (OWLClass)c);
        }
        if (c instanceof OWLObjectSomeValuesFrom) {
            return this.roles.cut(i, (OWLObjectProperty)((OWLObjectSomeValuesFrom)c).getProperty()).anyMatch(j -> this.isInstanceOf((OWLNamedIndividual)j, (OWLClassExpression)((OWLObjectSomeValuesFrom)c).getFiller()));
        }
        if (c instanceof OWLObjectIntersectionOf) {
            return ((OWLObjectIntersectionOf)c).asConjunctSet().stream().allMatch(d -> this.isInstanceOf(i, (OWLClassExpression)d));
        }
        return false;
    }

    public final boolean isInstanceOf(String i, String c) {
        return this.isInstanceOf(this.df.getOWLNamedIndividual(IRI.create((String)i)), (OWLClassExpression)this.df.getOWLClass(IRI.create((String)c)));
    }

    public final OWLClassExpression getMMSC(Set<OWLNamedIndividual> individuals, int roleDepth, DescriptionLogic dl) {
        final HashSet<Object> conjuncts = new HashSet<Object>();
        this.concepts.cut(individuals.stream(), this.type).forEach(new Consumer<OWLClass>(){

            @Override
            public void accept(OWLClass conceptName) {
                conjuncts.add(conceptName);
            }
        });
        if (roleDepth > 0) {
            for (OWLObjectProperty role : this.roles.getMs()) {
                for (Constructor constructor : dl.constructors) {
                    for (Set<OWLNamedIndividual> successor : this.minimalSuccessorSets(individuals, role, constructor)) {
                        switch (constructor) {
                            case EXISTENTIAL_RESTRICTION: {
                                conjuncts.add(this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)role, this.getMMSC(successor, roleDepth - 1, dl)));
                                break;
                            }
                            case VALUE_RESTRICTION: {
                                conjuncts.add(this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)role, this.getMMSC(successor, roleDepth - 1, dl)));
                                break;
                            }
                            case QUALIFIED_AT_LEAST_RESTRICTION: {
                                break;
                            }
                            case UNQUALIFIED_AT_MOST_RESTRICTION: {
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (conjuncts.size() > 1) {
            return new OWLObjectIntersectionOfImpl(conjuncts);
        }
        if (conjuncts.size() == 1) {
            return (OWLClassExpression)conjuncts.iterator().next();
        }
        return this.df.getOWLThing();
    }

    public final OWLClassExpression getMMSC_(Set<String> individuals, int roleDepth, DescriptionLogic dl) {
        return this.getMMSC(individuals.stream().map(i -> this.df.getOWLNamedIndividual(IRI.create((String)i))).collect(Collectors.toSet()), roleDepth, dl);
    }

    private final Set<Set<OWLNamedIndividual>> minimalSuccessorSets(Set<OWLNamedIndividual> individuals, OWLObjectProperty role, Constructor constructor) {
        switch (constructor) {
            case EXISTENTIAL_RESTRICTION: {
                HashSet successors0 = new HashSet();
                for (OWLNamedIndividual individual : individuals) {
                    successors0.addAll(this.roles.cut(individual, role).collect(Collectors.toSet()));
                }
                HashSet minSets = Sets.newHashSet((Iterable)Sets.powerSet(successors0));
                HashSet<Object> t = new HashSet<Object>();
                for (Object set : minSets) {
                    for (OWLNamedIndividual oWLNamedIndividual : individuals) {
                        if (!this.roles.cut(oWLNamedIndividual, role).noneMatch(((Set)set)::contains)) continue;
                        t.add(set);
                    }
                }
                minSets.removeAll(t);
                HashSet<Set> nonMinSets = new HashSet<Set>();
                block9: for (Set x : minSets) {
                    for (Set y : minSets) {
                        if (x.equals(y) || !x.containsAll(y)) continue;
                        nonMinSets.add(x);
                        continue block9;
                    }
                }
                minSets.removeAll(nonMinSets);
                return minSets;
            }
            case VALUE_RESTRICTION: {
                HashSet successors = new HashSet();
                for (OWLNamedIndividual oWLNamedIndividual : individuals) {
                    successors.addAll(this.roles.cut(oWLNamedIndividual, role).collect(Collectors.toSet()));
                }
                return Collections.singleton(successors);
            }
            case QUALIFIED_AT_LEAST_RESTRICTION: {
                return Collections.emptySet();
            }
            case UNQUALIFIED_AT_MOST_RESTRICTION: {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public final MatrixContext<OWLNamedIndividual, OWLClassExpression> toLogicalContext(int roleDepth, DescriptionLogic dl) {
        MatrixContext<OWLNamedIndividual, OWLClassExpression> cxt = new MatrixContext<OWLNamedIndividual, OWLClassExpression>(false);
        cxt.rowHeads().addAll(this.concepts.getGs());
        cxt.colHeads().addAll(this.createMMSCConjuncts(roleDepth, dl));
        for (OWLNamedIndividual i : cxt.rowHeads()) {
            for (OWLClassExpression c : cxt.colHeads()) {
                if (!this.isInstanceOf(i, c)) continue;
                cxt.addFast(i, c);
            }
        }
        return cxt;
    }

    private final List<OWLClassExpression> createMMSCConjuncts(int roleDepth, DescriptionLogic dl) {
        ArrayList<OWLClassExpression> mmscConjuncts = new ArrayList<OWLClassExpression>();
        mmscConjuncts.add((OWLClassExpression)this.df.getOWLNothing());
        mmscConjuncts.addAll(this.concepts.getWs());
        if (roleDepth > 0) {
            for (Set s : Sets.powerSet(this.concepts.getGs())) {
                if (s.isEmpty()) continue;
                OWLClassExpression mmsc = this.getMMSC(s, roleDepth - 1, dl);
                for (OWLObjectProperty role : this.roles.getMs()) {
                    block6: for (Constructor constructor : dl.constructors) {
                        switch (constructor) {
                            case EXISTENTIAL_RESTRICTION: {
                                mmscConjuncts.add((OWLClassExpression)this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)role, mmsc));
                                continue block6;
                            }
                            case VALUE_RESTRICTION: {
                                mmscConjuncts.add((OWLClassExpression)this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)role, mmsc));
                                continue block6;
                            }
                        }
                    }
                }
            }
        }
        return mmscConjuncts;
    }

    public static final Interpretation2 importFromRDFFile(File rdfFile, String baseURI) throws RepositoryException, RDFParseException, IOException {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        RepositoryConnection connection = repo.getConnection();
        connection.add(rdfFile, baseURI, RDFFormat.forFileName((String)rdfFile.getName(), (RDFFormat)RDFFormat.RDFXML), new Resource[0]);
        connection.commit();
        connection.close();
        return Interpretation2.importFromRDFRepository((Repository)repo);
    }

    public static final Interpretation2 importFromRDFRepository(Repository repo) throws RepositoryException {
        RepositoryConnection connection = repo.getConnection();
        HashSet<Resource> properties = new HashSet<Resource>();
        RepositoryResult statements = connection.getStatements(null, RDF.TYPE, (Value)RDF.PROPERTY, true, new Resource[0]);
        while (statements.hasNext()) {
            properties.add(((Statement)statements.next()).getSubject());
        }
        statements.close();
        HashSet<Resource> classes = new HashSet<Resource>();
        RepositoryResult statements2 = connection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, true, new Resource[0]);
        while (statements2.hasNext()) {
            classes.add(((Statement)statements2.next()).getSubject());
        }
        statements2.close();
        HashSet<Resource> individuals = new HashSet<Resource>();
        RepositoryResult statements3 = connection.getStatements(null, RDF.TYPE, null, true, new Resource[0]);
        while (statements3.hasNext()) {
            Statement stmt = (Statement)statements3.next();
            if (stmt.getObject().equals(RDF.PROPERTY) || stmt.getObject().equals(RDFS.CLASS)) continue;
            individuals.add(stmt.getSubject());
        }
        statements3.close();
        Interpretation2 i = new Interpretation2(individuals.size(), classes.size(), properties.size());
        for (Resource individual : individuals) {
            i.addIndividual(individual.stringValue());
        }
        for (Resource clazz : classes) {
            i.addConcept(clazz.stringValue());
        }
        for (Resource property : properties) {
            i.addRole(property.stringValue());
        }
        RepositoryResult statements4 = connection.getStatements(null, RDF.TYPE, null, true, new Resource[0]);
        while (statements4.hasNext()) {
            Statement stmt = (Statement)statements4.next();
            if (stmt.getObject().equals(RDF.PROPERTY) || stmt.getObject().equals(RDFS.CLASS)) continue;
            i.addConceptAssertion(stmt.getSubject().stringValue(), stmt.getObject().stringValue());
        }
        statements4.close();
        RepositoryResult statements5 = connection.getStatements(null, null, null, true, new Resource[0]);
        while (statements5.hasNext()) {
            Statement stmt = (Statement)statements5.next();
            if (stmt.getPredicate().equals((Object)RDF.TYPE) || stmt.getObject().equals(RDF.PROPERTY) || stmt.getObject().equals(RDFS.CLASS)) continue;
            i.addRoleAssertion(stmt.getSubject().stringValue(), stmt.getPredicate().stringValue(), stmt.getObject().stringValue());
        }
        statements5.close();
        connection.close();
        return i;
    }
}

