/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import conexp.fx.core.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.ValueType;

public class Matrix3D<G, M, W> {
    protected final Matrix mat;
    private int xs = 0;
    private int ys = 0;
    private int zs = 0;
    private final Map<G, Integer> x1;
    private final Map<M, Integer> y1;
    private final Map<W, Integer> z1;
    private final Map<Integer, G> x2;
    private final Map<Integer, M> y2;
    private final Map<Integer, W> z2;

    public Matrix3D(int x, int y, int z) {
        this.mat = Matrix.Factory.zeros(ValueType.BOOLEAN, new long[]{x, y, z});
        this.x1 = new HashMap<G, Integer>(x);
        this.y1 = new HashMap<M, Integer>(y);
        this.z1 = new HashMap<W, Integer>(z);
        this.x2 = new HashMap<Integer, G>(x);
        this.y2 = new HashMap<Integer, M>(y);
        this.z2 = new HashMap<Integer, W>(z);
    }

    public final void addG(G g) {
        if (this.x1.keySet().contains(g)) {
            return;
        }
        this.x1.put(g, this.xs);
        this.x2.put(this.xs, g);
        ++this.xs;
    }

    public final void addM(M m) {
        if (this.y1.keySet().contains(m)) {
            return;
        }
        this.y1.put(m, this.ys);
        this.y2.put(this.ys, m);
        ++this.ys;
    }

    public final void addW(W w) {
        if (this.z1.keySet().contains(w)) {
            return;
        }
        this.z1.put(w, this.zs);
        this.z2.put(this.zs, w);
        ++this.zs;
    }

    public final Set<G> getGs() {
        return this.x1.keySet();
    }

    public final Set<M> getMs() {
        return this.y1.keySet();
    }

    public final Set<W> getWs() {
        return this.z1.keySet();
    }

    public final void add(G g, M m, W w) throws NullPointerException {
        this.mat.setAsBoolean(true, new long[]{this.x1.get(g).intValue(), this.y1.get(m).intValue(), this.z1.get(w).intValue()});
    }

    public final boolean get(G g, M m, W w) throws NullPointerException {
        return this.mat.getAsBoolean(new long[]{this.x1.get(g).intValue(), this.y1.get(m).intValue(), this.z1.get(w).intValue()});
    }

    public final Stream<G> row(M m, W w) {
        int y = this.y1.get(m);
        int z = this.z1.get(w);
        return this.x1.keySet().stream().filter(g -> this.mat.getAsBoolean(new long[]{this.x1.get(g).intValue(), y, z}));
    }

    public final Stream<M> col(G g, W w) {
        int x = this.x1.get(g);
        int z = this.z1.get(w);
        return this.y1.keySet().stream().filter(m -> this.mat.getAsBoolean(new long[]{x, this.y1.get(m).intValue(), z}));
    }

    public final Stream<W> cut(G g, M m) {
        int x = this.x1.get(g);
        int y = this.y1.get(m);
        return this.z1.keySet().stream().filter(w -> this.mat.getAsBoolean(new long[]{x, y, this.z1.get(w).intValue()}));
    }

    public final Stream<W> cut(Stream<G> gs, M m) {
        Set _gs = gs.collect(Collectors.toSet());
        int y = this.y1.get(m);
        return this.z1.keySet().stream().filter(w -> _gs.stream().allMatch(g -> this.mat.getAsBoolean(new long[]{this.x1.get(g).intValue(), y, this.z1.get(w).intValue()})));
    }

    public final Set<Pair<G, W>> getPairsGW(M m) {
        HashSet<Pair<G, W>> pairs = new HashSet<Pair<G, W>>();
        for (G g : this.getGs()) {
            for (W w : this.getWs()) {
                if (!this.get(g, m, w)) continue;
                pairs.add(new Pair<G, W>(g, w));
            }
        }
        return pairs;
    }
}

