/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import conexp.fx.core.algorithm.nextclosures.NextClosures1;
import conexp.fx.core.algorithm.nextclosures.NextClosures1C;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.SparseContext;
import conexp.fx.core.dl.AInterpretation;
import conexp.fx.core.dl.Constructor;
import conexp.fx.core.dl.ELConceptDescription;
import conexp.fx.core.dl.ELLeastCommonSubsumer;
import conexp.fx.core.dl.ELReasoner;
import conexp.fx.core.dl.ELSyntaxException;
import conexp.fx.core.dl.OWLMinimizer;
import conexp.fx.core.dl.Signature;
import conexp.fx.core.math.ClosureOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.elk.util.collections.Triple;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;

public class OWLInterpretation
extends AInterpretation<OWLClassExpression, OWLSubClassOfAxiom, OWLOntology> {
    public final OWLDataFactory df = OWLManager.getOWLDataFactory();
    private final Map<Set<IRI>, OWLClassExpression> cache = new ConcurrentHashMap<Set<IRI>, OWLClassExpression>();

    public OWLInterpretation(IRI baseIRI) {
        super(baseIRI);
    }

    public OWLInterpretation(Signature signature) {
        super(signature);
    }

    public OWLInterpretation(Signature signature, Set<IRI> domain) {
        super(signature, domain);
    }

    @Override
    public final boolean isInstanceOf(IRI individual, OWLClassExpression conceptExpression) {
        OWLObjectComplementOf primitiveNegation;
        if (conceptExpression.isOWLNothing()) {
            return false;
        }
        if (conceptExpression.isOWLThing()) {
            return true;
        }
        if (conceptExpression instanceof OWLClass) {
            return this.getConceptNameExtension(((OWLClass)conceptExpression).getIRI()).contains(individual);
        }
        if (conceptExpression instanceof OWLObjectIntersectionOf) {
            return ((OWLObjectIntersectionOf)conceptExpression).asConjunctSet().parallelStream().allMatch(c -> this.isInstanceOf(individual, (OWLClassExpression)c));
        }
        if (conceptExpression instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom existentialRestriction = (OWLObjectSomeValuesFrom)conceptExpression;
            return this.getRoleSuccessorStream(((OWLObjectProperty)existentialRestriction.getProperty()).getIRI(), individual).anyMatch(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)existentialRestriction.getFiller()));
        }
        if (conceptExpression instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom valueRestriction = (OWLObjectAllValuesFrom)conceptExpression;
            return this.getRoleSuccessorStream(((OWLObjectProperty)valueRestriction.getProperty()).getIRI(), individual).allMatch(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)valueRestriction.getFiller()));
        }
        if (conceptExpression instanceof OWLObjectHasSelf) {
            OWLObjectHasSelf existentialSelfRestriction = (OWLObjectHasSelf)conceptExpression;
            return this.getRoleNameExtension(((OWLObjectProperty)existentialSelfRestriction.getProperty()).getIRI()).contains(Pair.of(individual, individual));
        }
        if (conceptExpression instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality qualifiedNumberRestriction = (OWLObjectMinCardinality)conceptExpression;
            return this.getRoleSuccessorStream(((OWLObjectProperty)qualifiedNumberRestriction.getProperty()).getIRI(), individual).filter(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)qualifiedNumberRestriction.getFiller())).skip(qualifiedNumberRestriction.getCardinality() - 1).findAny().isPresent();
        }
        if (conceptExpression instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality qualifiedNumberRestriction = (OWLObjectMaxCardinality)conceptExpression;
            return !this.getRoleSuccessorStream(((OWLObjectProperty)qualifiedNumberRestriction.getProperty()).getIRI(), individual).filter(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)qualifiedNumberRestriction.getFiller())).skip(qualifiedNumberRestriction.getCardinality()).findAny().isPresent();
        }
        if (conceptExpression instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality qualifiedNumberRestriction = (OWLObjectExactCardinality)conceptExpression;
            return this.getRoleSuccessorStream(((OWLObjectProperty)qualifiedNumberRestriction.getProperty()).getIRI(), individual).filter(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)qualifiedNumberRestriction.getFiller())).skip(qualifiedNumberRestriction.getCardinality() - 1).findAny().isPresent() && !this.getRoleSuccessorStream(((OWLObjectProperty)qualifiedNumberRestriction.getProperty()).getIRI(), individual).filter(succ -> this.isInstanceOf((IRI)succ, (OWLClassExpression)qualifiedNumberRestriction.getFiller())).skip(qualifiedNumberRestriction.getCardinality()).findAny().isPresent();
        }
        if (conceptExpression instanceof OWLObjectComplementOf && (primitiveNegation = (OWLObjectComplementOf)conceptExpression).isClassExpressionLiteral()) {
            return !this.isInstanceOf(individual, (OWLClassExpression)((OWLClass)primitiveNegation.getOperand()));
        }
        throw new ELSyntaxException();
    }

    @Override
    public final boolean satisfies(OWLSubClassOfAxiom gci) {
        return this.isSubsumedBy(gci.getSubClass(), gci.getSuperClass());
    }

    @Override
    public final boolean models(OWLOntology tBox) {
        return tBox.getTBoxAxioms(true).parallelStream().allMatch(gci -> gci instanceof OWLSubClassOfAxiom ? this.satisfies((OWLSubClassOfAxiom)gci) : true);
    }

    public OWLClassExpression getMostSpecificConceptALQ(IRI individual, int roleDepth, int maxCardinality, Constructor ... constructors) {
        return this.getMostSpecificConceptALQ(Collections.singleton(individual), roleDepth, maxCardinality, constructors);
    }

    public OWLClassExpression getMostSpecificConceptALQ(Set<IRI> individuals, int roleDepth, int maxCardinality, Constructor ... constructors) {
        this.checkRoleDepth(roleDepth);
        if (individuals.isEmpty()) {
            return this.df.getOWLNothing();
        }
        HashSet<Object> conjuncts = new HashSet<Object>();
        for (IRI conceptName : this.conceptNameExtensions.keySet()) {
            if (this.getConceptNameExtension(conceptName).containsAll(individuals)) {
                conjuncts.add(new OWLClassImpl(conceptName));
                continue;
            }
            if (!Arrays.asList(constructors).contains((Object)Constructor.PRIMITIVE_NEGATION) || !Collections2.filter(this.getDomain(), d -> !this.getConceptNameExtension(conceptName).contains(d)).containsAll(individuals)) continue;
            conjuncts.add(new OWLObjectComplementOfImpl((OWLClassExpression)new OWLClassImpl(conceptName)));
        }
        if (roleDepth > 0) {
            for (IRI roleName : this.signature.getRoleNames()) {
                OWLObjectProperty property = this.df.getOWLObjectProperty(roleName);
                if (Arrays.asList(constructors).contains((Object)Constructor.EXISTENTIAL_SELF_RESTRICTION) && individuals.parallelStream().allMatch(individual -> this.getRoleNameExtension(roleName).contains(Pair.of(individual, individual)))) {
                    conjuncts.add(this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)property));
                }
                if (Arrays.asList(constructors).contains((Object)Constructor.EXISTENTIAL_RESTRICTION)) {
                    for (Set<IRI> successors : this.getSuccessorSetsER(individuals, roleName)) {
                        conjuncts.add(this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getMostSpecificConceptALQ(successors, roleDepth - 1, maxCardinality, constructors)));
                    }
                }
                if (Arrays.asList(constructors).contains((Object)Constructor.VALUE_RESTRICTION)) {
                    conjuncts.add(this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getMostSpecificConceptALQ(this.getAllSuccessors(individuals, roleName), roleDepth - 1, maxCardinality, constructors)));
                }
                if (Arrays.asList(constructors).contains((Object)Constructor.UNQUALIFIED_AT_MOST_RESTRICTION)) {
                    for (int cardinality = 1; cardinality < maxCardinality; ++cardinality) {
                        for (Set<IRI> successors : this.getSuccessorSetsQLR(individuals, roleName, cardinality)) {
                            conjuncts.add(this.df.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)property, this.getMostSpecificConceptALQ(successors, roleDepth - 1, maxCardinality, constructors)));
                        }
                    }
                }
                if (!Arrays.asList(constructors).contains((Object)Constructor.QUALIFIED_AT_LEAST_RESTRICTION)) continue;
                for (int cardinality = 2; cardinality < maxCardinality; ++cardinality) {
                    for (Set<IRI> successors : this.getSuccessorSetsQGR(individuals, roleName, cardinality)) {
                        conjuncts.add(this.df.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)property, this.getMostSpecificConceptALQ(successors, roleDepth - 1, maxCardinality, constructors)));
                    }
                }
            }
        }
        if (conjuncts.isEmpty()) {
            return this.df.getOWLThing();
        }
        if (conjuncts.size() == 1) {
            return (OWLClassExpression)conjuncts.iterator().next();
        }
        return new OWLObjectIntersectionOfImpl(conjuncts);
    }

    protected final Set<IRI> getAllSuccessors(Set<IRI> individuals, IRI roleName) {
        if (individuals.isEmpty()) {
            return Collections.emptySet();
        }
        Optional<Stream> optional = individuals.parallelStream().map(individual -> this.getRoleSuccessorStream(roleName, (IRI)individual)).reduce(Stream::concat);
        if (optional.isPresent()) {
            return optional.get().collect(Collectors.toSet());
        }
        System.out.println("optional is not present");
        System.out.println(this.getRoleSuccessors(roleName, individuals.iterator().next()));
        return Collections.emptySet();
    }

    protected final Set<Set<IRI>> getSuccessorSetsER(Set<IRI> individuals, IRI roleName) {
        return OWLInterpretation.filterMinimal(Sets.powerSet(this.getAllSuccessors(individuals, roleName)).parallelStream().filter(successors -> individuals.parallelStream().allMatch(individual -> successors.parallelStream().anyMatch(successor -> this.getRoleNameExtension(roleName).contains(Pair.of(individual, successor))))).collect(Collectors.toSet()));
    }

    protected final Set<Set<IRI>> getSuccessorSetsER2(Set<IRI> individuals, IRI roleName) {
        Set<Set<IRI>> successorSets = Collections.emptySet();
        Iterator<IRI> it = individuals.iterator();
        if (it.hasNext()) {
            successorSets = this.firstSuccessorSetsER(it.next(), roleName);
        }
        while (it.hasNext()) {
            successorSets = this.extendSuccessorSetsER(successorSets, it.next(), roleName);
        }
        return OWLInterpretation.filterMinimal(successorSets);
    }

    private final Set<Set<IRI>> firstSuccessorSetsER(IRI individual, IRI roleName) {
        return this.getRoleSuccessorStream(roleName, individual).map(successor -> Sets.newHashSet((Object[])new IRI[]{successor})).collect(Collectors.toSet());
    }

    private final Set<Set<IRI>> extendSuccessorSetsER(Set<Set<IRI>> successorSets, IRI individual, IRI roleName) {
        HashSet<Set<IRI>> extendedSets = new HashSet<Set<IRI>>();
        Set extendedSetsP = Collections.synchronizedSet(extendedSets);
        successorSets.parallelStream().forEach(successorSet -> this.getRoleSuccessorStream(roleName, individual).forEach(successor -> {
            HashSet<IRI> extendedSet = new HashSet<IRI>();
            extendedSet.addAll((Collection<IRI>)successorSet);
            extendedSet.add((IRI)successor);
            extendedSetsP.add(extendedSet);
        }));
        return extendedSets;
    }

    public static final <T> Set<Set<T>> filterMinimal(Set<Set<T>> sets) {
        return OWLMinimizer.filterMinimalParallel(sets, (set1, set2) -> set1.containsAll((Collection<?>)set2));
    }

    private final Set<Set<IRI>> getSuccessorSetsQGR(Set<IRI> individuals, IRI roleName, int cardinality) {
        return OWLInterpretation.filterMinimal(Sets.powerSet(this.getAllSuccessors(individuals, roleName)).parallelStream().filter(successors -> individuals.parallelStream().allMatch(individual -> successors.parallelStream().filter(successor -> this.getRoleNameExtension(roleName).contains(Pair.of(individual, successor))).skip(cardinality - 1).findAny().isPresent())).collect(Collectors.toSet()));
    }

    private final Set<Set<IRI>> getSuccessorSetsQLR(Set<IRI> individuals, IRI roleName, int cardinality) {
        return OWLInterpretation.filterMinimal(Sets.powerSet(this.getAllSuccessors(individuals, roleName)).parallelStream().filter(successors -> individuals.parallelStream().allMatch(individual -> !successors.parallelStream().filter(successor -> this.getRoleNameExtension(roleName).contains(Pair.of(individual, successor))).skip(cardinality).findAny().isPresent())).collect(Collectors.toSet()));
    }

    @Override
    public OWLClassExpression getMostSpecificConcept(IRI individual, int roleDepth, int maxCardinality, Constructor ... constructors) {
        return this.getMostSpecificConcept(Collections.singleton(individual), roleDepth, maxCardinality, constructors);
    }

    @Override
    public OWLClassExpression getMostSpecificConcept(Set<IRI> individuals, int roleDepth, int maxCardinality, Constructor ... constructors) {
        if (this.cache.containsKey(individuals)) {
            return this.cache.get(individuals);
        }
        OWLClassExpression mmsc = this.getMostSpecificConceptALQ(individuals, roleDepth, maxCardinality, constructors);
        this.cache.put(individuals, mmsc);
        return mmsc;
    }

    public OWLClassExpression _getMostSpecificConcept(IRI individual, int roleDepth) {
        this.checkRoleDepth(roleDepth);
        HashSet<Object> conjuncts = new HashSet<Object>();
        for (IRI conceptName : this.conceptNameExtensions.keySet()) {
            if (!this.getConceptNameExtension(conceptName).contains(individual)) continue;
            conjuncts.add(new OWLClassImpl(conceptName));
        }
        if (roleDepth > 0) {
            for (IRI roleName : this.roleNameExtensions.keySet()) {
                for (Pair<IRI, IRI> pair : this.getRoleNameExtension(roleName)) {
                    if (!pair.x().equals((Object)individual)) continue;
                    conjuncts.add(this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName), this.getMostSpecificConcept(pair.y(), 0, roleDepth - 1, new Constructor[0])));
                }
            }
        }
        if (conjuncts.isEmpty()) {
            return this.df.getOWLThing();
        }
        if (conjuncts.size() == 1) {
            return (OWLClassExpression)conjuncts.iterator().next();
        }
        return new OWLObjectIntersectionOfImpl(conjuncts);
    }

    public final OWLClassExpression _getMostSpecificConcept(Set<IRI> individuals, int roleDepth) {
        this.checkRoleDepth(roleDepth);
        return ELLeastCommonSubsumer.of(Collections2.transform(individuals, individual -> this.getMostSpecificConcept((IRI)individual, 0, roleDepth, new Constructor[0])));
    }

    @Override
    protected final SetList<OWLClassExpression> getAttributeSetForInducedContext(int roleDepth, int maxCardinality, Constructor ... constructors) {
        Set mmscs = roleDepth > 0 ? this.getAllMostSpecificConcepts(roleDepth - 1, maxCardinality, constructors) : Collections.emptySet();
        HashSetArrayList<OWLClassExpression> _codomain = new HashSetArrayList<OWLClassExpression>();
        _codomain.add((OWLClassExpression)this.df.getOWLNothing());
        _codomain.addAll(Collections2.transform(this.signature.getConceptNames(), arg_0 -> ((OWLDataFactory)this.df).getOWLClass(arg_0)));
        if (Arrays.asList(constructors).contains((Object)Constructor.PRIMITIVE_NEGATION)) {
            _codomain.addAll(Collections2.transform(this.signature.getConceptNames(), conceptName -> this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLClass(conceptName))));
        }
        for (IRI roleName : this.signature.getRoleNames()) {
            block8: for (Constructor c : constructors) {
                switch (c) {
                    case EXISTENTIAL_RESTRICTION: {
                        _codomain.addAll(Collections2.transform(mmscs, mmsc -> this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName), mmsc)));
                        continue block8;
                    }
                    case VALUE_RESTRICTION: {
                        _codomain.addAll(Collections2.transform(mmscs, mmsc -> this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName), mmsc)));
                        continue block8;
                    }
                    case QUALIFIED_AT_LEAST_RESTRICTION: {
                        Stream.iterate(0, n -> n + 1).limit(maxCardinality).skip(2L).map(cardinality -> Collections2.transform((Collection)mmscs, mmsc -> this.df.getOWLObjectMinCardinality(cardinality.intValue(), (OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName), mmsc)).stream()).reduce(Stream::concat).ifPresent(stream -> _codomain.addAll(stream.collect(Collectors.toSet())));
                        continue block8;
                    }
                    case UNQUALIFIED_AT_MOST_RESTRICTION: {
                        Stream.iterate(0, n -> n + 1).limit(maxCardinality).map(cardinality -> this.df.getOWLObjectMaxCardinality(cardinality.intValue(), (OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName))).forEach(_codomain::add);
                        continue block8;
                    }
                    case EXISTENTIAL_SELF_RESTRICTION: {
                        _codomain.add((OWLClassExpression)this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.df.getOWLObjectProperty(roleName)));
                    }
                }
            }
        }
        return _codomain;
    }

    @Override
    protected final Set<Implication<IRI, OWLClassExpression>> getBackgroundImplications(Context<IRI, OWLClassExpression> inducedContext, OWLOntology backgroundOntology) {
        BiPredicate<OWLClassExpression, OWLClassExpression> subsumptionTest = backgroundOntology == null ? (concept1, concept2) -> ELReasoner.isSubsumedBy(concept1, concept2) : (concept1, concept2) -> ELReasoner.isSubsumedBy(concept1, concept2, backgroundOntology);
        HashSet<Implication<IRI, OWLClassExpression>> backgroundImplications = new HashSet<Implication<IRI, OWLClassExpression>>();
        for (OWLClassExpression concept12 : inducedContext.colHeads()) {
            for (OWLClassExpression concept22 : inducedContext.colHeads()) {
                if (concept12.equals(concept22) || !subsumptionTest.test(concept12, concept22)) continue;
                backgroundImplications.add(new Implication(Collections.singleton(concept12), Collections.singleton(concept22), Collections.emptySet()));
            }
        }
        return backgroundImplications;
    }

    @Override
    public final OWLOntology computeTBoxBase(int roleDepth, int maxCardinality, OWLOntology backgroundOntology, Constructor ... constructors) throws OWLOntologyCreationException {
        this.checkRoleDepth(roleDepth);
        OWLOntologyManager om = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = om.createOntology();
        Context<IRI, OWLClassExpression> inducedContext = this.getInducedContext(this.domain, roleDepth, maxCardinality, constructors);
        Set backgroundImplications = this.getBackgroundImplications(inducedContext, backgroundOntology);
        NextClosures1C.ResultC<IRI, OWLClassExpression> result = NextClosures1C.computeWithBackgroundImplications(inducedContext, backgroundImplications, true);
        for (Map.Entry entry : result.implications.entrySet()) {
            om.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)this.df.getOWLSubClassOfAxiom(ELConceptDescription.of((OWLClassExpression)this.df.getOWLObjectIntersectionOf(entry.getKey())).clone().reduce().toOWLClassExpression(), ELConceptDescription.of((OWLClassExpression)this.df.getOWLObjectIntersectionOf(entry.getValue())).clone().reduce().toOWLClassExpression())));
        }
        return ontology;
    }

    private final SetList<ArrayList<IRI>> getFirstFunctions() {
        HashSetArrayList<ArrayList<IRI>> fs = new HashSetArrayList<ArrayList<IRI>>();
        for (IRI individual : this.getDomain()) {
            ArrayList<IRI> f = new ArrayList<IRI>();
            f.add(individual);
            fs.add(f);
        }
        return fs;
    }

    private final SetList<ArrayList<IRI>> getNextFunctions(SetList<ArrayList<IRI>> _fs) {
        HashSetArrayList<ArrayList<IRI>> fs = new HashSetArrayList<ArrayList<IRI>>();
        for (ArrayList arrayList : _fs) {
            for (IRI individual : this.getDomain()) {
                ArrayList<IRI> f = new ArrayList<IRI>(arrayList);
                f.add(individual);
                fs.add(f);
            }
        }
        return fs;
    }

    private final SetList<ArrayList<IRI>> getFunctions(int roleDepth) {
        SetList<ArrayList<IRI>> fs = new HashSetArrayList<ArrayList<IRI>>();
        fs.add(new ArrayList());
        for (int i = 0; i <= roleDepth; ++i) {
            fs = this.getNextFunctions(fs);
        }
        return fs;
    }

    private final boolean applies(ArrayList<IRI> f, Triple<Integer, IRI, Integer> t) {
        IRI d = f.get((Integer)t.getFirst());
        IRI r = (IRI)t.getSecond();
        IRI e = f.get((Integer)t.getThird());
        return this.roleNameExtensions.get((Object)r).contains(Pair.of(d, e));
    }

    public final SparseContext<ArrayList<IRI>, Triple<Integer, IRI, Integer>> getInducedRoleContext(int roleDepth) {
        SetList<ArrayList<IRI>> _domain = this.getFunctions(roleDepth + 1);
        HashSetArrayList<Triple> _codomain = new HashSetArrayList<Triple>();
        for (IRI roleName : this.signature.getRoleNames()) {
            for (int i = 2; i <= roleDepth; ++i) {
                for (int j = 1; j <= i; ++j) {
                    _codomain.add(new Triple((Object)j, (Object)roleName, (Object)(j + 1)));
                    if (i == 1) continue;
                    _codomain.add(new Triple((Object)1, (Object)roleName, (Object)(j + 1)));
                }
            }
        }
        SparseContext<ArrayList<IRI>, Triple<Integer, IRI, Integer>> inducedRoleContext = new SparseContext<ArrayList<IRI>, Triple<Integer, IRI, Integer>>(_domain, (SetList<Triple<Integer, IRI, Integer>>)_codomain, false);
        for (ArrayList arrayList : _domain) {
            for (Triple a : _codomain) {
                if (!this.applies(arrayList, (Triple<Integer, IRI, Integer>)a)) continue;
                inducedRoleContext.add(arrayList, (Triple<Integer, IRI, Integer>)a);
            }
        }
        return inducedRoleContext;
    }

    public final Set<OWLSubPropertyChainOfAxiom> getRoleInclusionBase(int roleDepth) {
        HashSet<OWLSubPropertyChainOfAxiom> base = new HashSet<OWLSubPropertyChainOfAxiom>();
        SparseContext<ArrayList<IRI>, Triple<Integer, IRI, Integer>> cxt = this.getInducedRoleContext(roleDepth);
        ClosureOperator<Triple<Integer, IRI, Integer>> clop = new ClosureOperator<Triple<Integer, IRI, Integer>>(){

            @Override
            public Set<Triple<Integer, IRI, Integer>> closure(Set<Triple<Integer, IRI, Integer>> set) {
                return set;
            }
        };
        NextClosures1.Result<ArrayList<IRI>, Triple<Integer, IRI, Integer>> result = NextClosures1.compute(cxt, true);
        for (Map.Entry e : result.implications.entrySet()) {
            Optional<Triple> opt;
            int j;
            ArrayList<Triple> chain = new ArrayList<Triple>(roleDepth);
            boolean chainEnded = false;
            for (int i = 1; !chainEnded || i <= roleDepth; ++i) {
                j = i;
                opt = e.getKey().parallelStream().filter(t -> ((Integer)t.getFirst()).equals(j) && ((Integer)t.getThird()).equals(j + 1)).findFirst();
                if (opt.isPresent()) {
                    chain.add(opt.get());
                    continue;
                }
                chainEnded = true;
            }
            if (!chain.isEmpty()) {
                System.out.println("found chain of size " + chain.size() + " " + chain);
            }
            j = chain.size() + 1;
            opt = e.getValue().parallelStream().filter(t -> ((Integer)t.getFirst()).equals(1) && ((Integer)t.getThird()).equals(j)).findFirst();
            Triple conclusion = opt.isPresent() ? opt.get() : null;
            if (conclusion == null) continue;
            List subProperty = chain.stream().map(t -> this.df.getOWLObjectProperty((IRI)t.getSecond())).collect(Collectors.toList());
            base.add(this.df.getOWLSubPropertyChainOfAxiom(subProperty, (OWLObjectPropertyExpression)this.df.getOWLObjectProperty((IRI)conclusion.getSecond())));
        }
        return base;
    }

    public final class Variable {
        final int index;

        public Variable(int index) {
            this.index = index;
        }
    }
}

