/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OWLMinimizer {
    public static final Reasoner r = OWLMinimizer.initializeReasoner();

    private static final Reasoner initializeReasoner() {
        try {
            return new Reasoner(OWLManager.createOWLOntologyManager().createOntology());
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final boolean isSubsumedBy(OWLClassExpression c1, OWLClassExpression c2) {
        return r.isEntailed((OWLAxiom)OWLManager.getOWLDataFactory().getOWLSubClassOfAxiom(c1, c2));
    }

    public static final boolean subsumes(OWLClassExpression c1, OWLClassExpression c2) {
        return OWLMinimizer.isSubsumedBy(c2, c1);
    }

    public static final <T> Set<T> filterMinimal(Set<T> elements, BiPredicate<T, T> predicate) {
        return elements.stream().filter(x -> !elements.stream().anyMatch(y -> !x.equals(y) && predicate.test(x, y))).collect(Collectors.toSet());
    }

    public static final <T> Set<T> filterMinimalParallel(Set<T> elements, BiPredicate<T, T> predicate) {
        return elements.parallelStream().filter(x -> !elements.parallelStream().anyMatch(y -> !x.equals(y) && predicate.test(x, y))).collect(Collectors.toSet());
    }

    public static final OWLClassExpression minimizeConjunction(OWLClassExpression classExpression) {
        if (classExpression instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf c = (OWLObjectIntersectionOf)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectIntersectionOf(OWLMinimizer.filterMinimal(c.getOperands(), OWLMinimizer::subsumes));
        }
        if (classExpression instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf c = (OWLObjectComplementOf)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectComplementOf(OWLMinimizer.minimizeConjunction(c.getOperand()));
        }
        if (classExpression instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom c = (OWLObjectSomeValuesFrom)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)c.getProperty(), OWLMinimizer.minimizeConjunction((OWLClassExpression)c.getFiller()));
        }
        if (classExpression instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom c = (OWLObjectAllValuesFrom)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)c.getProperty(), OWLMinimizer.minimizeConjunction((OWLClassExpression)c.getFiller()));
        }
        if (classExpression instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality c = (OWLObjectMinCardinality)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectMinCardinality(c.getCardinality(), (OWLObjectPropertyExpression)c.getProperty(), OWLMinimizer.minimizeConjunction((OWLClassExpression)c.getFiller()));
        }
        if (classExpression instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality c = (OWLObjectMaxCardinality)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectMaxCardinality(c.getCardinality(), (OWLObjectPropertyExpression)c.getProperty(), OWLMinimizer.minimizeConjunction((OWLClassExpression)c.getFiller()));
        }
        if (classExpression instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality c = (OWLObjectExactCardinality)classExpression;
            return OWLManager.getOWLDataFactory().getOWLObjectExactCardinality(c.getCardinality(), (OWLObjectPropertyExpression)c.getProperty(), OWLMinimizer.minimizeConjunction((OWLClassExpression)c.getFiller()));
        }
        return classExpression;
    }
}

