/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.dl;

import com.google.common.collect.Collections2;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import java.util.Arrays;
import org.semanticweb.owlapi.model.IRI;

public final class Signature {
    private final IRI baseIRI;
    private final SetList<IRI> conceptNames = new HashSetArrayList<IRI>();
    private final SetList<IRI> roleNames = new HashSetArrayList<IRI>();
    private final SetList<IRI> individualNames = new HashSetArrayList<IRI>();

    public Signature(IRI baseIRI) {
        this.baseIRI = baseIRI;
    }

    public final IRI getBaseIRI() {
        return this.baseIRI;
    }

    public final SetList<IRI> getConceptNames() {
        return this.conceptNames;
    }

    public final SetList<IRI> getRoleNames() {
        return this.roleNames;
    }

    public final SetList<IRI> getIndividualNames() {
        return this.individualNames;
    }

    public final boolean addConceptNames(IRI ... conceptNames) {
        return this.conceptNames.addAll(Arrays.asList(conceptNames));
    }

    public final boolean addConceptNames(String ... conceptNames) {
        return this.conceptNames.addAll(Collections2.transform(Arrays.asList(conceptNames), IRI::create));
    }

    public final boolean addRoleNames(IRI ... roleNames) {
        return this.roleNames.addAll(Arrays.asList(roleNames));
    }

    public final boolean addRoleNames(String ... roleNames) {
        return this.roleNames.addAll(Collections2.transform(Arrays.asList(roleNames), IRI::create));
    }

    public final boolean addIndividualNames(IRI ... individualNames) {
        return this.individualNames.addAll(Arrays.asList(individualNames));
    }

    public final boolean addIndividualNames(String ... individualNames) {
        return this.individualNames.addAll(Collections2.transform(Arrays.asList(individualNames), IRI::create));
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return this.getConceptNames().equals(other.getConceptNames()) && this.getRoleNames().equals(other.getRoleNames()) && this.getIndividualNames().equals(other.getIndividualNames());
    }

    public final int hashCode() {
        return 17 + 23 * this.conceptNames.hashCode() + 29 * this.roleNames.hashCode() + 31 * this.individualNames.hashCode();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   concept names: " + this.conceptNames.toString() + "\r\n");
        sb.append("      role names: " + this.roleNames.toString() + "\r\n");
        sb.append("individual names: " + this.individualNames.toString() + "\r\n");
        return sb.toString();
    }
}

