/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.exporter;

import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javafx.geometry.Point3D;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class CFXExporter<G, M> {
    public static <G, M> void export(MatrixContext<G, M> context, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, AdditiveConceptLayout<G, M> layout, File file) {
        Document xml = new Document("");
        Element domainEl = xml.appendElement("domain");
        domainEl.attr("size", String.valueOf(context.rowHeads().size()));
        for (int domainIndex = 0; domainIndex < context.rowHeads().size(); ++domainIndex) {
            int permIndex = domainPermutation == null || !domainPermutation.containsKey(domainIndex) ? domainIndex : domainPermutation.get(domainIndex);
            Object object = context.rowHeads().get(permIndex);
            Element objectEl = domainEl.appendElement("object");
            objectEl.attr("index", String.valueOf(permIndex));
            objectEl.attr("name", object.toString());
            objectEl.attr("selected", "true");
        }
        Element codomainEl = xml.appendElement("codomain");
        codomainEl.attr("size", String.valueOf(context.colHeads().size()));
        for (int codomainIndex = 0; codomainIndex < context.colHeads().size(); ++codomainIndex) {
            int permIndex = codomainPermutation == null || !codomainPermutation.containsKey(codomainIndex) ? codomainIndex : codomainPermutation.get(codomainIndex);
            Object attribute = context.colHeads().get(permIndex);
            Element attributeEl = codomainEl.appendElement("attribute");
            attributeEl.attr("index", String.valueOf(permIndex));
            attributeEl.attr("name", attribute.toString());
            attributeEl.attr("selected", String.valueOf(context.selectedAttributes().contains(attribute)));
        }
        Element contextEl = xml.appendElement("context");
        for (int domainIndex = 0; domainIndex < context.rowHeads().size(); ++domainIndex) {
            int dpermIndex = domainPermutation == null || !domainPermutation.containsKey(domainIndex) ? domainIndex : domainPermutation.get(domainIndex);
            Object object = context.rowHeads().get(dpermIndex);
            for (int codomainIndex = 0; codomainIndex < context.colHeads().size(); ++codomainIndex) {
                Element arrowsEl;
                int cpermIndex = codomainPermutation == null || !codomainPermutation.containsKey(codomainIndex) ? codomainIndex : codomainPermutation.get(codomainIndex);
                Object attribute = context.colHeads().get(cpermIndex);
                if (context._contains(dpermIndex, cpermIndex)) {
                    Element incidenceEl = contextEl.appendElement("incidence");
                    incidenceEl.attr("object", object.toString());
                    incidenceEl.attr("attribute", attribute.toString());
                    continue;
                }
                boolean upArrow = context.UpArrows.contains(object, attribute);
                boolean downArrow = context.DownArrows.contains(object, attribute);
                if (upArrow && downArrow) {
                    arrowsEl = contextEl.appendElement("both-arrows");
                    arrowsEl.attr("object", object.toString());
                    arrowsEl.attr("attribute", attribute.toString());
                    continue;
                }
                if (upArrow) {
                    arrowsEl = contextEl.appendElement("up-arrow");
                    arrowsEl.attr("object", object.toString());
                    arrowsEl.attr("attribute", attribute.toString());
                    continue;
                }
                if (!downArrow) continue;
                arrowsEl = contextEl.appendElement("down-arrow");
                arrowsEl.attr("object", object.toString());
                arrowsEl.attr("attribute", attribute.toString());
            }
        }
        Element latticeEl = xml.appendElement("lattice");
        for (Map.Entry attributeSeed : layout.seedsM.entrySet()) {
            Element seedEl = latticeEl.appendElement("attribute-seed");
            seedEl.attr("attribute", attributeSeed.getKey().toString());
            seedEl.attr("x", String.valueOf(((Point3D)attributeSeed.getValue()).getX()));
            seedEl.attr("y", String.valueOf(((Point3D)attributeSeed.getValue()).getY()));
            seedEl.attr("z", String.valueOf(((Point3D)attributeSeed.getValue()).getZ()));
        }
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.mkdirs();
                }
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(xml.toString());
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write CFX-File to " + file.toString());
            e.printStackTrace();
        }
    }
}

