/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.exporter;

import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.beans.binding.Binding;
import javafx.geometry.Point3D;
import javax.imageio.ImageIO;

public class PNGExporter<G, M> {
    public static <G, M> void export(MatrixContext<G, M> context, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, AdditiveConceptLayout<G, M> layout, boolean exportArrows, boolean exportLabels, File file) {
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.mkdirs();
                }
                file.createNewFile();
            }
            BufferedImage img = PNGExporter.toBufferedImage(file.getName(), context, domainPermutation, codomainPermutation, layout, exportArrows, exportLabels);
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (IOException e) {
            System.err.println("Unable to create or write GraphicsBuffer to file " + file);
            e.printStackTrace();
        }
    }

    private static <G, M> BufferedImage toBufferedImage(String name, MatrixContext<G, M> formalContext, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, AdditiveConceptLayout<G, M> layout, boolean exportArrows, boolean exportLabels) {
        int i;
        double width = 100.0 * layout.getCurrentBoundingBox(false, false).getWidth();
        double minX = 100.0 * layout.getCurrentBoundingBox(false, false).getMinX();
        double height = 100.0 * layout.getCurrentBoundingBox(false, false).getHeight();
        int border = 100;
        int circleSize = 20;
        boolean textOffset = false;
        BufferedImage img = new BufferedImage((int)width + 100, (int)height + 100, 1);
        Graphics2D gfx = img.createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gfx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        gfx.setBackground(Color.WHITE);
        gfx.setColor(Color.WHITE);
        gfx.fillRect(0, 0, (int)width + 100, (int)height + 100);
        gfx.setColor(Color.BLACK);
        for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
            Concept conceptNode = (Concept)layout.lattice.rowHeads().get(i);
            double x = 100.0 * ((Point3D)((Binding)layout.getPosition(conceptNode)).getValue()).getX();
            double y = 100.0 * ((Point3D)((Binding)layout.getPosition(conceptNode)).getValue()).getY();
            gfx.fillOval((int)(x - minX) - 10 + 50, (int)y - 10 + 50, 20, 20);
        }
        for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
            for (int j = 0; j < layout.lattice.rowHeads().size(); ++j) {
                if (!layout.lattice._contains(i, j)) continue;
                int x1 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getX() - minX + 50.0);
                int y1 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getY() + 50.0);
                int x2 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(j))).getValue()).getX() - minX + 50.0);
                int y2 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(j))).getValue()).getY() + 50.0);
                gfx.drawLine(x1, y1, x2, y2);
            }
        }
        if (exportLabels) {
            for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
                Concept conceptNode = (Concept)layout.lattice.rowHeads().get(i);
                String objLabels = layout.lattice.objectLabels(conceptNode).toString().substring(1, layout.lattice.objectLabels(conceptNode).toString().length() - 1);
                String attLabels = layout.lattice.attributeLabels(conceptNode).toString().substring(1, layout.lattice.attributeLabels(conceptNode).toString().length() - 1);
                int x = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getX() - minX);
                int y = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getY());
                int owidth = gfx.getFontMetrics().stringWidth(objLabels);
                int awidth = gfx.getFontMetrics().stringWidth(attLabels);
                int theight = gfx.getFontMetrics().getHeight();
                gfx.drawString(objLabels, x + 50 - owidth / 2, y + 20 + 50 + theight / 2);
                gfx.drawString(attLabels, x + 50 - awidth / 2, y - 20 + 50);
            }
        }
        gfx.dispose();
        return img;
    }
}

