/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.exporter;

import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javafx.beans.binding.Binding;
import javafx.geometry.Point3D;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGExporter<G, M> {
    public static <G, M> void export(MatrixContext<G, M> context, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, AdditiveConceptLayout<G, M> layout, boolean exportArrows, boolean exportLabels, File file) {
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.mkdirs();
                }
                file.createNewFile();
            }
            Document doc = SVGExporter.toSVGDocument(file.getName(), context, domainPermutation, codomainPermutation, layout, exportArrows, exportLabels);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(new FileOutputStream(file));
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
        catch (IOException | TransformerException | TransformerFactoryConfigurationError e) {
            System.err.println("Unable to create or write SVGDocument to file " + file);
            e.printStackTrace();
        }
    }

    private static <G, M> Document toSVGDocument(String name, MatrixContext<G, M> formalContext, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, AdditiveConceptLayout<G, M> layout, boolean exportArrows, boolean exportLabels) {
        int i;
        double width = 100.0 * layout.getCurrentBoundingBox(false, false).getWidth();
        double minX = 100.0 * layout.getCurrentBoundingBox(false, false).getMinX();
        double height = 100.0 * layout.getCurrentBoundingBox(false, false).getHeight();
        int border = 100;
        int circleSize = 16;
        int textOffset = 12;
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", String.valueOf((int)width + 100));
        svgRoot.setAttributeNS(null, "height", String.valueOf((int)height + 100));
        for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
            for (int j = 0; j < layout.lattice.rowHeads().size(); ++j) {
                if (!layout.lattice._contains(i, j)) continue;
                int x1 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getX() - minX + 50.0);
                int y1 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getY() + 50.0);
                int x2 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(j))).getValue()).getX() - minX + 50.0);
                int y2 = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(j))).getValue()).getY() + 50.0);
                Element line = doc.createElementNS(svgNS, "line");
                line.setAttributeNS(null, "x1", String.valueOf(x1));
                line.setAttributeNS(null, "y1", String.valueOf(y1));
                line.setAttributeNS(null, "x2", String.valueOf(x2));
                line.setAttributeNS(null, "y2", String.valueOf(y2));
                line.setAttributeNS(null, "stroke-width", "4");
                line.setAttributeNS(null, "stroke", "grey");
                svgRoot.appendChild(line);
            }
        }
        for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
            Concept conceptNode = (Concept)layout.lattice.rowHeads().get(i);
            double x = 100.0 * ((Point3D)((Binding)layout.getPosition(conceptNode)).getValue()).getX();
            double y = 100.0 * ((Point3D)((Binding)layout.getPosition(conceptNode)).getValue()).getY();
            Element circle = doc.createElementNS(svgNS, "circle");
            circle.setAttributeNS(null, "cx", String.valueOf((int)(x - minX) + 50));
            circle.setAttributeNS(null, "cy", String.valueOf((int)y + 50));
            circle.setAttributeNS(null, "r", String.valueOf(16));
            svgRoot.appendChild(circle);
        }
        if (exportLabels) {
            for (i = 0; i < layout.lattice.rowHeads().size(); ++i) {
                Concept conceptNode = (Concept)layout.lattice.rowHeads().get(i);
                String objLabels = layout.lattice.objectLabels(conceptNode).toString().substring(1, layout.lattice.objectLabels(conceptNode).toString().length() - 1);
                String attLabels = layout.lattice.attributeLabels(conceptNode).toString().substring(1, layout.lattice.attributeLabels(conceptNode).toString().length() - 1);
                int x = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getX() - minX);
                int y = (int)(100.0 * ((Point3D)((Binding)layout.getPosition((Concept)layout.lattice.rowHeads().get(i))).getValue()).getY());
                int ox = x + 50;
                int oy = y + 28 + 50 + 10;
                int ax = x + 50;
                int ay = y - 28 + 50;
                Element objText = doc.createElementNS(svgNS, "text");
                objText.setAttributeNS(null, "x", String.valueOf(ox));
                objText.setAttributeNS(null, "y", String.valueOf(oy));
                objText.setAttributeNS(null, "text-anchor", "middle");
                objText.setTextContent(objLabels);
                svgRoot.appendChild(objText);
                Element attText = doc.createElementNS(svgNS, "text");
                attText.setAttributeNS(null, "x", String.valueOf(ax));
                attText.setAttributeNS(null, "y", String.valueOf(ay));
                attText.setAttributeNS(null, "text-anchor", "middle");
                attText.setTextContent(attLabels);
                svgRoot.appendChild(attText);
            }
        }
        return doc;
    }
}

