/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.exporter;

import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javafx.beans.binding.Binding;
import javafx.geometry.Point3D;

public class TeXExporter<G, M> {
    private final MatrixContext<G, M> formalContext;
    private final Map<Integer, Integer> objectPermutation;
    private final Map<Integer, Integer> attributePermutation;
    private final AdditiveConceptLayout<G, M> conceptLayout;
    private final TeXOptions teXOptions;
    private final StringBuffer buffer = new StringBuffer();

    public TeXExporter(MatrixContext<G, M> formalContext, Map<Integer, Integer> objectPermutation, Map<Integer, Integer> attributePermutation, AdditiveConceptLayout<G, M> conceptLayout, TeXOptions teXOptions) {
        this.formalContext = formalContext;
        this.objectPermutation = objectPermutation;
        this.attributePermutation = attributePermutation;
        this.conceptLayout = conceptLayout;
        this.teXOptions = teXOptions;
    }

    public final void export() throws IOException {
        BufferedWriter writer = this.createFile();
        this.newLine();
        if (this.teXOptions.standAlone) {
            this.appendHeader();
            this.newLine();
            this.newLine();
        }
        switch (this.teXOptions.contextTeXPackage) {
            case None: {
                break;
            }
            case Ganter: {
                this.appendGanterContext();
                break;
            }
            case Tabular: {
                this.appendTabularContext();
            }
        }
        this.newLine();
        this.newLine();
        switch (this.teXOptions.diagramTeXPackage) {
            case None: {
                break;
            }
            case Ganter: {
                this.appendGanterDiagram();
                break;
            }
            case ConExpFX: {
                this.appendConExpFXDiagram();
            }
        }
        this.newLine();
        this.newLine();
        if (this.teXOptions.standAlone) {
            this.appendFooter();
            this.newLine();
            this.newLine();
        }
        writer.append(this.buffer);
        writer.close();
    }

    private final BufferedWriter createFile() throws IOException {
        if (!this.teXOptions.file.exists()) {
            if (!this.teXOptions.file.getParentFile().exists()) {
                this.teXOptions.file.mkdirs();
            }
            this.teXOptions.file.createNewFile();
        }
        return new BufferedWriter(new FileWriter(this.teXOptions.file));
    }

    private final void append(String string) {
        this.buffer.append(string);
    }

    private final void newLine() {
        this.append("\r\n");
    }

    private final void appendHeader() {
    }

    private final void appendFooter() {
    }

    private final void appendGanterContext() {
        this.append("\\begin{cxt}\r\n\\cxtName{" + this.teXOptions.file.getName() + "}\r\n");
        int js = this.formalContext.colHeads().size();
        int is = this.formalContext.rowHeads().size();
        for (int j = 0; j < js; ++j) {
            int jj = this.attributePermutation == null || !this.attributePermutation.containsKey(j) ? j : this.attributePermutation.get(j);
            Object m = this.formalContext.colHeads().get(jj);
            this.append("\\atr{" + (this.teXOptions.labels ? m : "") + "}\r\n");
        }
        for (int i = 0; i < is; ++i) {
            int ii = this.objectPermutation == null || !this.objectPermutation.containsKey(i) ? i : this.objectPermutation.get(i);
            Object g = this.formalContext.rowHeads().get(ii);
            String incidences = "";
            for (int j = 0; j < js; ++j) {
                int jj = this.attributePermutation == null || !this.attributePermutation.containsKey(j) ? j : this.attributePermutation.get(j);
                Object m = this.formalContext.colHeads().get(jj);
                if (this.formalContext.contains(g, m)) {
                    incidences = incidences + "X";
                    continue;
                }
                if (this.teXOptions.arrows) {
                    boolean isDownArrow = this.formalContext.DownArrows.contains(g, m);
                    boolean isUpArrow = this.formalContext.UpArrows.contains(g, m);
                    if (isDownArrow) {
                        if (isUpArrow) {
                            incidences = incidences + "b";
                            continue;
                        }
                        incidences = incidences + "d";
                        continue;
                    }
                    if (isUpArrow) {
                        incidences = incidences + "u";
                        continue;
                    }
                    incidences = incidences + ".";
                    continue;
                }
                incidences = incidences + ".";
            }
            this.append("\\obj{" + incidences + "}{" + (this.teXOptions.labels ? g : "") + "}\r\n");
        }
        this.append("\\end{cxt}\r\n");
    }

    private final void appendTabularContext() {
        int is = this.formalContext.rowHeads().size();
        int js = this.formalContext.colHeads().size();
        this.append("{\\setlength{\\tabcolsep}{1pt}");
        this.newLine();
        if (js == 0) {
            this.append("\\begin{tabular}{r@{\\hspace{3pt}}|}");
        } else if (js == 1) {
            this.append("\\begin{tabular}{r@{\\hspace{3pt}}| c|}");
        } else {
            this.append("\\begin{tabular}{r@{\\hspace{3pt}}| *{" + (js - 1) + "}{c} c|}");
        }
        this.newLine();
        this.append("\\multicolumn{1}{c}{}");
        this.newLine();
        for (int j = 0; j < js; ++j) {
            int jj = this.attributePermutation == null || !this.attributePermutation.containsKey(j) ? j : this.attributePermutation.get(j);
            Object m = this.formalContext.colHeads().get(jj);
            this.append("&\\multicolumn{1}{c}{\\begin{turn}{90}" + (this.teXOptions.labels ? m : "") + "\\end{turn}}");
            this.newLine();
        }
        this.append("\\\\ \\cline{2-" + (js + 1) + "}");
        this.newLine();
        for (int i = 0; i < is; ++i) {
            int ii = this.objectPermutation == null || !this.objectPermutation.containsKey(i) ? i : this.objectPermutation.get(i);
            Object g = this.formalContext.rowHeads().get(ii);
            this.append((this.teXOptions.labels ? g : "") + "");
            for (int j = 0; j < js; ++j) {
                int jj = this.attributePermutation == null || !this.attributePermutation.containsKey(j) ? j : this.attributePermutation.get(j);
                Object m = this.formalContext.colHeads().get(jj);
                if (this.formalContext.contains(g, m)) {
                    this.append("& $\\times$ ");
                    continue;
                }
                if (this.teXOptions.arrows) {
                    boolean isDownArrow = this.formalContext.DownArrows.contains(g, m);
                    boolean isUpArrow = this.formalContext.UpArrows.contains(g, m);
                    if (isDownArrow) {
                        if (isUpArrow) {
                            this.append("& $\\Doppelpfeil$ ");
                            continue;
                        }
                        this.append("& $\\Runterpfeil$ ");
                        continue;
                    }
                    if (isUpArrow) {
                        this.append("& $\\Hochpfeil$ ");
                        continue;
                    }
                    this.append("& $\\cdot$ ");
                    continue;
                }
                this.append("& $\\cdot$ ");
            }
            if (i == is - 1) {
                this.append("\\\\ \\cline{2-" + (js + 1) + "}");
            } else {
                this.append("\\\\");
            }
            this.newLine();
        }
        this.append("\\end{tabular}}");
        this.newLine();
    }

    private final void appendGanterDiagram() {
        int i;
        double width = this.conceptLayout.getCurrentBoundingBox(false, false).getWidth();
        double minX = this.conceptLayout.getCurrentBoundingBox(false, false).getMinX();
        double height = this.conceptLayout.getCurrentBoundingBox(false, false).getHeight();
        double w = this.teXOptions.scale.widthFactor(width, height);
        double h = this.teXOptions.scale.heightFactor(width, height);
        double unit = this.teXOptions.scale.scale == ScaleEnum.FitHeight ? h : (this.teXOptions.scale.scale == ScaleEnum.FitWidth ? w : Math.min(w, h));
        this.append("\\begin{diagram}{" + width + "}{" + height + "}\r\n");
        this.append("\\unitlength " + unit + "mm\r\n");
        this.append("\\CircleSize{1}\r\n");
        this.append("\\NodeThickness{1pt}\r\n");
        this.append("\\EdgeThickness{1pt}\r\n");
        for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
            Concept concept = (Concept)this.conceptLayout.lattice.rowHeads().get(i);
            double x = ((Point3D)((Binding)this.conceptLayout.getPosition(concept)).getValue()).getX();
            double y = ((Point3D)((Binding)this.conceptLayout.getPosition(concept)).getValue()).getY();
            this.append("\\Node{" + i + "}{" + (x - minX) + "}{" + (height - y) + "}\r\n");
        }
        for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
            for (int j = 0; j < this.conceptLayout.lattice.rowHeads().size(); ++j) {
                if (!this.conceptLayout.lattice._contains(i, j)) continue;
                this.append("\\Edge{" + i + "}{" + j + "}\r\n");
            }
        }
        if (this.teXOptions.labels) {
            for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
                Concept concept = (Concept)this.conceptLayout.lattice.rowHeads().get(i);
                String objLabels = this.conceptLayout.lattice.objectLabels(concept).toString().substring(1, this.conceptLayout.lattice.objectLabels(concept).toString().length() - 1).trim();
                String attLabels = this.conceptLayout.lattice.attributeLabels(concept).toString().substring(1, this.conceptLayout.lattice.attributeLabels(concept).toString().length() - 1).trim();
                if (!objLabels.isEmpty()) {
                    this.append("\\centerObjbox{" + i + "}{0}{1}{" + objLabels + "}\r\n");
                }
                if (attLabels.isEmpty()) continue;
                this.append("\\centerAttbox{" + i + "}{0}{1}{" + attLabels + "}\r\n");
            }
        }
        this.append("\\end{diagram}\r\n");
    }

    private final void appendConExpFXDiagram() {
        int i;
        double width = this.conceptLayout.getCurrentBoundingBox(false, false).getWidth();
        double height = this.conceptLayout.getCurrentBoundingBox(false, false).getHeight();
        double minX = this.conceptLayout.getCurrentBoundingBox(false, false).getMinX();
        double w = this.teXOptions.scale.widthFactor(width, height);
        double h = this.teXOptions.scale.heightFactor(width, height);
        this.append("\\begin{conceptdiagram}[x=" + w + "mm, y=" + h + "mm]\r\n");
        this.append("\\setlength{\\nodesize}{3mm}\r\n");
        this.append("\\setlength{\\edgewidth}{0.4pt}\r\n");
        this.append("\\setlength{\\labeldistance}{1pt}\r\n");
        for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
            Concept concept = (Concept)this.conceptLayout.lattice.rowHeads().get(i);
            double x = ((Point3D)((Binding)this.conceptLayout.getPosition(concept)).getValue()).getX();
            double y = ((Point3D)((Binding)this.conceptLayout.getPosition(concept)).getValue()).getY();
            this.append("\\conceptnode{" + i + "}{" + (x - minX) + "}{" + (height - y) + "}\r\n");
        }
        for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
            for (int j = 0; j < this.conceptLayout.lattice.rowHeads().size(); ++j) {
                if (!this.conceptLayout.lattice._contains(i, j)) continue;
                this.append("\\conceptedge{" + i + "}{" + j + "}\r\n");
            }
        }
        if (this.teXOptions.labels) {
            for (i = 0; i < this.conceptLayout.lattice.rowHeads().size(); ++i) {
                Concept concept = (Concept)this.conceptLayout.lattice.rowHeads().get(i);
                String objLabels = this.conceptLayout.lattice.objectLabels(concept).toString().substring(1, this.conceptLayout.lattice.objectLabels(concept).toString().length() - 1).trim();
                String attLabels = this.conceptLayout.lattice.attributeLabels(concept).toString().substring(1, this.conceptLayout.lattice.attributeLabels(concept).toString().length() - 1).trim();
                if (!attLabels.isEmpty()) {
                    this.append("\\attributelabel{" + i + "}{" + attLabels + "}\r\n");
                }
                if (objLabels.isEmpty()) continue;
                this.append("\\objectlabel{" + i + "}{" + objLabels + "}\r\n");
            }
        }
        this.append("\\end{conceptdiagram}\r\n");
    }

    public static enum DiagramTeXPackage {
        None,
        Ganter,
        ConExpFX;

    }

    public static enum ContextTeXPackage {
        None,
        Ganter,
        Tabular;

    }

    public static final class TeXOptions {
        public File file = null;
        public boolean arrows = false;
        public boolean labels = true;
        public boolean standAlone = false;
        public ContextTeXPackage contextTeXPackage = ContextTeXPackage.Tabular;
        public DiagramTeXPackage diagramTeXPackage = DiagramTeXPackage.ConExpFX;
        public ScaleOption scale = null;

        public TeXOptions(File file, boolean arrows, boolean labels, boolean standAlone, ContextTeXPackage contextTeXPackage, DiagramTeXPackage diagramTeXPackage, ScaleOption scale) {
            this.file = file;
            this.arrows = arrows;
            this.labels = labels;
            this.standAlone = standAlone;
            this.contextTeXPackage = contextTeXPackage;
            this.diagramTeXPackage = diagramTeXPackage;
            this.scale = scale;
        }
    }

    public static final class FitWidthScale
    extends ScaleOption {
        public FitWidthScale(int widthInMillimeter) {
            this.scale = ScaleEnum.FitWidth;
            this.widthInMillimeter = widthInMillimeter;
        }

        @Override
        public final double widthFactor(double dWidth, double dHeight) {
            return this.widthInMillimeter / dWidth;
        }

        @Override
        public final double heightFactor(double dWidth, double dHeight) {
            return this.widthFactor(dWidth, dHeight);
        }
    }

    public static final class FitHeightScale
    extends ScaleOption {
        public FitHeightScale(int heightInMillimeter) {
            this.scale = ScaleEnum.FitHeight;
            this.heightInMillimeter = heightInMillimeter;
        }

        @Override
        public final double widthFactor(double dWidth, double dHeight) {
            return this.heightFactor(dWidth, dHeight);
        }

        @Override
        public final double heightFactor(double dWidth, double dHeight) {
            return this.heightInMillimeter / dHeight;
        }
    }

    public static final class FitRatioScale
    extends ScaleOption {
        public FitRatioScale(int widthInMillimeter, int heightInMillimeter) {
            this.scale = ScaleEnum.FitRatio;
            this.widthInMillimeter = widthInMillimeter;
            this.heightInMillimeter = heightInMillimeter;
        }

        @Override
        public final double widthFactor(double dWidth, double dHeight) {
            double w = this.widthInMillimeter / dWidth;
            double h = this.heightInMillimeter / dHeight;
            return Math.min(w, h);
        }

        @Override
        public final double heightFactor(double dWidth, double dHeight) {
            return this.widthFactor(dWidth, dHeight);
        }
    }

    public static final class FitScale
    extends ScaleOption {
        public FitScale(int widthInMillimeter, int heightInMillimeter) {
            this.scale = ScaleEnum.Fit;
            this.widthInMillimeter = widthInMillimeter;
            this.heightInMillimeter = heightInMillimeter;
        }

        @Override
        public final double widthFactor(double dWidth, double dHeight) {
            return this.widthInMillimeter / dWidth;
        }

        @Override
        public final double heightFactor(double dWidth, double dHeight) {
            return this.heightInMillimeter / dHeight;
        }
    }

    public static abstract class ScaleOption {
        protected ScaleEnum scale;
        protected double widthInMillimeter;
        protected double heightInMillimeter;

        public abstract double widthFactor(double var1, double var3);

        public abstract double heightFactor(double var1, double var3);
    }

    public static enum ScaleEnum {
        Fit,
        FitWidth,
        FitHeight,
        FitRatio;


        public ScaleOption toOption(int w, int h) {
            switch (this) {
                case Fit: {
                    return new FitScale(w, h);
                }
                case FitWidth: {
                    return new FitWidthScale(w);
                }
                case FitHeight: {
                    return new FitHeightScale(h);
                }
                case FitRatio: {
                    return new FitRatioScale(w, h);
                }
            }
            return null;
        }
    }
}

