/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.importer;

import conexp.fx.core.context.MatrixContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point3D;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class CEXImporter {
    public static void importt(MatrixContext<String, String> _context, Map<String, Point3D> seedMap, File file) {
        try {
            Element xml = Jsoup.parse((File)file, null).body();
            Element context = xml.getElementsByTag("ConceptualSystem").first().getElementsByTag("Contexts").first().getElementsByTag("Context").first();
            Element attributes = context.getElementsByTag("Attributes").first();
            Element objects = context.getElementsByTag("Objects").first();
            HashMap<Integer, String> attIdMap = new HashMap<Integer, String>();
            for (Element attributeEl : attributes.getElementsByTag("Attribute")) {
                Integer id = Integer.valueOf(attributeEl.attr("Identifier"));
                String attribute = attributeEl.getElementsByTag("Name").first().text();
                attIdMap.put(id, attribute);
                _context.colHeads().add(attribute);
            }
            int i = 0;
            for (Element objectEl : objects.getElementsByTag("Object")) {
                String object = objectEl.getElementsByTag("Name").first().text();
                _context.rowHeads().add(object);
                System.out.println(i++ + "reading object " + object);
                for (Element hasAttributeEl : objectEl.getElementsByTag("Intent").first().getElementsByTag("HasAttribute")) {
                    _context.addFastSilent(object, attIdMap.get(Integer.valueOf(hasAttributeEl.attr("AttributeIdentifier"))));
                }
            }
            _context.pushAllChangedEvent();
        }
        catch (IOException e) {
            System.err.println("Unable to parse Concept Explorer file from " + file.toString());
            e.printStackTrace();
        }
    }
}

