/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.importer;

import conexp.fx.core.context.MatrixContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class CSVImporter {
    private final File file;
    private final String delimiter;
    private final List<String[]> tuples;

    public static final List<String[]> getTuples(File file) {
        CSVImporter csvImporter = new CSVImporter(file);
        csvImporter.readFile();
        return csvImporter.getTuples();
    }

    public static final List<String[]> getTuples(File file, String delimiter) {
        CSVImporter csvImporter = new CSVImporter(file, delimiter);
        csvImporter.readFile();
        return csvImporter.getTuples();
    }

    public static final void importContext(File file, MatrixContext<String, String> context, String delimiter) throws Exception {
        CSVImporter csvImporter = new CSVImporter(file, delimiter);
        csvImporter.readFile();
        csvImporter.toContext2(context);
    }

    public CSVImporter(File file) {
        this(file, ",");
    }

    public CSVImporter(File file, String delimiter) {
        this.file = file;
        this.delimiter = delimiter;
        this.tuples = new LinkedList<String[]>();
    }

    public final void readFile() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            Iterator it = reader.lines().iterator();
            while (it.hasNext()) {
                String[] tuple = ((String)it.next()).split(this.delimiter);
                if (tuple.length <= 0) continue;
                this.tuples.add(tuple);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final List<String[]> getTuples() {
        return this.tuples;
    }

    public final void toContext2(MatrixContext<String, String> context) {
        for (String[] row : this.tuples) {
            context.add(row[0], row[1]);
        }
    }

    public final void toContext(MatrixContext<String, String> context) throws Exception {
        String[][] array = (String[][])this.tuples.toArray((T[])new String[0][]);
        int rows = array.length - 1;
        int cols = array[0].length - 2;
        LinkedList<String> objects = new LinkedList<String>();
        LinkedList<String> attributes = new LinkedList<String>();
        for (int r = 1; r < rows + 1; ++r) {
            objects.add("(" + array[r][0] + "," + array[r][1] + ")");
        }
        String[] header = array[0];
        for (int c = 2; c < cols + 2; ++c) {
            if (attributes.contains(header[c])) {
                throw new Exception("Duplicate attribute name.");
            }
            attributes.add(header[c]);
        }
        context.rowHeads().addAll(objects);
        context.colHeads().addAll(attributes);
        for (int r = 1; r < rows + 1; ++r) {
            for (int c = 2; c < cols + 2; ++c) {
                if (!Integer.valueOf(array[r][c].trim()).equals(1)) continue;
                context.matrix().setBoolean(true, new long[]{r - 1, c - 2});
            }
        }
    }

    public final MatrixContext<String, String> toContext() throws Exception {
        MatrixContext<String, String> context = new MatrixContext<String, String>(false);
        this.toContext(context);
        return context;
    }
}

