/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.importer;

import conexp.fx.core.context.MatrixContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.ujmp.core.booleanmatrix.BooleanMatrix;

public class CXTImporter {
    public static final MatrixContext<String, String> read(File file) throws IOException {
        MatrixContext<String, String> cxt = new MatrixContext<String, String>(false);
        CXTImporter.read(cxt, file);
        return cxt;
    }

    public static final void read(MatrixContext<String, String> context, File file) throws IOException {
        if (!context.id.isBound()) {
            context.id.set((Object)file.getName());
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Iterator lineIterator = reader.lines().iterator();
        String[] firstLines = new String[5];
        int i = 0;
        while (lineIterator.hasNext() && i < 5) {
            firstLines[i++] = (String)lineIterator.next();
        }
        int rows = Integer.valueOf(firstLines[2]);
        int cols = Integer.valueOf(firstLines[3]);
        ArrayList objs = new ArrayList(rows);
        ArrayList atts = new ArrayList(cols);
        while (lineIterator.hasNext() && i < 5 + rows) {
            objs.add(lineIterator.next());
            ++i;
        }
        while (lineIterator.hasNext() && i < 5 + rows + cols) {
            atts.add(lineIterator.next());
            ++i;
        }
        context.rowHeads().addAll(objs);
        context.colHeads().addAll(atts);
        BooleanMatrix mat = context.matrix();
        while (lineIterator.hasNext() && i < 5 + rows + cols + rows) {
            char[] line = ((String)lineIterator.next()).toCharArray();
            int row = i - 5 - rows - cols;
            for (int col = 0; col < cols; ++col) {
                mat.setBoolean(line[col] == 'X' || line[col] == 'x', new long[]{row, col});
            }
            ++i;
        }
        reader.close();
    }
}

