/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.importer;

import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.dl.OWLInterpretation;
import conexp.fx.core.dl.Signature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLParser;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticweb.owlapi.model.IRI;

public class RDFImporter {
    public static final void readCSV(Repository repository, File file) throws RepositoryException, RDFParseException, IOException {
        RepositoryConnection connection = repository.getConnection();
        ValueFactoryImpl f = new ValueFactoryImpl();
        Files.lines(file.toPath()).map(line -> line.split(";")).map(arg_0 -> RDFImporter.lambda$readCSV$1((ValueFactory)f, file, arg_0)).forEach(statement -> {
            try {
                connection.add((Statement)statement, new Resource[0]);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        });
        connection.commit();
        connection.close();
    }

    public static final Repository read(File file) throws RepositoryException, RDFParseException, IOException {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        RDFImporter.read((Repository)repository, file);
        return repository;
    }

    public static final void read(Repository repository, File file) throws RepositoryException, RDFParseException, IOException {
        RepositoryConnection connection = repository.getConnection();
        connection.add(file, null, RDFFormat.forFileName((String)file.getName(), (RDFFormat)RDFFormat.RDFXML), new Resource[0]);
        connection.commit();
        connection.close();
    }

    public static final Repository read(URL url) throws RepositoryException, RDFParseException, IOException {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        RDFImporter.read((Repository)repository, url);
        return repository;
    }

    public static final void read(Repository repository, URL url) throws RepositoryException, RDFParseException, IOException {
        RepositoryConnection connection = repository.getConnection();
        connection.add(url, null, RDFFormat.forFileName((String)url.toString(), (RDFFormat)RDFFormat.RDFXML), new Resource[0]);
        connection.commit();
        connection.close();
    }

    public static void importXML(MatrixContext<String, String> context, String url, String query) {
        try {
            SPARQLResultsXMLParser parser = new SPARQLResultsXMLParser();
            parser.setTupleQueryResultHandler((TupleQueryResultHandler)new ContextTupleQueryResultHandler(context));
            String queryURL = new String(url).replace("<QUERY>", URLEncoder.encode(query, "UTF-8"));
            System.out.println("reading " + queryURL);
            InputStream stream = new URL(queryURL).openStream();
            System.out.println("parsing results");
            parser.parseQueryResult(stream);
            System.out.println("parse done");
        }
        catch (IOException | QueryResultHandlerException | QueryResultParseException e) {
            e.printStackTrace();
        }
    }

    public static void importRepository(MatrixContext<String, String> context, Repository repo, String query) {
        try {
            RepositoryConnection connection = repo.getConnection();
            connection.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate((TupleQueryResultHandler)new ContextTupleQueryResultHandler(context));
            connection.close();
        }
        catch (MalformedQueryException | QueryEvaluationException | TupleQueryResultHandlerException | RepositoryException e) {
            e.printStackTrace();
        }
    }

    public static void importFile(MatrixContext<String, String> context, File file, String query) {
        try {
            RDFImporter.importRepository(context, RDFImporter.read(file), query);
        }
        catch (IOException | RepositoryException | RDFParseException e) {
            e.printStackTrace();
        }
    }

    public static void importURL(MatrixContext<String, String> context, String url, String query) {
        try {
            RDFImporter.importRepository(context, RDFImporter.read(new URL(url)), query);
        }
        catch (IOException | RepositoryException | RDFParseException e) {
            e.printStackTrace();
        }
    }

    public static final OWLInterpretation extractInterpretation(List<Statement> triples) {
        return RDFImporter.extractInterpretation(triples, IRI.create((String)RDF.TYPE.stringValue()));
    }

    public static final OWLInterpretation extractInterpretation(List<Statement> triples, IRI selectedIsARoleName) {
        List<IRI> roleNames = triples.parallelStream().map(triple -> IRI.create((String)triple.getPredicate().stringValue())).distinct().collect(Collectors.toList());
        if (!roleNames.contains(selectedIsARoleName)) {
            throw new IllegalArgumentException();
        }
        roleNames.remove(selectedIsARoleName);
        List<IRI> conceptNames = triples.parallelStream().filter(triple -> IRI.create((String)triple.getPredicate().stringValue()).equals((Object)selectedIsARoleName)).map(triple -> IRI.create((String)triple.getObject().stringValue())).collect(Collectors.toList());
        return RDFImporter.extractInterpretation(triples, conceptNames, roleNames, selectedIsARoleName);
    }

    public static final OWLInterpretation extractInterpretation(List<Statement> triples, List<IRI> selectedConceptNames, List<IRI> selectedRoleNames, IRI selectedIsARoleName) {
        Signature signature = new Signature(null);
        signature.getConceptNames().addAll(selectedConceptNames);
        signature.getRoleNames().addAll(selectedRoleNames);
        signature.getIndividualNames().addAll(triples.parallelStream().filter(triple -> IRI.create((String)triple.getPredicate().stringValue()).equals((Object)selectedIsARoleName) && signature.getConceptNames().contains(IRI.create((String)triple.getObject().stringValue()))).map(triple -> IRI.create((String)triple.getSubject().stringValue())).collect(Collectors.toSet()));
        OWLInterpretation i = new OWLInterpretation(signature);
        triples.stream().forEach(triple -> {
            if (IRI.create((String)triple.getPredicate().stringValue()).equals((Object)selectedIsARoleName)) {
                if (signature.getConceptNames().contains(IRI.create((String)triple.getObject().stringValue())) && signature.getIndividualNames().contains(IRI.create((String)triple.getSubject().stringValue()))) {
                    i.addConceptNameAssertion(IRI.create((String)triple.getObject().stringValue()), IRI.create((String)triple.getSubject().stringValue()));
                }
            } else if (signature.getRoleNames().contains(IRI.create((String)triple.getPredicate().stringValue())) && signature.getIndividualNames().contains(IRI.create((String)triple.getSubject().stringValue())) && signature.getIndividualNames().contains(IRI.create((String)triple.getObject().stringValue()))) {
                i.addRoleNameAssertion(IRI.create((String)triple.getPredicate().stringValue()), IRI.create((String)triple.getSubject().stringValue()), IRI.create((String)triple.getObject().stringValue()));
            }
        });
        return i;
    }

    private static /* synthetic */ StatementImpl lambda$readCSV$1(ValueFactory f, File file, String[] tuple) {
        return new StatementImpl((Resource)f.createURI(file.getName() + ":", tuple[0]), f.createURI(file.getName() + ":", tuple[1]), (Value)f.createURI(file.getName() + ":", tuple[2]));
    }

    private static final class ContextTupleQueryResultHandler
    implements TupleQueryResultHandler {
        private final MatrixContext<String, String> context;
        private boolean objectTuples = true;
        private boolean attributeTuples = true;
        private final List<String> objectBindingNames = new ArrayList<String>();
        private final List<String> attributeBindingNames = new ArrayList<String>();
        private final SetList<String> objects = new HashSetArrayList<String>();
        private final SetList<String> attributes = new HashSetArrayList<String>();
        private final Set<Pair<String, String>> crosses = new HashSet<Pair<String, String>>();

        private ContextTupleQueryResultHandler(MatrixContext<String, String> context) {
            this.context = context;
            context.rowHeads().add("null");
            context.colHeads().add("null");
        }

        public void handleBoolean(boolean value) throws QueryResultHandlerException {
            System.out.println("handle boolean " + value);
        }

        public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
            System.out.println("handle links " + linkUrls);
        }

        public final void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
            for (String bindingName : bindingNames) {
                if (bindingName.toLowerCase().startsWith("object")) {
                    this.objectBindingNames.add(bindingName);
                    continue;
                }
                if (!bindingName.toLowerCase().startsWith("attribute")) continue;
                this.attributeBindingNames.add(bindingName);
            }
            if (this.objectBindingNames.size() == 1) {
                this.objectTuples = false;
            }
            if (this.attributeBindingNames.size() == 1) {
                this.attributeTuples = false;
            }
        }

        public final void endQueryResult() throws TupleQueryResultHandlerException {
            System.out.println("adding " + this.objects.size() + " objects");
            this.context.rowHeads().addAll(0, this.objects);
            System.out.println("adding " + this.attributes.size() + " attributes");
            this.context.colHeads().addAll(0, this.attributes);
            this.context.rowHeads().remove("null");
            this.context.colHeads().remove("null");
            System.out.println("adding " + this.crosses.size() + " crosses");
            for (Pair<String, String> p : this.crosses) {
                this.context.addFastSilent(p.x(), p.y());
            }
            this.context.pushAllChangedEvent();
        }

        public final void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
            String object = "";
            String attribute = "";
            if (this.objectTuples) {
                for (String objectBindingName : this.objectBindingNames) {
                    object = object + bindingSet.getBinding(objectBindingName).getValue().stringValue() + "; ";
                }
                object = object.substring(0, object.length() - 2);
            } else {
                object = bindingSet.getBinding(this.objectBindingNames.get(0)).getValue().stringValue();
            }
            if (this.attributeTuples) {
                for (String attributeBindingName : this.attributeBindingNames) {
                    attribute = attribute + bindingSet.getBinding(attributeBindingName).getValue().stringValue() + "; ";
                }
                attribute = attribute.substring(0, attribute.length() - 2);
            } else {
                attribute = bindingSet.getBinding(this.attributeBindingNames.get(0)).getValue().stringValue();
            }
            this.objects.add(object);
            this.attributes.add(attribute);
            this.crosses.add(Pair.of(object, attribute));
        }
    }
}

