/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.layout.ConceptMovement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point3D;

public abstract class ConceptLayout<G, M, P extends ObservableValue<Point3D>>
implements Observable {
    protected boolean observe = false;
    public final ConceptLattice<G, M> lattice;
    protected final Map<Concept<G, M>, P> positionBindings = new ConcurrentHashMap<Concept<G, M>, P>();
    public final Map<Concept<G, M>, Concept<G, M>> generators = new ConcurrentHashMap<Concept<G, M>, Concept<G, M>>();
    private final Set<InvalidationListener> listeners = new HashSet<InvalidationListener>();

    protected ConceptLayout(ConceptLattice<G, M> conceptLattice) {
        this.lattice = conceptLattice;
    }

    public final void observe() {
        if (this.observe) {
            return;
        }
        this.observe = true;
        this.lattice.addEventHandler(e -> e.getRows().forEach(this::getOrAddPosition), RelationEvent.ROWS_ADDED);
        this.lattice.addEventHandler(e -> e.getRows().forEach(this::disposePosition), RelationEvent.ROWS_REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final P getOrAddPosition(Concept<G, M> concept) {
        Map<Concept<G, M>, P> map = this.positionBindings;
        synchronized (map) {
            return (P)this.positionBindings.computeIfAbsent(concept, this::newPositionBinding);
        }
    }

    protected abstract P newPositionBinding(Concept<G, M> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final P getPosition(Concept<G, M> c) {
        Map<Concept<G, M>, P> map = this.positionBindings;
        synchronized (map) {
            return (P)((ObservableValue)this.positionBindings.get(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposePosition(Concept<G, M> concept) {
        Map<Concept<G, M>, P> map = this.positionBindings;
        synchronized (map) {
            ObservableValue p = (ObservableValue)this.positionBindings.remove(concept);
            if (p instanceof Binding) {
                ((Binding)p).dispose();
            }
        }
    }

    protected final void initializePositionBindings() {
        for (Concept concept : this.lattice.rowHeads()) {
            this.getOrAddPosition(concept);
        }
    }

    public abstract void rotate(double var1);

    public abstract void move(Concept<G, M> var1, ConceptMovement var2, Point3D var3);

    public abstract void deleteZ();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BoundingBox getCurrentBoundingBox(boolean hideBottom, boolean hideTop) {
        Map<Concept<G, M>, P> map = this.positionBindings;
        synchronized (map) {
            double xmin = Double.MAX_VALUE;
            double xmax = Double.MIN_VALUE;
            double ymin = Double.MAX_VALUE;
            double ymax = Double.MIN_VALUE;
            double zmin = Double.MAX_VALUE;
            double zmax = Double.MIN_VALUE;
            for (Map.Entry<Concept<G, M>, P> e : this.positionBindings.entrySet()) {
                if (hideBottom && e.getKey().getIntent().containsAll(this.lattice.context.colHeads()) || hideTop && e.getKey().getExtent().containsAll(this.lattice.context.rowHeads())) continue;
                Point3D p = (Point3D)((ObservableValue)e.getValue()).getValue();
                xmin = Math.min(xmin, p.getX());
                xmax = Math.max(xmax, p.getX());
                ymin = Math.min(ymin, p.getY());
                ymax = Math.max(ymax, p.getY());
                zmin = Math.min(zmin, p.getZ());
                zmax = Math.max(zmax, p.getZ());
            }
            double dx = xmax - xmin;
            double dy = ymax - ymin;
            double dz = zmax - zmin;
            return new BoundingBox(xmin, ymin, zmin, dx, dy, dz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        Set<InvalidationListener> set = this.listeners;
        synchronized (set) {
            for (InvalidationListener listener : this.listeners) {
                listener.invalidated((Observable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(InvalidationListener listener) {
        Set<InvalidationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(InvalidationListener listener) {
        Set<InvalidationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }
}

