/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.layout.ChainDecomposer;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.layout.LayoutEvolution;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point3D;
import org.ujmp.core.util.RandomSimple;

public final class GeneticLayouter<G, M> {
    public static final <G, M> TimeTask<Void> initialSeeds(final FCADataset<G, M> dataset) {
        return new TimeTask<Void>(dataset, "Initial Seeds and Labels"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final Void call() {
                Object object;
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                RandomSimple rng = new RandomSimple();
                this.updateMessage("Computing Infimum Irreducibles...");
                Set supremumIrreducibles = dataset.layout.lattice.context.selection.supremumIrreducibles();
                Set infimumIrreducibles = dataset.layout.lattice.context.selection.infimumIrreducibles();
                this.updateProgress(0.2, 1.0);
                this.updateProgress(0.3, 1.0);
                this.updateMessage("Generating Layered Random Seeds...");
                HashMap randomSeedsG = new HashMap();
                HashMap<Object, Point3D> randomSeedsM = new HashMap<Object, Point3D>();
                for (Object g : supremumIrreducibles) {
                    randomSeedsG.put(g, new Point3D(2.0 * rng.nextDouble() - 1.0, 1.0, 0.0));
                }
                for (Object m : infimumIrreducibles) {
                    randomSeedsM.put(m, new Point3D(2.0 * rng.nextDouble() - 1.0, 1.0, 0.0));
                }
                this.updateProgress(0.4, 1.0);
                dataset.layout.updateSeeds(randomSeedsG, randomSeedsM);
                this.updateProgress(0.5, 1.0);
                this.updateMessage("Computing Attribute Labels...");
                for (Concept c : dataset.layout.lattice.rowHeads()) {
                    HashSet attributeLabels = new HashSet(dataset.layout.lattice.context.selection.attributeLabels(c.extent(), c.intent()));
                    object = dataset.layout.lattice.attributeConcepts;
                    synchronized (object) {
                        for (Object m : attributeLabels) {
                            dataset.layout.lattice.attributeConcepts.put(m, (Object)c);
                        }
                    }
                }
                this.updateProgress(0.75, 1.0);
                this.updateMessage("Computing Object Labels...");
                for (Concept c : dataset.layout.lattice.rowHeads()) {
                    HashSet objectLabels = new HashSet(dataset.layout.lattice.context.selection.objectLabels(c.extent(), c.intent()));
                    object = dataset.layout.lattice.objectConcepts;
                    synchronized (object) {
                        for (Object g : objectLabels) {
                            dataset.layout.lattice.objectConcepts.put(g, (Object)c);
                        }
                    }
                }
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    public static final <G, M> TimeTask<Void> seeds(final FCADataset<G, M> dataset, final boolean includingLayout, final int generationCount, final int populationSize) {
        return new TimeTask<Void>(dataset, "Genetic Layouter"){
            private final DoubleProperty evolutionaryProgressProperty;
            private final Set<AdditiveConceptLayout<G, M>> layouts;
            private double currentQuality;
            private AdditiveConceptLayout<G, M> currentBest;
            private ChainDecomposer<Set<Integer>> chainDecomposerG;
            private ChainDecomposer<Set<Integer>> chainDecomposerM;
            private Random rng;
            {
                super(dataset2, title);
                this.evolutionaryProgressProperty = new SimpleDoubleProperty(0.0);
                this.layouts = new HashSet(populationSize);
                this.currentQuality = -1.0;
                this.rng = new RandomSimple();
            }

            protected final void updateProgress(double workDone, double max) {
                super.updateProgress(workDone, max);
                this.evolutionaryProgressProperty.set(workDone / max);
            }

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.1, 1.0);
                this.updateMessage("Decomposing Concept Lattice...");
                MatrixRelation cxt = dataset.layout.lattice.context.selection._reduced.clone();
                this.chainDecomposerG = new ChainDecomposer(((MatrixContext)cxt).objectQuasiOrder().neighborhood());
                this.chainDecomposerM = new ChainDecomposer(((MatrixContext)cxt).attributeQuasiOrder().neighborhood());
                if (includingLayout) {
                    this.layouts.add((AdditiveConceptLayout)dataset.layout.clone());
                    this.currentBest = dataset.layout;
                }
                this.updateProgress(0.2, 1.0);
                this.updateMessage("Setting up Evolution Engine...");
                this.initPopulation();
                this.updateProgress(0.3, 1.0);
                this.updateMessage("Evolving Layout...");
                this.evolvePopulation();
                this.updateProgress(1.0, 1.0);
                return null;
            }

            private final void initPopulation() {
                int i;
                HashSet futures = new HashSet();
                int n = i = includingLayout ? 1 : 0;
                while (i < populationSize) {
                    futures.add(ConExpFX.instance.executor.tpe.submit(this.generate()));
                    ++i;
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }

            private final Runnable generate() {
                return new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (!dataset.conceptGraph.polar()) {
                            int w;
                            AdditiveConceptLayout candidate = new AdditiveConceptLayout(dataset.layout.lattice, null, null, AdditiveConceptLayout.Type.HYBRID);
                            Set chainsG = chainDecomposerG.randomChainDecomposition();
                            Set chainsM = chainDecomposerM.randomChainDecomposition();
                            int v = chainsG.size();
                            if (v == 1) {
                                Point3D seed = new Point3D(0.0, 1.0, 0.0);
                                for (Iterator g : Collections2.transform((Collection)((Collection)Iterables.getOnlyElement(chainsG)), candidate.lattice.context.selection._firstObject)) {
                                    candidate.seedsG.put(g, (Object)seed);
                                }
                            } else {
                                int vv = v * v;
                                BitSetFX usedX = new BitSetFX();
                                for (Set chain : chainsG) {
                                    int _x = rng.nextInt(vv + 1);
                                    while (usedX.contains(_x) || usedX.contains(_x + 1) || _x != 0 && usedX.contains(_x - 1)) {
                                        _x = rng.nextInt(vv + 1);
                                    }
                                    usedX.add(_x);
                                    int __x = _x - vv / 2;
                                    Point3D seed = new Point3D((double)__x, (double)(rng.nextInt(Math.abs(__x + 1) + 1) + 1), dataset.conceptGraph.threeDimensions() ? (double)(rng.nextInt(Math.abs(__x + 1) + 1) - __x / 2) : 0.0);
                                    for (Object g : Collections2.transform(chain, candidate.lattice.context.selection._firstObject)) {
                                        candidate.seedsG.put(g, (Object)seed);
                                    }
                                }
                            }
                            if ((w = chainsM.size()) == 1) {
                                Point3D seed = new Point3D(0.0, 1.0, 0.0);
                                for (Set m : Collections2.transform((Collection)((Collection)Iterables.getOnlyElement(chainsM)), candidate.lattice.context.selection._firstAttribute)) {
                                    candidate.seedsM.put(m, (Object)seed);
                                }
                            } else {
                                int ww = w * w;
                                BitSetFX usedX = new BitSetFX();
                                for (Set chain : chainsM) {
                                    int _x = rng.nextInt(ww + 1);
                                    while (usedX.contains(_x) || usedX.contains(_x + 1) || _x != 0 && usedX.contains(_x - 1)) {
                                        _x = rng.nextInt(ww + 1);
                                    }
                                    usedX.add(_x);
                                    int __x = _x - ww / 2;
                                    Point3D seed = new Point3D((double)__x, (double)(rng.nextInt(Math.abs(__x + 1) + 1) + 1), dataset.conceptGraph.threeDimensions() ? (double)(rng.nextInt(Math.abs(__x + 1) + 1) - __x / 2) : 0.0);
                                    for (Object m : Collections2.transform(chain, candidate.lattice.context.selection._firstAttribute)) {
                                        candidate.seedsM.put(m, (Object)seed);
                                    }
                                }
                            }
                            Set ww = layouts;
                            synchronized (ww) {
                                layouts.add(candidate);
                            }
                            double result = dataset.conflictDistance.apply(candidate).second();
                            if (result > currentQuality || currentBest == null) {
                                currentQuality = result;
                                currentBest = candidate;
                            }
                        }
                    }
                };
            }

            private final AdditiveConceptLayout<G, M> crossover(AdditiveConceptLayout<G, M> l1, AdditiveConceptLayout<G, M> l2) {
                Object l = l1.clone();
                return null;
            }

            private final void evolvePopulation() {
                if (!dataset.conceptGraph.polar()) {
                    for (int i = 0; i < generationCount; ++i) {
                        dataset.layout.updateSeeds(this.currentBest.seedsG, this.currentBest.seedsM);
                        this.updateProgress(0.3 + 0.7 * (double)i / (double)generationCount, 1.0);
                        this.updateMessage("Evolving Seeds: " + i + " of " + generationCount + " Generations...");
                        this.evolveGeneration();
                    }
                    dataset.layout.updateSeeds(this.currentBest.seedsG, this.currentBest.seedsM);
                }
            }

            private final void evolveGeneration() {
                if (!dataset.conceptGraph.polar()) {
                    this.currentQuality = -1.0;
                    for (AdditiveConceptLayout candidate : this.layouts) {
                        LayoutEvolution.Value v = new LayoutEvolution(candidate, dataset.conflictDistance.apply(candidate).first(), ConceptMovement.INTENT_CHAIN_SEEDS, 4.0, 4.0, 2, 2, 1, dataset.conflictDistance, ConExpFX.instance.executor.tpe).calculate();
                        if (!candidate.updateSeeds(v.seedsG, v.seedsM)) {
                            v = new LayoutEvolution(candidate, (Concept)Collections3.random(candidate.lattice.rowHeads(), this.rng), ConceptMovement.INTENT_CHAIN_SEEDS, 4.0, 4.0, 2, 2, 1, dataset.conflictDistance, ConExpFX.instance.executor.tpe).calculate();
                            candidate.updateSeeds(v.seedsG, v.seedsM);
                        }
                        if (!(v.result > this.currentQuality)) continue;
                        this.currentQuality = v.result;
                        this.currentBest = candidate;
                    }
                }
            }
        };
    }
}

