/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import com.google.common.collect.Maps;
import conexp.fx.core.collections.ListIterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.math.Points;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.binding.Binding;
import javafx.geometry.Point3D;

public abstract class QualityMeasure<G, M, V>
implements Function<AdditiveConceptLayout<G, M>, V> {
    @Override
    public V apply(AdditiveConceptLayout<G, M> t) {
        return this.compute(t);
    }

    protected abstract V compute(AdditiveConceptLayout<G, M> var1);

    public static final <G, M, V> QualityMeasure<G, M, V> of(final Function<AdditiveConceptLayout<G, M>, V> f) {
        return new QualityMeasure<G, M, V>(){

            @Override
            protected V compute(AdditiveConceptLayout<G, M> layout) {
                return f.apply(layout);
            }
        };
    }

    @SafeVarargs
    public static final <G, M> QualityMeasure<G, M, Double> linearCombination(Pair<Double, QualityMeasure<G, M, Double>> ... weightedMeasures) {
        return QualityMeasure.of(layout -> Stream.of(weightedMeasures).map(p -> (Double)p.first() * (Double)((QualityMeasure)p.second()).apply((AdditiveConceptLayout)layout)).reduce(Double::sum).orElse(0.0));
    }

    public static final <G, M> QualityMeasure<G, M, Double> topBottomXDistance() {
        return QualityMeasure.of(layout -> 1.0 - Math.abs(((Point3D)((Binding)layout.getOrAddPosition(layout.lattice.context.topConcept())).getValue()).getX() - ((Point3D)((Binding)layout.getOrAddPosition(layout.lattice.context.bottomConcept())).getValue()).getX()) / layout.getCurrentBoundingBox(false, false).getWidth());
    }

    public static final <G, M> QualityMeasure<G, M, Double> heightWidthRatio() {
        return QualityMeasure.of(layout -> {
            double h = layout.getCurrentBoundingBox(false, false).getHeight();
            double w = layout.getCurrentBoundingBox(false, false).getWidth();
            double min = Math.min(h, w);
            double max = Math.max(h, w);
            return min / max;
        });
    }

    public static final <G, M> QualityMeasure<G, M, Integer> edgeIntersections() {
        return QualityMeasure.of(layout -> {
            int intersections = 0;
            for (Pair e : ListIterators.upperCartesianDiagonalStrict(layout.lattice)) {
                if (((Concept)((Pair)e.first()).x()).equals(((Pair)e.second()).y()) || ((Concept)((Pair)e.first()).y()).equals(((Pair)e.second()).x()) || !Points.intersectingLineSegments((Point3D)((Binding)layout.getOrAddPosition((Concept)((Pair)e.first()).x())).getValue(), (Point3D)((Binding)layout.getOrAddPosition((Concept)((Pair)e.first()).y())).getValue(), (Point3D)((Binding)layout.getOrAddPosition((Concept)((Pair)e.second()).x())).getValue(), (Point3D)((Binding)layout.getOrAddPosition((Concept)((Pair)e.second()).y())).getValue())) continue;
                ++intersections;
            }
            return intersections;
        });
    }

    public static final <G, M> QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance() {
        return QualityMeasure.of(layout -> {
            Concept bottom;
            double num = 0.0;
            double minC = 1.0;
            double sumC = 0.0;
            double minL = Double.MAX_VALUE;
            double sumL = 0.0;
            Concept faulty = bottom = layout.lattice.context.selection.bottomConcept();
            for (Map.Entry entry : Maps.asMap(layout.lattice.rowHeads(), layout::getOrAddPosition).entrySet()) {
                if (((Concept)entry.getKey()).equals(bottom)) continue;
                Point3D p = (Point3D)((Binding)entry.getValue()).getValue();
                Concept c = (Concept)entry.getKey();
                for (Pair edge : layout.lattice) {
                    if (((Concept)edge.x()).equals(bottom) || c.equals(edge.x()) || c.equals(edge.y())) continue;
                    Point3D q1 = (Point3D)((Binding)layout.getOrAddPosition((Concept)edge.x())).getValue();
                    Point3D q2 = (Point3D)((Binding)layout.getOrAddPosition((Concept)edge.y())).getValue();
                    double length = q1.distance(q2);
                    double conflictDistance = Math.min(Points.pointSegmentDistance(p, q1, q2) / length, 0.5) * 2.0;
                    num += 1.0;
                    minL = Math.min(minL, length);
                    sumL += length;
                    sumC += conflictDistance;
                    if (!(conflictDistance < minC)) continue;
                    minC = conflictDistance;
                    faulty = c;
                }
            }
            double avgC = num == 0.0 ? 1.0 : sumC / num;
            double avgL = num == 0.0 ? 1.0 : sumL / num;
            return Pair.of(faulty, Math.pow(minC * Math.pow(minC / avgC, 0.5) * Math.pow(minL / avgL, 0.25), 0.125));
        });
    }

    public static final <G, M> QualityMeasure<G, M, Integer> parallelEdges() {
        return QualityMeasure.of(layout -> 0);
    }

    public static final <G, M> QualityMeasure<G, M, Integer> distinctDirections() {
        return QualityMeasure.of(layout -> 0);
    }

    public static final <G, M> QualityMeasure<G, M, Integer> distinctAngles() {
        return QualityMeasure.of(layout -> 0);
    }
}

