/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import conexp.fx.core.collections.ListIterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.layout.ConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.math.Points;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point3D;

public class SimpleConceptLayout<G, M>
extends ConceptLayout<G, M, SimpleObjectProperty<Point3D>> {
    private final Queue<Pair<Concept<G, M>, Point3D>> moves = new ConcurrentLinkedQueue<Pair<Concept<G, M>, Point3D>>();
    private Thread thread;
    private final long delay = 400L;

    public SimpleConceptLayout(ConceptLattice<G, M> conceptLattice) {
        super(conceptLattice);
        this.start();
    }

    @Override
    protected SimpleObjectProperty<Point3D> newPositionBinding(Concept<G, M> concept) {
        return new SimpleObjectProperty((Object)Point3D.ZERO);
    }

    @Override
    public void rotate(double angle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Concept<G, M> concept, ConceptMovement movement, Point3D delta) {
        Queue<Pair<Concept<G, M>, Point3D>> queue = this.moves;
        synchronized (queue) {
            this.moves.offer(Pair.of(concept, delta));
        }
    }

    private final void _move(Concept<G, M> concept, Point3D delta) {
        SimpleObjectProperty p = (SimpleObjectProperty)this.getOrAddPosition(concept);
        p.setValue((Object)((Point3D)p.getValue()).add(delta));
        this.invalidate();
    }

    @Override
    public void deleteZ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        SimpleConceptLayout simpleConceptLayout = this;
        synchronized (simpleConceptLayout) {
            if (this.thread == null) {
                this.thread = new Thread(() -> {
                    try {
                        while (true) {
                            this.evolveLayout();
                            Thread.sleep(400L);
                        }
                    }
                    catch (InterruptedException e) {
                        System.err.println("Force interrupted.");
                        return;
                    }
                }, SimpleConceptLayout.class.getName());
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        SimpleConceptLayout simpleConceptLayout = this;
        synchronized (simpleConceptLayout) {
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void evolveLayout() {
        double k = this.getK();
        ConcurrentHashMap deltas = new ConcurrentHashMap();
        this.lattice.rowHeads().forEach(c -> deltas.put((Concept)c, Point3D.ZERO));
        Map map = this.positionBindings;
        synchronized (map) {
            this.computeAdjacentNodeForces(k, deltas);
            this.computeNodeForces(k, deltas);
            Queue<Pair<Concept<G, M>, Point3D>> queue = this.moves;
            synchronized (queue) {
                Pair move = this.moves.poll();
                while (move != null) {
                    Pair _move = move;
                    deltas.compute(_move.x(), (c, d) -> d.add((Point3D)_move.y()));
                    move = this.moves.poll();
                }
            }
            deltas.replaceAll((c, d) -> {
                if (Double.isFinite(d.getX()) && Double.isFinite(d.getY()) && Double.isFinite(d.getZ())) {
                    return d;
                }
                return new Point3D(Math.random(), Math.random(), 0.0).normalize();
            });
            deltas.forEach((concept, delta) -> this._move((Concept<G, M>)concept, (Point3D)delta));
        }
    }

    private final double getMaximalNodeDistance() {
        double size = 0.0;
        for (Concept c1 : this.lattice.rowHeads()) {
            for (Concept c2 : this.lattice.rowHeads()) {
                size = Math.max(size, ((Point3D)((SimpleObjectProperty)this.getPosition(c1)).getValue()).subtract((Point3D)((SimpleObjectProperty)this.getPosition(c2)).getValue()).magnitude());
            }
        }
        return size;
    }

    private final double getK() {
        BoundingBox box = this.getCurrentBoundingBox(false, false);
        double area = box.getWidth() * box.getHeight();
        double n = this.lattice.rowHeads().size();
        return Math.sqrt(area / n);
    }

    private final void adjustWH(Map<Concept<G, M>, Point3D> deltas) {
        BoundingBox box = this.getCurrentBoundingBox(false, false);
        double wh = box.getWidth() / box.getHeight();
        deltas.replaceAll((__, delta) -> new Point3D(delta.getX(), delta.getY() * wh, delta.getZ()));
    }

    private final void computeAdjacentNodeForces(double k, Map<Concept<G, M>, Point3D> deltas) {
        for (Pair edge : this.lattice) {
            Point3D delta1 = deltas.get(edge.x());
            Point3D delta2 = deltas.get(edge.y());
            Point3D q1 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)edge.x())).getValue();
            Point3D q2 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)edge.y())).getValue();
            Point3D q = q2.subtract(q1);
            double x = Math.log1p(q.magnitude()) / k;
            Point3D q0 = q.normalize().multiply(x);
            delta1 = delta1.add(q0);
            delta2 = delta2.subtract(q0);
            if (q.getY() > 0.0) {
                double dx = -q.getY();
                delta2.subtract(0.0, dx, 0.0);
                delta1.add(0.0, dx, 0.0);
            }
            deltas.put((Concept<G, M>)edge.x(), delta1);
            deltas.put((Concept<G, M>)edge.y(), delta2);
        }
    }

    private final void computeNodeForces(double k, Map<Concept<G, M>, Point3D> deltas) {
        for (Pair pair : ListIterators.upperCartesianDiagonalStrict(this.lattice.rowHeads())) {
            Point3D delta1 = deltas.get(pair.x());
            Point3D delta2 = deltas.get(pair.y());
            Point3D q1 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)pair.x())).getValue();
            Point3D q2 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)pair.y())).getValue();
            Point3D q = q2.subtract(q1);
            double x = Math.pow(k, 2.0) / q.magnitude();
            Point3D q0 = q.normalize().multiply(x);
            delta1 = delta1.subtract(q0);
            delta2 = delta2.add(q0);
            deltas.put((Concept<G, M>)pair.x(), delta1);
            deltas.put((Concept<G, M>)pair.y(), delta2);
        }
    }

    private final void computeNodeEdgeForces(double k, Map<Concept<G, M>, Point3D> deltas) {
        for (Concept concept : this.lattice.rowHeads()) {
            Point3D delta = deltas.get(concept);
            Point3D p = (Point3D)((SimpleObjectProperty)this.getOrAddPosition(concept)).getValue();
            for (Pair edge : this.lattice) {
                if (((Concept)edge.x()).equals(concept) || ((Concept)edge.y()).equals(concept)) continue;
                Point3D delta1 = deltas.get(edge.x());
                Point3D delta2 = deltas.get(edge.y());
                Point3D q1 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)edge.x())).getValue();
                Point3D q2 = (Point3D)((SimpleObjectProperty)this.getOrAddPosition((Concept)edge.y())).getValue();
                Point3D q = Points.shortestVectorFromLineSegment(p, q1, q2);
                double x = Math.pow(k, 2.0) / Math.pow(q.magnitude(), 2.0);
                Point3D q0 = q.normalize().multiply(x);
                delta1 = delta1.add(q0.multiply(-0.5));
                delta2 = delta2.add(q0.multiply(-0.5));
                delta = delta.add(q0.multiply(1.0));
                deltas.put((Concept<G, M>)edge.x(), delta1);
                deltas.put((Concept<G, M>)edge.y(), delta2);
            }
            deltas.put(concept, delta);
        }
    }
}

