/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import com.google.common.base.Function;

public abstract class GuavaIsomorphism<A, B>
implements Function<A, B> {
    public static final <A> GuavaIsomorphism<A, A> identity() {
        return new GuavaIsomorphism<A, A>(){

            public A apply(A a) {
                return a;
            }

            @Override
            public A invert(A a) {
                return a;
            }
        };
    }

    public static final <A, B> GuavaIsomorphism<A, B> create(final Function<A, B> function, final Function<B, A> inverse) {
        return new GuavaIsomorphism<A, B>(){

            public final B apply(A a) {
                return function.apply(a);
            }

            @Override
            public final A invert(B b) {
                return inverse.apply(b);
            }

            @Override
            public Function<A, B> function() {
                return function;
            }

            @Override
            public Function<B, A> inverse() {
                return inverse;
            }
        };
    }

    public static final <A, B> GuavaIsomorphism<B, A> invert(final GuavaIsomorphism<A, B> isomorphism) {
        return new GuavaIsomorphism<B, A>(){

            public final A apply(B b) {
                return isomorphism.invert(b);
            }

            @Override
            public final B invert(A a) {
                return isomorphism.apply(a);
            }

            @Override
            public Function<B, A> function() {
                return isomorphism.inverse();
            }

            @Override
            public Function<A, B> inverse() {
                return isomorphism.function();
            }
        };
    }

    public static final <A, B, C> GuavaIsomorphism<A, C> compose(final GuavaIsomorphism<A, B> isomorphism1, final GuavaIsomorphism<B, C> isomorphism2) {
        return new GuavaIsomorphism<A, C>(){

            public final C apply(A a) {
                return isomorphism2.apply(isomorphism1.apply(a));
            }

            @Override
            public final A invert(C c) {
                return isomorphism1.invert(isomorphism2.invert(c));
            }
        };
    }

    public A invert(B b) {
        throw new RuntimeException();
    }

    public Function<A, B> function() {
        return this;
    }

    public Function<B, A> inverse() {
        return new Function<B, A>(){

            public final A apply(B b) {
                return GuavaIsomorphism.this.invert(b);
            }
        };
    }

    public final java.util.function.Function<A, B> toJavaFunction() {
        return a -> this.apply(a);
    }

    public final java.util.function.Function<B, A> inverseToJavaFunction() {
        return b -> this.invert(b);
    }
}

