/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import com.sun.javafx.geom.Line2D;
import java.util.Collection;
import java.util.NoSuchElementException;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;

public final class Points {
    public static final Point2D projectOnCircle(double cx, double cy, double r, double px, double py) {
        double dx = px - cx;
        double dy = py - cy;
        double l = Math.sqrt(dx * dx + dy * dy);
        double f = r / l;
        double x = cx + f * dx;
        double y = cx + f * dy;
        return new Point2D(x, y);
    }

    public static final Point3D absoluteSum(Collection<Point3D> c) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point3D p : c) {
            x += Math.abs(p.getX());
            y += Math.abs(p.getY());
            z += Math.abs(p.getZ());
        }
        return new Point3D(x, y, z);
    }

    public static final Point3D rotate(Point3D point, double angle) {
        double x = point.getX() * Math.cos(angle) + point.getZ() * Math.sin(angle);
        double y = point.getY();
        double z = -point.getX() * Math.sin(angle) + point.getZ() * Math.cos(angle);
        return new Point3D(x, y, z);
    }

    public static final double pointSegmentDistance(Point3D p, Point3D q1, Point3D q2) {
        if (p.equals((Object)q1) || p.equals((Object)q2)) {
            return 0.0;
        }
        if (q1.equals((Object)q2)) {
            return p.distance(q1);
        }
        Point3D q = q2.subtract(q1);
        double t = p.subtract(q1).dotProduct(q) / q.dotProduct(q);
        if (t < 0.0) {
            return p.distance(q1);
        }
        if (t > 1.0) {
            return p.distance(q2);
        }
        return p.distance(q1.add(q.multiply(t)));
    }

    public static final boolean intersectX(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        return Math.max(p1.getX(), p2.getX()) >= Math.min(q1.getX(), q2.getX()) && Math.max(q1.getX(), q2.getX()) >= Math.min(p1.getX(), p2.getX());
    }

    public static final boolean intersectY(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        return Math.max(p1.getY(), p2.getY()) >= Math.min(q1.getY(), q2.getY()) && Math.max(q1.getY(), q2.getY()) >= Math.min(p1.getY(), p2.getY());
    }

    public static final boolean intersectXY(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        return new Line2D((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY()).intersectsLine(new Line2D((float)q1.getX(), (float)q1.getY(), (float)q2.getX(), (float)q2.getY()));
    }

    public static final Point2D projectXY(Point3D p) {
        return new Point2D(p.getX(), p.getY());
    }

    public static final boolean intersectingLineSegments(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        Point3D p = p2.subtract(p1);
        Point3D q = q2.subtract(q1);
        Point3D c1 = p.crossProduct(q);
        Point3D c2 = q1.subtract(p1).crossProduct(q);
        Point3D d1 = q.crossProduct(p);
        Point3D d2 = p1.subtract(q1).crossProduct(p);
        try {
            double s = Points.solve(c1, c2);
            if (s < 0.0 || s > 1.0) {
                return false;
            }
            double t = Points.solve(d1, d2);
            if (t >= 0.0 && t <= 1.0) {
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    public static final double solve(Point3D p, Point3D q) throws NoSuchElementException {
        if (p.normalize().equals((Object)q.normalize())) {
            if (p.equals((Object)Point3D.ZERO)) {
                return 1.0;
            }
            return q.magnitude() / p.magnitude();
        }
        throw new NoSuchElementException();
    }

    public static final boolean parallelLineSegments(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        Point3D p = p2.subtract(p1);
        Point3D q = q2.subtract(q1);
        return p.normalize().crossProduct(q.normalize()).magnitude() < 0.01;
    }

    public static final double cosAngle(Point3D p1, Point3D p2, Point3D q1, Point3D q2) {
        Point3D p = p2.subtract(p1);
        Point3D q = q2.subtract(q1);
        return p.normalize().dotProduct(q.normalize());
    }

    public static final double solve(Point3D p, Point3D q1, Point3D q2) {
        Point3D q = q2.subtract(q1);
        Point3D x = p.subtract(q1);
        return x.dotProduct(q) / q.dotProduct(q);
    }

    public static final Point3D projectToLine(Point3D p, Point3D q1, Point3D q2) {
        double t = Points.solve(p, q1, q2);
        return q1.add(q2.subtract(q1).multiply(t));
    }

    public static final Point3D projectToLineSegment(Point3D p, Point3D q1, Point3D q2) {
        double t = Math.min(Math.max(Points.solve(p, q1, q2), 0.0), 1.0);
        return q1.add(q2.subtract(q1).multiply(t));
    }

    public static final Point3D shortestVectorFromLineSegment(Point3D p, Point3D q1, Point3D q2) {
        return p.subtract(Points.projectToLineSegment(p, q1, q2));
    }
}

