/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.util;

import conexp.fx.core.math.Math3;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public class Meter<T> {
    private final Supplier<T> supplier;
    private final BinaryOperator<T> operator;
    private final Function<T, String> formatter;
    private T origin;

    public static final Meter<Long> newNanoStopWatch() {
        return new Meter<Long>(System::nanoTime, (x, y) -> x - y, Math3::formatNanos);
    }

    public static final Meter<Long> newMilliStopWatch() {
        return new Meter<Long>(System::currentTimeMillis, (x, y) -> x - y, Math3::formatMillis);
    }

    private Meter(Supplier<T> supplier, BinaryOperator<T> operator, Function<T, String> formatter) {
        this.supplier = supplier;
        this.operator = operator;
        this.formatter = formatter;
        this.origin = supplier.get();
    }

    public final T measure() {
        return (T)this.operator.apply(this.supplier.get(), this.origin);
    }

    public final String measureAndFormat() {
        return this.formatter.apply(this.measure());
    }

    public final void reset() {
        this.origin = this.supplier.get();
    }
}

